/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.cdi.core.CDIUtil;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.IInjectionPoint;
import org.jboss.tools.cdi.core.IProducerField;
import org.jboss.tools.cdi.core.IScope;
import org.jboss.tools.cdi.core.IScopeDeclaration;
import org.jboss.tools.cdi.core.IStereotype;
import org.jboss.tools.cdi.core.IStereotypeDeclaration;
import org.jboss.tools.cdi.internal.core.impl.AnnotationDeclaration;
import org.jboss.tools.cdi.internal.core.impl.BeanField;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.java.IParametedType;
import org.jboss.tools.common.java.ITypeDeclaration;
import org.jboss.tools.common.java.ParametedType;
import org.jboss.tools.common.text.ITextSourceReference;

public class ProducerField
extends BeanField
implements IProducerField {
    @Override
    public Collection<ITypeDeclaration> getAllTypeDeclarations() {
        ArrayList<ITypeDeclaration> result = new ArrayList<ITypeDeclaration>(1);
        if (this.typeDeclaration != null) {
            result.add((ITypeDeclaration)this.typeDeclaration);
        }
        return result;
    }

    @Override
    public IAnnotationDeclaration getAlternativeDeclaration() {
        return this.getDefinition().getAlternativeAnnotation();
    }

    @Override
    public IType getBeanClass() {
        return this.getClassBean().getBeanClass();
    }

    @Override
    public Collection<IInjectionPoint> getInjectionPoints() {
        return new ArrayList<IInjectionPoint>(0);
    }

    @Override
    public Collection<IParametedType> getLegalTypes() {
        AnnotationDeclaration d = this.getDefinition().getTypedAnnotation();
        Collection<IParametedType> all = this.getAllTypes();
        if (d != null) {
            HashSet<ITypeDeclaration> result = new HashSet<ITypeDeclaration>(this.getRestrictedTypeDeclarations(all));
            ParametedType object = this.getObjectType((IMember)this.getBeanClass());
            if (object != null) {
                result.add((ITypeDeclaration)object);
            }
            return result;
        }
        return all;
    }

    @Override
    public Collection<IParametedType> getAllTypes() {
        if (this.typeDeclaration != null) {
            return this.typeDeclaration.getAllTypes();
        }
        return new ArrayList<IParametedType>(0);
    }

    @Override
    public Collection<ITypeDeclaration> getRestrictedTypeDeclaratios() {
        return this.getRestrictedTypeDeclarations(this.getAllTypes());
    }

    @Override
    public String getName() {
        AnnotationDeclaration named = this.findNamedAnnotation();
        if (named == null) {
            return null;
        }
        Object value = named.getMemberValue(null, true);
        if (value != null && value.toString().trim().length() > 0) {
            return value.toString().trim();
        }
        return this.getField().getElementName();
    }

    @Override
    public ITextSourceReference getNameLocation(boolean stereotypeLocation) {
        return stereotypeLocation ? CDIUtil.getNamedDeclaration(this) : this.findNamedAnnotation();
    }

    @Override
    public IBean getSpecializedBean() {
        return null;
    }

    @Override
    public IAnnotationDeclaration getSpecializesAnnotationDeclaration() {
        return null;
    }

    @Override
    public boolean isDependent() {
        IScope scope = this.getScope();
        return scope != null && "javax.enterprise.context.Dependent".equals(scope.getSourceType().getFullyQualifiedName());
    }

    @Override
    public boolean isEnabled() {
        if (this.classBean != null && !this.classBean.isEnabled()) {
            return false;
        }
        if (this.isAlternative()) {
            if (this.classBean != null && !this.getCDIProject().getAlternatives(this.classBean.getBeanClass().getFullyQualifiedName()).isEmpty()) {
                return true;
            }
            for (IStereotypeDeclaration d : this.getStereotypeDeclarations()) {
                IStereotype s = d.getStereotype();
                if (s == null || !s.isAlternative() || this.getCDIProject().getAlternatives(s.getSourceType().getFullyQualifiedName()).isEmpty()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isSpecializing() {
        return false;
    }

    @Override
    public IScope getScope() {
        Collection<IScopeDeclaration> ds = this.getScopeDeclarations();
        if (!ds.isEmpty()) {
            return ds.iterator().next().getScope();
        }
        IScope defaultScope = null;
        for (IStereotypeDeclaration d : this.getStereotypeDeclarations()) {
            IStereotype s = d.getStereotype();
            IScope sc = s.getScope();
            if (sc == null) continue;
            if (defaultScope == null) {
                defaultScope = sc;
                continue;
            }
            if (defaultScope == sc) continue;
            return null;
        }
        return defaultScope != null ? defaultScope : this.getCDIProject().getScope("javax.enterprise.context.Dependent");
    }

    @Override
    public IAnnotationDeclaration getProducesAnnotation() {
        return this.getDefinition().getProducesAnnotation();
    }

    @Override
    public boolean isSelectedAlternative() {
        if (this.getCDIProject().isTypeAlternative(this.getBeanClass().getFullyQualifiedName())) {
            return true;
        }
        for (IStereotypeDeclaration d : this.getStereotypeDeclarations()) {
            IStereotype s = d.getStereotype();
            if (s == null || !s.isAlternative() || !this.getCDIProject().isStereotypeAlternative(s.getSourceType().getFullyQualifiedName())) continue;
            return true;
        }
        return false;
    }
}

