/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.core.command;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.jboss.tools.ws.core.facet.delegate.IJBossWSFacetDataModelProperties;
import org.jboss.tools.ws.core.messages.JBossWSCoreMessages;
import org.jboss.tools.ws.core.utils.StatusUtils;

public class JBossWSClassPathCommand
extends AbstractDataModelOperation {
    IProject project;
    private IDataModel model;

    public JBossWSClassPathCommand(IProject project, IDataModel model) {
        this.project = project;
        this.model = model;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.executeOverride(monitor);
    }

    public IStatus executeOverride(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        try {
            boolean isServerSupplied = this.model.getBooleanProperty("jboss.ws.is.server.supplied");
            if (isServerSupplied) {
                this.project.setPersistentProperty(IJBossWSFacetDataModelProperties.PERSISTENCE_PROPERTY_SERVER_SUPPLIED_RUNTIME, "true");
                this.project.setPersistentProperty(IJBossWSFacetDataModelProperties.PERSISTENCE_PROPERTY_QNAME_RUNTIME_NAME, null);
                this.project.setPersistentProperty(IJBossWSFacetDataModelProperties.PERSISTENCE_PROPERTY_RNTIME_LOCATION, null);
                this.project.setPersistentProperty(IJBossWSFacetDataModelProperties.PERSISTENCE_PROPERTY_ISDEPLOYED, null);
            } else {
                String runtimeName = this.model.getStringProperty("jboss.ws.runtime_id");
                String runtimeLocation = this.model.getStringProperty("jboss.ws.runtime.home");
                boolean isDeployed = this.model.getBooleanProperty("jboss.ws.deploy");
                this.project.setPersistentProperty(IJBossWSFacetDataModelProperties.PERSISTENCE_PROPERTY_QNAME_RUNTIME_NAME, runtimeName);
                this.project.setPersistentProperty(IJBossWSFacetDataModelProperties.PERSISTENCE_PROPERTY_RNTIME_LOCATION, runtimeLocation);
                this.project.setPersistentProperty(IJBossWSFacetDataModelProperties.PERSISTENCE_PROPERTY_ISDEPLOYED, String.valueOf(isDeployed));
                this.project.setPersistentProperty(IJBossWSFacetDataModelProperties.PERSISTENCE_PROPERTY_SERVER_SUPPLIED_RUNTIME, null);
                status = this.addClassPath(this.project, runtimeName, isDeployed);
            }
        }
        catch (CoreException e) {
            status = StatusUtils.errorStatus(JBossWSCoreMessages.Error_Add_Facet_JBossWS, e);
        }
        return status;
    }

    public IStatus addClassPath(IProject project, String segment, boolean isDeployed) {
        IStatus status = Status.OK_STATUS;
        try {
            IClasspathEntry newClasspath;
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (isDeployed) {
                IClasspathAttribute depAttrib = JavaCore.newClasspathAttribute((String)"org.eclipse.jst.component.dependency", (String)ClasspathDependencyUtil.getDefaultRuntimePath((boolean)true).toString());
                newClasspath = JavaCore.newContainerEntry((IPath)new Path(JBossWSCoreMessages.JBossWS_Runtime_Lib).append(segment), null, (IClasspathAttribute[])new IClasspathAttribute[]{depAttrib}, (boolean)true);
            } else {
                newClasspath = JavaCore.newContainerEntry((IPath)new Path(JBossWSCoreMessages.JBossWS_Runtime_Lib).append(segment));
            }
            IClasspathEntry[] oldClasspathEntries = javaProject.readRawClasspath();
            boolean isFolderInClassPathAlready = false;
            int i = 0;
            while (i < oldClasspathEntries.length && !isFolderInClassPathAlready) {
                if (oldClasspathEntries[i].getPath().equals((Object)newClasspath.getPath())) {
                    isFolderInClassPathAlready = true;
                    break;
                }
                ++i;
            }
            if (!isFolderInClassPathAlready) {
                IClasspathEntry[] newClasspathEntries = new IClasspathEntry[oldClasspathEntries.length + 1];
                int i2 = 0;
                while (i2 < oldClasspathEntries.length) {
                    newClasspathEntries[i2] = oldClasspathEntries[i2];
                    ++i2;
                }
                newClasspathEntries[oldClasspathEntries.length] = newClasspath;
                javaProject.setRawClasspath(newClasspathEntries, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (JavaModelException e) {
            status = StatusUtils.errorStatus(NLS.bind((String)JBossWSCoreMessages.Error_Copy, (Object[])new String[]{e.getLocalizedMessage()}), e);
            return status;
        }
        return status;
    }
}

