/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.core.classpath;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.jboss.tools.common.core.classpath.AbstractClasspathContainer;
import org.jboss.tools.common.core.classpath.AbstractClasspathContainerInitializer;
import org.jboss.tools.common.core.classpath.ClasspathDecorations;
import org.jboss.tools.ws.core.classpath.JBossWSRuntime;
import org.jboss.tools.ws.core.classpath.JBossWSRuntimeManager;
import org.jboss.tools.ws.core.messages.JBossWSCoreMessages;

public class JBossWSRuntimeClassPathInitializer
extends AbstractClasspathContainerInitializer {
    public static final String JBOSS_WS_RUNTIME_CLASSPATH_CONTAINER_ID = "org.jboss.ws.runtime.classpath";
    private String segment;

    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        this.javaProject = project;
        if (containerPath.segment(0).equals(JBossWSCoreMessages.JBossWS_Runtime_Lib)) {
            JBossWSRuntimeClasspathContainer container = new JBossWSRuntimeClasspathContainer(containerPath, project);
            this.segment = containerPath.segment(1);
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
        }
    }

    public IClasspathEntry[] getEntries(IPath path) {
        return new JBossWSRuntimeClasspathContainer(path, this.javaProject).getClasspathEntries();
    }

    public boolean filterJars(String jarName, ArrayList<IClasspathEntry> list) {
        for (IClasspathEntry entry : list) {
            if (!entry.getPath().lastSegment().equals(jarName)) continue;
            return false;
        }
        return true;
    }

    protected AbstractClasspathContainer createClasspathContainer(IPath path) {
        return new JBossWSRuntimeClasspathContainer(path, this.javaProject);
    }

    protected String getClasspathContainerID() {
        return JBOSS_WS_RUNTIME_CLASSPATH_CONTAINER_ID;
    }

    public class JBossWSRuntimeClasspathContainer
    extends AbstractClasspathContainer {
        private IPath path;
        private IClasspathEntry[] entries;

        public JBossWSRuntimeClasspathContainer(IPath path, IJavaProject javaProject) {
            super(path, JBossWSCoreMessages.JBossWS_Runtime_Lib, null, javaProject);
            this.entries = null;
            this.path = path;
        }

        public String getDescription() {
            return JBossWSCoreMessages.JBossWS_Runtime;
        }

        public int getKind() {
            return 1;
        }

        public IPath getPath() {
            return this.path;
        }

        public IClasspathEntry[] computeEntries() {
            ArrayList<IClasspathEntry> entryList = new ArrayList<IClasspathEntry>();
            JBossWSRuntime jbws = JBossWSRuntimeManager.getInstance().findRuntimeByName(JBossWSRuntimeClassPathInitializer.this.segment);
            List<String> jars = null;
            if (jbws != null) {
                jars = JBossWSRuntimeManager.getInstance().getAllRuntimeJars(jbws);
                for (String jar : jars) {
                    entryList.add(this.getEntry((IPath)new Path(jar)));
                }
            }
            if (jars == null) {
                return new IClasspathEntry[0];
            }
            for (String jar : jars) {
                Path entryPath = new Path(jar);
                IPath sourceAttachementPath = null;
                IPath sourceAttachementRootPath = null;
                ClasspathDecorations dec = decorations.getDecorations(JBossWSRuntimeClasspathContainer.getDecorationManagerKey((String)this.getPath().toString()), entryPath.toString());
                IClasspathAttribute[] attrs = new IClasspathAttribute[]{};
                if (dec != null) {
                    sourceAttachementPath = dec.getSourceAttachmentPath();
                    sourceAttachementRootPath = dec.getSourceAttachmentRootPath();
                    attrs = dec.getExtraAttributes();
                }
                IAccessRule[] access = new IAccessRule[]{};
                IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)entryPath, (IPath)sourceAttachementPath, (IPath)sourceAttachementRootPath, (IAccessRule[])access, (IClasspathAttribute[])attrs, (boolean)false);
                entryList.add(entry);
            }
            this.entries = entryList.toArray(new IClasspathEntry[entryList.size()]);
            return this.entries;
        }

        public IClasspathEntry[] getClasspathEntries() {
            if (this.entries == null) {
                ArrayList<IClasspathEntry> entryList = new ArrayList<IClasspathEntry>();
                JBossWSRuntime jbws = JBossWSRuntimeManager.getInstance().findRuntimeByName(JBossWSRuntimeClassPathInitializer.this.segment);
                if (jbws != null) {
                    List<String> jars = JBossWSRuntimeManager.getInstance().getAllRuntimeJars(jbws);
                    for (String jar : jars) {
                        entryList.add(this.getEntry((IPath)new Path(jar)));
                    }
                    this.entries = entryList.toArray(new IClasspathEntry[entryList.size()]);
                    if (entryList.size() == 0) {
                        return new IClasspathEntry[0];
                    }
                    for (String jar : jars) {
                        Path entryPath = new Path(jar);
                        IPath sourceAttachementPath = null;
                        IPath sourceAttachementRootPath = null;
                        ClasspathDecorations dec = decorations.getDecorations(JBossWSRuntimeClasspathContainer.getDecorationManagerKey((String)this.getPath().toString()), entryPath.toString());
                        IClasspathAttribute[] attrs = new IClasspathAttribute[]{};
                        if (dec != null) {
                            sourceAttachementPath = dec.getSourceAttachmentPath();
                            sourceAttachementRootPath = dec.getSourceAttachmentRootPath();
                            attrs = dec.getExtraAttributes();
                        }
                        IAccessRule[] access = new IAccessRule[]{};
                        IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)entryPath, (IPath)sourceAttachementPath, (IPath)sourceAttachementRootPath, (IAccessRule[])access, (IClasspathAttribute[])attrs, (boolean)false);
                        entryList.add(entry);
                    }
                }
            }
            return this.entries;
        }

        protected IClasspathEntry getEntry(IPath path) {
            return JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path).getClasspathEntry();
        }

        public void removeEntry(String jarName) {
            if (this.entries == null) {
                return;
            }
            ArrayList<IClasspathEntry> entriesList = new ArrayList<IClasspathEntry>();
            IClasspathEntry[] iClasspathEntryArray = this.entries;
            int n = this.entries.length;
            int n2 = 0;
            while (n2 < n) {
                IPath path;
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (!(entry == null || (path = entry.getPath()) != null && path != null && path.lastSegment() != null && path.lastSegment().equals(jarName))) {
                    entriesList.add(entry);
                }
                ++n2;
            }
            this.entries = entriesList.toArray(new IClasspathEntry[0]);
        }

        public void refresh() {
            new JBossWSRuntimeClasspathContainer(this.path, this.javaProject).install();
        }
    }
}

