/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.resource.java;

import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.Member;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.ForeignKeyAnnotation;

public class ForeignKeyAnnotationImpl
extends SourceAnnotation
implements ForeignKeyAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("org.hibernate.annotations.ForeignKey");
    private static final DeclarationAnnotationElementAdapter<String> NAME_ADAPTER = ForeignKeyAnnotationImpl.buildDeclarationAnnotationAdapter("name");
    private final AnnotationElementAdapter<String> nameAdapter = this.buildElementAdapter(NAME_ADAPTER);
    private String name;
    private static final DeclarationAnnotationElementAdapter<String> INVERSE_NAME_ADAPTER = ForeignKeyAnnotationImpl.buildDeclarationAnnotationAdapter("inverseName");
    private final AnnotationElementAdapter<String> inverseNameAdapter = this.buildElementAdapter(INVERSE_NAME_ADAPTER);
    private String inverseName;
    private CompilationUnit astRoot;

    protected ForeignKeyAnnotationImpl(JavaResourceModel parent, Member member) {
        super(parent, (AnnotatedElement)member, DECLARATION_ANNOTATION_ADAPTER);
    }

    public String getAnnotationName() {
        return "org.hibernate.annotations.ForeignKey";
    }

    public void initialize(CompilationUnit astRoot) {
        this.astRoot = astRoot;
        this.name = this.buildName(astRoot);
        this.inverseName = this.buildInverseName(astRoot);
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.astRoot = astRoot;
        this.syncName(this.buildName(astRoot));
        this.syncInverseName(this.buildInverseName(astRoot));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (ObjectTools.notEquals((Object)this.name, (Object)name)) {
            this.name = name;
            this.nameAdapter.setValue((Object)name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(CompilationUnit astRoot) {
        return (String)this.nameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNameTextRange() {
        return this.getElementTextRange(NAME_ADAPTER, this.getAstAnnotation(this.astRoot));
    }

    @Override
    public String getInverseName() {
        return this.inverseName;
    }

    @Override
    public void setInverseName(String inverseName) {
        if (ObjectTools.notEquals((Object)this.inverseName, (Object)inverseName)) {
            this.inverseName = inverseName;
            this.inverseNameAdapter.setValue((Object)inverseName);
        }
    }

    private void syncInverseName(String astInverseName) {
        String old = this.inverseName;
        this.inverseName = astInverseName;
        this.firePropertyChanged("inverseName", old, astInverseName);
    }

    private String buildInverseName(CompilationUnit astRoot) {
        return (String)this.inverseNameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getInverseNameTextRange() {
        return this.getElementTextRange(INVERSE_NAME_ADAPTER, this.getAstAnnotation(this.astRoot));
    }

    private static DeclarationAnnotationElementAdapter<String> buildDeclarationAnnotationAdapter(String property) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings((DeclarationAnnotationAdapter)DECLARATION_ANNOTATION_ADAPTER, (String)property);
    }

    AnnotationElementAdapter<String> buildElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new ShortCircuitAnnotationElementAdapter(this.annotatedElement, daea);
    }

    public static class ForeignKeyAnnotationDefinition
    implements AnnotationDefinition {
        private static final ForeignKeyAnnotationDefinition INSTANCE = new ForeignKeyAnnotationDefinition();

        public static AnnotationDefinition instance() {
            return INSTANCE;
        }

        private ForeignKeyAnnotationDefinition() {
        }

        public Annotation buildAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement member) {
            return new ForeignKeyAnnotationImpl((JavaResourceModel)parent, (Member)member);
        }

        public String getAnnotationName() {
            return "org.hibernate.annotations.ForeignKey";
        }

        public Annotation buildAnnotation(JavaResourceAnnotatedElement parent, IAnnotation jdtAnnotation) {
            throw new UnsupportedOperationException();
        }

        public Annotation buildNullAnnotation(JavaResourceAnnotatedElement parent) {
            throw new UnsupportedOperationException();
        }
    }
}

