/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.jpa.core.JpaModel;
import org.eclipse.jpt.jpa.core.context.SpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedJoinTable;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.orm.GenericOrmJoinTable;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaProject;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJptPlugin;
import org.jboss.tools.hibernate.jpt.core.internal.context.orm.HibernateOrmJoinTable;
import org.jboss.tools.hibernate.jpt.core.internal.validation.HibernateJpaValidationMessage;
import org.jboss.tools.hibernate.runtime.spi.INamingStrategy;

public class HibernateOrmJoinTableImpl
extends GenericOrmJoinTable
implements HibernateOrmJoinTable {
    public HibernateOrmJoinTableImpl(OrmSpecifiedJoinTable.ParentAdapter owner) {
        super(owner);
    }

    public HibernateJpaProject getJpaProject() {
        return (HibernateJpaProject)super.getJpaProject();
    }

    public Table getDbTable() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema == null ? null : dbSchema.getTableForIdentifier(this.getDBTableName());
    }

    @Override
    public String getDBTableName() {
        return this.getSpecifiedDBTableName() != null ? this.getSpecifiedDBTableName() : this.getDefaultDBTableName();
    }

    @Override
    public String getSpecifiedDBTableName() {
        if (this.getSpecifiedName() == null) {
            return null;
        }
        INamingStrategy ns = this.getJpaProject().getNamingStrategy();
        if (this.getJpaProject().isNamingStrategyEnabled() && ns != null) {
            try {
                return ns.tableName(this.getSpecifiedName());
            }
            catch (Exception e) {
                IMessage m = HibernateJpaValidationMessage.buildMessage(1, "NAMING_STRATEGY_EXCEPTION", (JpaModel)this);
                HibernateJptPlugin.logException(m.getText(), e);
            }
        }
        return this.getName();
    }

    @Override
    public String getDefaultDBTableName() {
        return this.getDefaultName();
    }

    protected boolean validateAgainstDatabase(List<IMessage> messages, IReporter reporter) {
        SpecifiedPersistentAttribute persistentAttribute = this.getPersistentAttribute();
        if (!this.catalogIsResolved()) {
            if (persistentAttribute.isVirtual()) {
                messages.add(this.buildValidationMessage(JptJpaCoreValidationMessages.JOIN_TABLE_UNRESOLVED_CATALOG, new Object[]{new String[]{persistentAttribute.getName(), this.getCatalog(), this.getDBTableName()}, this.getCatalogValidationTextRange()}));
            } else {
                messages.add(this.buildValidationMessage(JptJpaCoreValidationMessages.VIRTUAL_ATTRIBUTE_JOIN_TABLE_UNRESOLVED_CATALOG, new Object[]{new String[]{this.getCatalog(), this.getDBTableName()}, this.getCatalogValidationTextRange()}));
            }
            return false;
        }
        if (!this.schemaIsResolved()) {
            if (persistentAttribute.isVirtual()) {
                messages.add(this.buildValidationMessage(JptJpaCoreValidationMessages.JOIN_TABLE_UNRESOLVED_SCHEMA, new Object[]{new String[]{persistentAttribute.getName(), this.getSchema(), this.getDBTableName()}, this.getSchemaValidationTextRange()}));
            } else {
                messages.add(this.buildValidationMessage(JptJpaCoreValidationMessages.VIRTUAL_ATTRIBUTE_JOIN_TABLE_UNRESOLVED_SCHEMA, new Object[]{new String[]{this.getSchema(), this.getDBTableName()}, this.getSchemaValidationTextRange()}));
            }
            return false;
        }
        if (!this.isResolved()) {
            if (this.getDBTableName() != null) {
                if (persistentAttribute.isVirtual()) {
                    messages.add(this.buildValidationMessage(JptJpaCoreValidationMessages.VIRTUAL_ATTRIBUTE_JOIN_TABLE_UNRESOLVED_NAME, new Object[]{new String[]{persistentAttribute.getName(), this.getDBTableName()}, this.getNameValidationTextRange()}));
                } else {
                    messages.add(this.buildValidationMessage(JptJpaCoreValidationMessages.JOIN_TABLE_UNRESOLVED_NAME, new Object[]{new String[]{this.getDBTableName()}, this.getNameValidationTextRange()}));
                }
            }
            return false;
        }
        return true;
    }
}

