/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.jboss.tools.hibernate.jpt.core.internal.context.ForeignKey;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.ForeignKeyAnnotation;
import org.jboss.tools.hibernate.jpt.core.internal.validation.HibernateJpaValidationMessage;

public class ForeignKeyImpl
extends AbstractJavaContextModel<JpaContextModel>
implements ForeignKey {
    private ForeignKeyAnnotation annotation;
    private String name;
    private String inverseName;

    public ForeignKeyImpl(JpaContextModel parent, ForeignKeyAnnotation annotation) {
        super(parent);
        this.annotation = annotation;
        this.name = annotation.getName();
        this.inverseName = annotation.getInverseName();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setName_(this.annotation.getName());
        this.setInverseName_(this.annotation.getInverseName());
    }

    private ForeignKeyAnnotation getResourceForeignKey() {
        return this.annotation;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.getResourceForeignKey().setName(name);
        this.firePropertyChanged("name", old, name);
    }

    public void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    @Override
    public String getInverseName() {
        return this.inverseName;
    }

    @Override
    public void setInverseName(String inverseName) {
        String old = this.inverseName;
        this.inverseName = inverseName;
        this.getResourceForeignKey().setInverseName(inverseName);
        this.firePropertyChanged("inverseName", old, inverseName);
    }

    public void setInverseName_(String inverseName) {
        String old = this.inverseName;
        this.inverseName = inverseName;
        this.firePropertyChanged("inverseName", old, inverseName);
    }

    public TextRange getValidationTextRange() {
        return this.annotation.getTextRange();
    }

    @Override
    public ForeignKeyAnnotation getForeignKeyAnnotation() {
        return this.annotation;
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateName(messages, reporter);
        this.validateInverseName(messages, reporter);
    }

    private void validateName(List<IMessage> messages, IReporter reporter) {
        this.validateForeignKeyName(messages, this.name, this.getResourceForeignKey().getNameTextRange());
    }

    private void validateInverseName(List<IMessage> messages, IReporter reporter) {
        if (this.getParent() instanceof ManyToManyMapping && ((ManyToManyMapping)this.getParent()).isRelationshipOwner()) {
            this.validateForeignKeyName(messages, this.inverseName, this.getResourceForeignKey().getInverseNameTextRange());
        }
    }

    private void validateForeignKeyName(List<IMessage> messages, String name, TextRange range) {
        if (name == null || name.trim().length() == 0) {
            messages.add(HibernateJpaValidationMessage.buildMessage(1, "NAME_CANT_BE_EMPTY", this.getResource(), range));
        } else {
            AttributeMapping mapping = (AttributeMapping)this.getParent();
            Table table = mapping.getTypeMapping().getPrimaryDbTable();
            if (!mapping.validatesAgainstDatabase() || table == null) {
                return;
            }
            for (org.eclipse.jpt.jpa.db.ForeignKey fk : table.getForeignKeys()) {
                if (!name.equals(fk.getIdentifier())) continue;
                return;
            }
            messages.add(HibernateJpaValidationMessage.buildMessage(1, "UNRESOLVED_FOREIGN_KEY_NAME", this.getResource(), range));
        }
    }
}

