/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.basic;

import java.util.Map;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.internal.context.persistence.AbstractPersistenceUnitProperties;
import org.jboss.tools.hibernate.jpt.core.internal.context.basic.BasicHibernateProperties;

public class HibernatePersistenceUnitProperties
extends AbstractPersistenceUnitProperties
implements BasicHibernateProperties {
    private String configFile;
    private String dialect;
    private String driver;
    private String url;
    private String schemaDefault;
    private String catalogDefault;
    private String username;
    private String password;

    public HibernatePersistenceUnitProperties(PersistenceUnit parent) {
        super(parent);
    }

    protected void initializeProperties() {
        this.configFile = this.getStringValue("hibernate.ejb.cfgfile");
        this.dialect = this.getStringValue("hibernate.dialect");
        this.driver = this.getStringValue("hibernate.connection.driver_class");
        this.url = this.getStringValue("hibernate.connection.url");
        this.schemaDefault = this.getStringValue("hibernate.default_schema");
        this.catalogDefault = this.getStringValue("hibernate.default_catalog");
        this.username = this.getStringValue("hibernate.connection.username");
        this.password = this.getStringValue("hibernate.connection.password");
    }

    public void propertyValueChanged(String propertyName, String newValue) {
        if (propertyName.equals("hibernate.ejb.cfgfile")) {
            this.configurationFileChanged(newValue);
        } else if (propertyName.equals("hibernate.dialect")) {
            this.dialectChanged(newValue);
        } else if (propertyName.equals("hibernate.connection.driver_class")) {
            this.driverChanged(newValue);
        } else if (propertyName.equals("hibernate.connection.url")) {
            this.urlChanged(newValue);
        } else if (propertyName.equals("hibernate.default_schema")) {
            this.schemaDefaultChanged(newValue);
        } else if (propertyName.equals("hibernate.default_catalog")) {
            this.catalogDefaultChanged(newValue);
        } else if (propertyName.equals("hibernate.connection.username")) {
            this.usernameChanged(newValue);
        } else if (propertyName.equals("hibernate.connection.password")) {
            this.passwordChanged(newValue);
        }
    }

    public void propertyRemoved(String propertyName) {
        if (propertyName.equals("hibernate.ejb.cfgfile")) {
            this.configurationFileChanged(null);
        } else if (propertyName.equals("hibernate.dialect")) {
            this.dialectChanged(null);
        } else if (propertyName.equals("hibernate.connection.driver_class")) {
            this.driverChanged(null);
        } else if (propertyName.equals("hibernate.connection.url")) {
            this.urlChanged(null);
        } else if (propertyName.equals("hibernate.default_schema")) {
            this.schemaDefaultChanged(null);
        } else if (propertyName.equals("hibernate.default_catalog")) {
            this.catalogDefaultChanged(null);
        } else if (propertyName.equals("hibernate.connection.username")) {
            this.usernameChanged(null);
        } else if (propertyName.equals("hibernate.connection.password")) {
            this.passwordChanged(null);
        }
    }

    protected void addPropertyNames(Map<String, String> propertyNames) {
        propertyNames.put("hibernate.ejb.cfgfile", "confFileProperty");
        propertyNames.put("hibernate.dialect", "dialectProperty");
        propertyNames.put("hibernate.connection.driver_class", "driverProperty");
        propertyNames.put("hibernate.connection.url", "urlProperty");
        propertyNames.put("hibernate.default_schema", "schemaDefaultProperty");
        propertyNames.put("hibernate.default_catalog", "catalogDefaultProperty");
        propertyNames.put("hibernate.connection.username", "usernameProperty");
        propertyNames.put("hibernate.connection.password", "passwordProperty");
    }

    @Override
    public String getDefaultConfigurationFile() {
        return "";
    }

    @Override
    public String getConfigurationFile() {
        return this.configFile;
    }

    @Override
    public void setConfigurationFile(String newConfigFile) {
        String old = this.configFile;
        this.configFile = newConfigFile;
        this.putProperty("confFileProperty", newConfigFile);
        this.firePropertyChanged("confFileProperty", old, newConfigFile);
    }

    private void configurationFileChanged(String newFile) {
        String old = this.configFile;
        this.configFile = newFile;
        this.firePropertyChanged("confFileProperty", old, newFile);
    }

    @Override
    public String getDefaultDialect() {
        return "";
    }

    @Override
    public String getDialect() {
        return this.dialect;
    }

    @Override
    public void setDialect(String newDialect) {
        String old = this.dialect;
        this.dialect = newDialect;
        this.putProperty("dialectProperty", newDialect);
        this.firePropertyChanged("dialectProperty", old, newDialect);
    }

    private void dialectChanged(String newDialect) {
        String old = this.dialect;
        this.dialect = newDialect;
        this.firePropertyChanged("dialectProperty", old, newDialect);
    }

    @Override
    public String getDefaultDriver() {
        return "";
    }

    @Override
    public String getDriver() {
        return this.driver;
    }

    @Override
    public void setDriver(String newDriver) {
        String old = this.driver;
        this.driver = newDriver;
        this.putProperty("driverProperty", newDriver);
        this.firePropertyChanged("driverProperty", old, newDriver);
    }

    private void driverChanged(String newDriver) {
        String old = this.driver;
        this.driver = newDriver;
        this.firePropertyChanged("driverProperty", old, newDriver);
    }

    @Override
    public String getDefaultUrl() {
        return "";
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String newUrl) {
        String old = this.url;
        this.url = newUrl;
        this.putProperty("urlProperty", newUrl);
        this.firePropertyChanged("urlProperty", old, newUrl);
    }

    private void urlChanged(String newUrl) {
        String old = this.url;
        this.url = newUrl;
        this.firePropertyChanged("urlProperty", old, newUrl);
    }

    @Override
    public String getDefaultSchemaDefault() {
        return "";
    }

    @Override
    public String getSchemaDefault() {
        return this.schemaDefault;
    }

    @Override
    public void setSchemaDefault(String newSchemaDefault) {
        String old = this.schemaDefault;
        this.schemaDefault = newSchemaDefault;
        this.putProperty("schemaDefaultProperty", newSchemaDefault);
        this.firePropertyChanged("schemaDefaultProperty", old, newSchemaDefault);
    }

    private void schemaDefaultChanged(String newSchemaDefault) {
        String old = this.schemaDefault;
        this.schemaDefault = newSchemaDefault;
        this.firePropertyChanged("schemaDefaultProperty", old, newSchemaDefault);
    }

    @Override
    public String getDefaultCatalogDefault() {
        return "";
    }

    @Override
    public String getCatalogDefault() {
        return this.catalogDefault;
    }

    @Override
    public void setCatalogDefault(String newCatalogDefault) {
        String old = this.catalogDefault;
        this.catalogDefault = newCatalogDefault;
        this.putProperty("catalogDefaultProperty", newCatalogDefault);
        this.firePropertyChanged("catalogDefaultProperty", old, newCatalogDefault);
    }

    private void catalogDefaultChanged(String newCatalogDefault) {
        String old = this.catalogDefault;
        this.catalogDefault = newCatalogDefault;
        this.firePropertyChanged("catalogDefaultProperty", old, newCatalogDefault);
    }

    @Override
    public String getDefaultUsername() {
        return "";
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String newUsername) {
        String old = this.username;
        this.username = newUsername;
        this.putProperty("usernameProperty", newUsername);
        this.firePropertyChanged("usernameProperty", old, newUsername);
    }

    private void usernameChanged(String newUsername) {
        String old = this.username;
        this.username = newUsername;
        this.firePropertyChanged("usernameProperty", old, newUsername);
    }

    @Override
    public String getDefaultPassword() {
        return "";
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String newPassword) {
        String old = this.password;
        this.password = newPassword;
        this.putProperty("passwordProperty", newPassword);
        this.firePropertyChanged("passwordProperty", old, newPassword);
    }

    private void passwordChanged(String newPassword) {
        String old = this.password;
        this.password = newPassword;
        this.firePropertyChanged("passwordProperty", old, newPassword);
    }
}

