/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.deltaspike.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.cdi.core.extension.AbstractDefinitionContextExtension;
import org.jboss.tools.cdi.deltaspike.core.DeltaspikeAuthorityMethod;
import org.jboss.tools.cdi.deltaspike.core.DeltaspikeConstants;
import org.jboss.tools.cdi.deltaspike.core.DeltaspikeSecurityBindingConfiguration;
import org.jboss.tools.cdi.internal.core.impl.definition.AnnotationDefinition;

public class DeltaspikeSecurityDefinitionContext
extends AbstractDefinitionContextExtension
implements DeltaspikeConstants {
    Map<String, DeltaspikeSecurityBindingConfiguration> securityBindingConfigurations = new HashMap<String, DeltaspikeSecurityBindingConfiguration>();
    DeltaspikeSecurityBindingConfiguration allAuthorizerMethods = new DeltaspikeSecurityBindingConfiguration("");

    protected AbstractDefinitionContextExtension copy(boolean clean) {
        DeltaspikeSecurityDefinitionContext copy = new DeltaspikeSecurityDefinitionContext();
        copy.root = this.root;
        if (!clean) {
            copy.securityBindingConfigurations.putAll(this.securityBindingConfigurations);
            copy.allAuthorizerMethods = this.allAuthorizerMethods;
        }
        return copy;
    }

    protected void doApplyWorkingCopy() {
        DeltaspikeSecurityDefinitionContext copy = (DeltaspikeSecurityDefinitionContext)this.workingCopy;
        this.securityBindingConfigurations = copy.securityBindingConfigurations;
        this.allAuthorizerMethods = copy.allAuthorizerMethods;
    }

    public void clean() {
        this.securityBindingConfigurations.clear();
        this.allAuthorizerMethods.getAuthorizerMembers().clear();
    }

    public void clean(IPath path) {
        for (DeltaspikeSecurityBindingConfiguration c : this.securityBindingConfigurations.values()) {
            c.clear(path);
        }
        this.allAuthorizerMethods.clear(path);
    }

    public void clean(String typeName) {
        this.securityBindingConfigurations.remove(typeName);
        for (DeltaspikeSecurityBindingConfiguration c : this.securityBindingConfigurations.values()) {
            c.clear(typeName);
        }
        this.allAuthorizerMethods.clear(typeName);
    }

    public void computeAnnotationKind(AnnotationDefinition annotation) {
        if ("org.apache.deltaspike.security.api.authorization.Secures".equals(annotation.getType().getFullyQualifiedName())) {
            annotation.setExtendedKind((Object)"securesAnnotation");
        } else if ("org.apache.deltaspike.security.api.authorization.Secured".equals(annotation.getType().getFullyQualifiedName())) {
            annotation.setExtendedKind((Object)"securesAnnotation");
        } else if (annotation.isAnnotationPresent("org.apache.deltaspike.security.api.authorization.SecurityBindingType")) {
            annotation.setExtendedKind((Object)"securityBindingAnnotation");
            String qn = annotation.getType().getFullyQualifiedName();
            DeltaspikeSecurityBindingConfiguration c = this.getConfiguration(qn);
            c.setSecurityBundingTypeDefinition(annotation, this);
            if (!annotation.getType().isBinary()) {
                IPath newPath = annotation.getType().getResource().getFullPath();
                Set<IPath> ps = c.getInvolvedTypes();
                for (IPath p : ps) {
                    this.getRootContext().addDependency(p, newPath);
                    this.getRootContext().addDependency(newPath, p);
                }
                ps.add(newPath);
            }
        }
    }

    public boolean isSecurityBindingTypeAnnotation(IType type) {
        return this.securityBindingConfigurations.containsKey(type.getFullyQualifiedName());
    }

    public Map<String, DeltaspikeSecurityBindingConfiguration> getConfigurations() {
        return this.securityBindingConfigurations;
    }

    public DeltaspikeSecurityBindingConfiguration getConfiguration(String typeName) {
        DeltaspikeSecurityBindingConfiguration result = this.securityBindingConfigurations.get(typeName);
        if (result == null) {
            result = new DeltaspikeSecurityBindingConfiguration(typeName);
            this.securityBindingConfigurations.put(typeName, result);
        }
        return result;
    }

    public Set<DeltaspikeAuthorityMethod> getAuthorityMethods(IPath path) {
        HashSet<DeltaspikeAuthorityMethod> result = new HashSet<DeltaspikeAuthorityMethod>();
        for (DeltaspikeAuthorityMethod m : this.allAuthorizerMethods.getAuthorizerMembers()) {
            if (!path.equals((Object)m.getPath())) continue;
            result.add(m);
        }
        return result;
    }
}

