/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml.internal.mojo;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.maven.DefaultMaven;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.building.UrlModelSource;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.embedder.MavenExecutionContext;
import org.eclipse.m2e.core.internal.embedder.MavenImpl;
import org.eclipse.m2e.editor.xml.internal.mojo.DefaultMojoParameterMetadata;
import org.eclipse.m2e.editor.xml.mojo.IMojoParameterMetadata;
import org.eclipse.m2e.editor.xml.mojo.IMojoParameterMetadataProvider;
import org.eclipse.m2e.editor.xml.mojo.MojoParameter;
import org.eclipse.m2e.editor.xml.mojo.PlexusConfigHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MojoParameterMetadataProvider
implements IMojoParameterMetadataProvider {
    private static final Logger log = LoggerFactory.getLogger(MojoParameterMetadataProvider.class);
    private static final Cache<String, MojoParameter> cache = CacheBuilder.newBuilder().maximumSize(100L).softValues().build();
    protected final MavenImpl maven = (MavenImpl)MavenPlugin.getMaven();
    public static final String EXTENSION_MOJO_PARAMETER_METADATA = "org.eclipse.m2e.editor.xml.mojoParameterMetadata";
    private static final Map<String, MojoParameter> PREDEF = ImmutableMap.of((Object)"org.eclipse.m2e:lifecycle-mapping:1.0.0", (Object)new MojoParameter("", "", Collections.singletonList(new MojoParameter("lifecycleMappingMetadata", "LifecycleMappingMetadata", Collections.singletonList(new MojoParameter("pluginExecutions", "List<PluginExecution>", Collections.singletonList(new MojoParameter("pluginExecution", "PluginExecution", Arrays.asList(new MojoParameter("pluginExecutionFilter", "PluginExecutionFilter", Arrays.asList(new MojoParameter("groupId", "String"), new MojoParameter("artifactId", "String"), new MojoParameter("versionRange", "String"), new MojoParameter("goals", "List<String>", Collections.singletonList(new MojoParameter("goal", "String").multiple())))), new MojoParameter("action", "Action", Arrays.asList(new MojoParameter("ignore", "void"), new MojoParameter("execute", "Execute", Arrays.asList(new MojoParameter("runOnIncremental", "boolean"), new MojoParameter("runOnConfiguration", "boolean"))))))).multiple())))))));

    @Override
    public MojoParameter getClassConfiguration(final ArtifactKey pluginKey, final String className, final IProgressMonitor monitor) throws CoreException {
        try {
            String key = String.valueOf(pluginKey.toPortableString()) + "/" + className;
            return (MojoParameter)cache.get((Object)key, (Callable)new Callable<MojoParameter>(){

                @Override
                public MojoParameter call() throws Exception {
                    return MojoParameterMetadataProvider.this.execute(pluginKey, new ICallable<MojoParameter>(){

                        public MojoParameter call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                            PluginDescriptor pd = MojoParameterMetadataProvider.this.getPluginDescriptor(pluginKey, context, monitor);
                            if (pd != null) {
                                Class clazz;
                                try {
                                    clazz = pd.getClassRealm().loadClass(className);
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    return null;
                                }
                                return new MojoParameter("", className, new PlexusConfigHelper().loadParameters(pd.getClassRealm(), clazz, monitor));
                            }
                            return null;
                        }
                    }, monitor);
                }
            });
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof CoreException) {
                throw (CoreException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, e.getMessage(), (Throwable)e));
        }
    }

    @Override
    public MojoParameter getMojoConfiguration(ArtifactKey pluginKey, Collection<String> mojos, IProgressMonitor monitor) throws CoreException {
        ArrayList<MojoParameter> params = new ArrayList<MojoParameter>();
        HashSet<String> collected = new HashSet<String>();
        for (String mojo : mojos) {
            MojoParameter md = this.getMojoConfiguration(pluginKey, mojo, monitor);
            for (MojoParameter p : md.getNestedParameters()) {
                if (!collected.add(p.getName())) continue;
                params.add(p);
            }
        }
        return new MojoParameter("", "", params);
    }

    @Override
    public MojoParameter getMojoConfiguration(ArtifactKey pluginKey, IProgressMonitor monitor) throws CoreException {
        return this.getMojoConfiguration(pluginKey, "*", monitor);
    }

    @Override
    public MojoParameter getMojoConfiguration(final ArtifactKey pluginKey, final String mojo, final IProgressMonitor monitor) throws CoreException {
        MojoParameter predefParameters = this.getPredefined(pluginKey);
        if (predefParameters != null) {
            return predefParameters;
        }
        String key = String.valueOf(pluginKey.toPortableString()) + "/mojo/" + (mojo == null ? "*" : mojo);
        try {
            return (MojoParameter)cache.get((Object)key, (Callable)new Callable<MojoParameter>(){

                @Override
                public MojoParameter call() throws Exception {
                    return MojoParameterMetadataProvider.this.execute(pluginKey, new ICallable<MojoParameter>(){

                        public MojoParameter call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                            PluginDescriptor pd = MojoParameterMetadataProvider.this.getPluginDescriptor(pluginKey, context, monitor);
                            if (pd != null) {
                                return new MojoParameter("", mojo, MojoParameterMetadataProvider.this.loadMojoParameters(pd, mojo, monitor));
                            }
                            return null;
                        }
                    }, monitor);
                }
            });
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof CoreException) {
                throw (CoreException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, e.getMessage(), (Throwable)e));
        }
    }

    List<MojoParameter> loadMojoParameters(PluginDescriptor desc, String goal, IProgressMonitor monitor) throws CoreException {
        PlexusConfigHelper helper = new PlexusConfigHelper();
        if (goal.equals("*")) {
            ArrayList<MojoParameter> parameters = new ArrayList<MojoParameter>();
            HashSet<String> collected = new HashSet<String>();
            for (MojoDescriptor mojo : desc.getMojos()) {
                for (MojoParameter p : this.loadMojoParameters(desc, mojo, helper, monitor)) {
                    if (!collected.add(p.getName())) continue;
                    parameters.add(p);
                }
            }
            return parameters;
        }
        return this.loadMojoParameters(desc, desc.getMojo(goal), helper, monitor);
    }

    private MojoParameter getPredefined(ArtifactKey pluginKey) {
        return PREDEF.get(String.valueOf(pluginKey.getGroupId()) + ":" + pluginKey.getArtifactId() + ":" + pluginKey.getVersion());
    }

    <T> T execute(ArtifactKey pluginKey, final ICallable<T> callable, IProgressMonitor monitor) throws CoreException {
        MavenExecutionContext context = this.maven.createExecutionContext();
        context.getExecutionRequest().setCacheTransferError(false);
        return (T)context.execute(new ICallable<T>(){

            public T call(IMavenExecutionContext context, IProgressMonitor monitor) throws CoreException {
                MavenProject mp = MojoParameterMetadataProvider.this.getProject(context);
                if (mp != null) {
                    return context.execute(mp, callable, monitor);
                }
                return null;
            }
        }, monitor);
    }

    MavenProject getProject(IMavenExecutionContext context) {
        UrlModelSource modelSource = new UrlModelSource(DefaultMaven.class.getResource("project/standalone.xml"));
        try {
            return this.lookup(ProjectBuilder.class).build((ModelSource)modelSource, context.newProjectBuildingRequest()).getProject();
        }
        catch (ProjectBuildingException | CoreException ex) {
            log.warn(ex.getMessage());
            return null;
        }
    }

    PluginDescriptor getPluginDescriptor(ArtifactKey pluginKey, IMavenExecutionContext context, IProgressMonitor monitor) {
        Plugin plugin = new Plugin();
        plugin.setGroupId(pluginKey.getGroupId());
        plugin.setArtifactId(pluginKey.getArtifactId());
        plugin.setVersion(pluginKey.getVersion());
        List remoteRepos = context.getSession().getCurrentProject().getRemotePluginRepositories();
        try {
            PluginDescriptor desc = this.lookup(MavenPluginManager.class).getPluginDescriptor(plugin, remoteRepos, context.getRepositorySession());
            this.lookup(BuildPluginManager.class).getPluginRealm(context.getSession(), desc);
            return desc;
        }
        catch (Exception ex) {
            log.warn(ex.getMessage());
            return null;
        }
    }

    <T> T lookup(Class<T> clazz) throws CoreException {
        try {
            return (T)this.maven.getPlexusContainer().lookup(clazz);
        }
        catch (ComponentLookupException ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.MavenImpl_error_lookup, (Throwable)ex));
        }
    }

    List<MojoParameter> loadMojoParameters(PluginDescriptor desc, MojoDescriptor mojo, PlexusConfigHelper helper, IProgressMonitor monitor) throws CoreException {
        IMojoParameterMetadata metadata = null;
        String mojoConfigurator = mojo.getComponentConfigurator();
        if (mojoConfigurator != null) {
            metadata = MojoParameterMetadataProvider.readMojoParameterMetadata(mojoConfigurator);
        }
        if (metadata == null) {
            metadata = new DefaultMojoParameterMetadata();
        }
        return metadata.loadMojoParameters(desc, mojo, helper, monitor);
    }

    private static IMojoParameterMetadata readMojoParameterMetadata(String mojoConfigurator) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint mappingsExtensionPoint = registry.getExtensionPoint(EXTENSION_MOJO_PARAMETER_METADATA);
        if (mappingsExtensionPoint != null) {
            IExtension[] mappingsExtensions;
            IExtension[] iExtensionArray = mappingsExtensions = mappingsExtensionPoint.getExtensions();
            int n = mappingsExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals("mojoParameterMetadata") && mojoConfigurator.equals(element.getAttribute("configurator"))) {
                        try {
                            return (IMojoParameterMetadata)element.createExecutableExtension("class");
                        }
                        catch (CoreException ex) {
                            log.error(ex.getMessage(), (Throwable)ex);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }
}

