/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.runtime.common;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import org.jboss.tools.hibernate.runtime.common.AbstractFacade;
import org.jboss.tools.hibernate.runtime.common.IFacadeFactory;
import org.jboss.tools.hibernate.runtime.common.Util;
import org.jboss.tools.hibernate.runtime.spi.IColumn;
import org.jboss.tools.hibernate.runtime.spi.IPersistentClass;
import org.jboss.tools.hibernate.runtime.spi.IProperty;
import org.jboss.tools.hibernate.runtime.spi.ITable;
import org.jboss.tools.hibernate.runtime.spi.IType;
import org.jboss.tools.hibernate.runtime.spi.IValue;
import org.jboss.tools.hibernate.runtime.spi.IValueVisitor;

public abstract class AbstractValueFacade
extends AbstractFacade
implements IValue {
    private IValue collectionElement = null;
    private ITable table = null;
    private IType type = null;
    private ITable collectionTable = null;
    private HashSet<IColumn> columns = null;
    private IValue key = null;
    private IValue index = null;
    private HashSet<IProperty> properties = null;
    private IPersistentClass owner = null;
    private IPersistentClass associatedClass = null;

    public AbstractValueFacade(IFacadeFactory facadeFactory, Object target) {
        super(facadeFactory, target);
    }

    public boolean isSimpleValue() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isSimpleValue", new Class[0], new Object[0]);
    }

    public boolean isCollection() {
        return this.getCollectionClass().isAssignableFrom(this.getTarget().getClass());
    }

    public IValue getCollectionElement() {
        Object targetElement;
        if (this.isCollection() && this.collectionElement == null && (targetElement = Util.invokeMethod(this.getTarget(), "getElement", new Class[0], new Object[0])) != null) {
            this.collectionElement = this.getFacadeFactory().createValue(targetElement);
        }
        return this.collectionElement;
    }

    public boolean isOneToMany() {
        return this.getOneToManyClass().isAssignableFrom(this.getTarget().getClass());
    }

    public boolean isManyToOne() {
        return this.getManyToOneClass().isAssignableFrom(this.getTarget().getClass());
    }

    public boolean isOneToOne() {
        return this.getOneToOneClass().isAssignableFrom(this.getTarget().getClass());
    }

    public boolean isMap() {
        return this.getMapClass().isAssignableFrom(this.getTarget().getClass());
    }

    public boolean isComponent() {
        return this.getComponentClass().isAssignableFrom(this.getTarget().getClass());
    }

    public boolean isToOne() {
        return this.getToOneClass().isAssignableFrom(this.getTarget().getClass());
    }

    public Boolean isEmbedded() {
        Boolean result = null;
        if (this.isComponent() || this.isToOne()) {
            result = (Boolean)Util.invokeMethod(this.getTarget(), "isEmbedded", new Class[0], new Object[0]);
        }
        return result;
    }

    public Object accept(IValueVisitor valueVisitor) {
        return valueVisitor.accept((IValue)this);
    }

    public ITable getTable() {
        Object targetTable;
        if (this.table == null && (targetTable = Util.invokeMethod(this.getTarget(), "getTable", new Class[0], new Object[0])) != null) {
            this.table = this.getFacadeFactory().createTable(targetTable);
        }
        return this.table;
    }

    public IType getType() {
        Object targetType;
        if (this.type == null && (targetType = Util.invokeMethod(this.getTarget(), "getType", new Class[0], new Object[0])) != null) {
            this.type = this.getFacadeFactory().createType(targetType);
        }
        return this.type;
    }

    public void setElement(IValue element) {
        if (this.isCollection()) {
            Object elementTarget = Util.invokeMethod(element, "getTarget", new Class[0], new Object[0]);
            Util.invokeMethod(this.getTarget(), "setElement", new Class[]{this.getValueClass()}, new Object[]{elementTarget});
        }
    }

    public void setCollectionTable(ITable table) {
        if (this.isCollection()) {
            this.collectionTable = table;
            Object tableTarget = Util.invokeMethod(table, "getTarget", new Class[0], new Object[0]);
            Util.invokeMethod(this.getTarget(), "setCollectionTable", new Class[]{this.getTableClass()}, new Object[]{tableTarget});
        }
    }

    public void setTable(ITable table) {
        if (this.isSimpleValue()) {
            Object tableTarget = Util.invokeMethod(table, "getTarget", new Class[0], new Object[0]);
            Util.invokeMethod(this.getTarget(), "setTable", new Class[]{this.getTableClass()}, new Object[]{tableTarget});
        }
    }

    public boolean isList() {
        return this.getListClass().isAssignableFrom(this.getTarget().getClass());
    }

    public void setIndex(IValue value) {
        Object valueTarget = Util.invokeMethod(value, "getTarget", new Class[0], new Object[0]);
        Util.invokeMethod(this.getTarget(), "setIndex", new Class[]{this.getValueClass()}, new Object[]{valueTarget});
    }

    public void setTypeName(String name) {
        if (this.isSimpleValue()) {
            Util.invokeMethod(this.getTarget(), "setTypeName", new Class[]{String.class}, new Object[]{name});
        }
    }

    public String getComponentClassName() {
        String result = null;
        if (this.isComponent()) {
            result = (String)Util.invokeMethod(this.getTarget(), "getComponentClassName", new Class[0], new Object[0]);
        }
        return result;
    }

    public Iterator<IColumn> getColumnIterator() {
        if (this.columns == null) {
            this.initializeColumns();
        }
        return this.columns.iterator();
    }

    public Boolean isTypeSpecified() {
        Boolean result = null;
        if (this.isSimpleValue()) {
            result = (Boolean)Util.invokeMethod(this.getTarget(), "isTypeSpecified", new Class[0], new Object[0]);
        }
        return result;
    }

    public String toString() {
        return this.getTarget().toString();
    }

    public ITable getCollectionTable() {
        Object ct;
        if (this.isCollection() && this.collectionTable == null && (ct = Util.invokeMethod(this.getTarget(), "getCollectionTable", new Class[0], new Object[0])) != null) {
            this.collectionTable = this.getFacadeFactory().createTable(ct);
        }
        return this.collectionTable;
    }

    public IValue getKey() {
        Object targetKey;
        if (this.key == null && this.isCollection() && (targetKey = Util.invokeMethod(this.getTarget(), "getKey", new Class[0], new Object[0])) != null) {
            this.key = this.getFacadeFactory().createValue(targetKey);
        }
        return this.key;
    }

    public boolean isDependantValue() {
        return this.getDependantValueClass().isAssignableFrom(this.getTarget().getClass());
    }

    public boolean isAny() {
        return this.getAnyClass().isAssignableFrom(this.getTarget().getClass());
    }

    public boolean isSet() {
        return this.getSetClass().isAssignableFrom(this.getTarget().getClass());
    }

    public IValue getIndex() {
        Object targetIndex;
        if (this.index == null && this.isList() && (targetIndex = Util.invokeMethod(this.getTarget(), "getIndex", new Class[0], new Object[0])) != null) {
            this.index = this.getFacadeFactory().createValue(targetIndex);
        }
        return this.index;
    }

    public String getElementClassName() {
        String result = null;
        if (this.isArray()) {
            result = (String)Util.invokeMethod(this.getTarget(), "getElementClassName", new Class[0], new Object[0]);
        }
        return result;
    }

    public boolean isArray() {
        return this.getArrayClass().isAssignableFrom(this.getTarget().getClass());
    }

    public boolean isPrimitiveArray() {
        return this.getPrimitiveArrayClass().isAssignableFrom(this.getTarget().getClass());
    }

    public String getTypeName() {
        String result = null;
        if (this.isSimpleValue()) {
            result = (String)Util.invokeMethod(this.getTarget(), "getTypeName", new Class[0], new Object[0]);
        }
        return result;
    }

    public boolean isIdentifierBag() {
        return this.getIdentifierBagClass().isAssignableFrom(this.getTarget().getClass());
    }

    public boolean isBag() {
        return this.getBagClass().isAssignableFrom(this.getTarget().getClass());
    }

    public String getReferencedEntityName() {
        String result = null;
        if (this.isOneToMany() || this.isToOne()) {
            result = (String)Util.invokeMethod(this.getTarget(), "getReferencedEntityName", new Class[0], new Object[0]);
        }
        return result;
    }

    public String getEntityName() {
        String result = null;
        if (this.isOneToOne()) {
            result = (String)Util.invokeMethod(this.getTarget(), "getEntityName", new Class[0], new Object[0]);
        }
        return result;
    }

    public Iterator<IProperty> getPropertyIterator() {
        if (this.properties == null) {
            this.initializeProperties();
        }
        return this.properties.iterator();
    }

    public void addColumn(IColumn column) {
        Object columnTarget = Util.invokeMethod(column, "getTarget", new Class[0], new Object[0]);
        Util.invokeMethod(this.getTarget(), "addColumn", new Class[]{this.getColumnClass()}, new Object[]{columnTarget});
    }

    public void setTypeParameters(Properties typeParameters) {
        Util.invokeMethod(this.getTarget(), "setTypeParameters", new Class[]{Properties.class}, new Object[]{typeParameters});
    }

    public String getForeignKeyName() {
        return (String)Util.invokeMethod(this.getTarget(), "getForeignKeyName", new Class[0], new Object[0]);
    }

    public IPersistentClass getOwner() {
        Object targetOwner;
        if (this.owner == null && (targetOwner = Util.invokeMethod(this.getTarget(), "getOwner", new Class[0], new Object[0])) != null) {
            this.owner = this.getFacadeFactory().createPersistentClass(targetOwner);
        }
        return this.owner;
    }

    public IValue getElement() {
        IValue result = null;
        Object targetElement = Util.invokeMethod(this.getTarget(), "getElement", new Class[0], new Object[0]);
        if (targetElement != null) {
            result = this.getFacadeFactory().createValue(targetElement);
        }
        return result;
    }

    public String getParentProperty() {
        return (String)Util.invokeMethod(this.getTarget(), "getParentProperty", new Class[0], new Object[0]);
    }

    public void setElementClassName(String name) {
        Util.invokeMethod(this.getTarget(), "setElementClassName", new Class[]{String.class}, new Object[]{name});
    }

    public void setKey(IValue keyValue) {
        Object keyValueTarget = Util.invokeMethod(keyValue, "getTarget", new Class[0], new Object[0]);
        Util.invokeMethod(this.getTarget(), "setKey", new Class[]{this.getKeyValueClass()}, new Object[]{keyValueTarget});
    }

    public void setFetchModeJoin() {
        if (this.isCollection() || this.isToOne()) {
            Object fetchModeJoin = Util.getFieldValue(this.getFetchModeClass(), "JOIN", null);
            Util.invokeMethod(this.getTarget(), "setFetchMode", new Class[]{this.getFetchModeClass()}, new Object[]{fetchModeJoin});
        }
    }

    public boolean isInverse() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isInverse", new Class[0], new Object[0]);
    }

    public IPersistentClass getAssociatedClass() {
        Object targetAssociatedClass;
        if (this.associatedClass == null && (targetAssociatedClass = Util.invokeMethod(this.getTarget(), "getAssociatedClass", new Class[0], new Object[0])) != null) {
            this.associatedClass = this.getFacadeFactory().createPersistentClass(targetAssociatedClass);
        }
        return this.associatedClass;
    }

    public void setLazy(boolean b) {
        Util.invokeMethod(this.getTarget(), "setLazy", new Class[]{Boolean.TYPE}, new Object[]{b});
    }

    public void setRole(String role) {
        Util.invokeMethod(this.getTarget(), "setRole", new Class[]{String.class}, new Object[]{role});
    }

    public void setReferencedEntityName(String name) {
        if (this.isToOne() || this.isOneToMany()) {
            Util.invokeMethod(this.getTarget(), "setReferencedEntityName", new Class[]{String.class}, new Object[]{name});
        }
    }

    public void setAssociatedClass(IPersistentClass persistentClass) {
        Object persistentClassTarget = Util.invokeMethod(persistentClass, "getTarget", new Class[0], new Object[0]);
        Util.invokeMethod(this.getTarget(), "setAssociatedClass", new Class[]{this.getPersistentClassClass()}, new Object[]{persistentClassTarget});
    }

    protected Class<?> getCollectionClass() {
        return Util.getClass(this.collectionClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getOneToManyClass() {
        return Util.getClass(this.oneToManyClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getManyToOneClass() {
        return Util.getClass(this.manyToOneClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getOneToOneClass() {
        return Util.getClass(this.oneToOneClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getMapClass() {
        return Util.getClass(this.mapClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getComponentClass() {
        return Util.getClass(this.componentClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getToOneClass() {
        return Util.getClass(this.toOneClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getValueClass() {
        return Util.getClass(this.valueClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getTableClass() {
        return Util.getClass(this.tableClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getListClass() {
        return Util.getClass(this.listClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getColumnClass() {
        return Util.getClass(this.columnClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getDependantValueClass() {
        return Util.getClass(this.dependantValueClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getAnyClass() {
        return Util.getClass(this.anyClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getSetClass() {
        return Util.getClass(this.setClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getArrayClass() {
        return Util.getClass(this.arrayClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getPrimitiveArrayClass() {
        return Util.getClass(this.primitiveArrayClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getIdentifierBagClass() {
        return Util.getClass(this.identifierBagClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getBagClass() {
        return Util.getClass(this.bagClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getKeyValueClass() {
        return Util.getClass(this.keyValueClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getFetchModeClass() {
        return Util.getClass(this.fetchModeClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getPersistentClassClass() {
        return Util.getClass(this.persistentClassClassName(), this.getFacadeFactoryClassLoader());
    }

    protected String collectionClassName() {
        return "org.hibernate.mapping.Collection";
    }

    protected String oneToManyClassName() {
        return "org.hibernate.mapping.OneToMany";
    }

    protected String manyToOneClassName() {
        return "org.hibernate.mapping.ManyToOne";
    }

    protected String oneToOneClassName() {
        return "org.hibernate.mapping.OneToOne";
    }

    protected String mapClassName() {
        return "org.hibernate.mapping.Map";
    }

    protected String componentClassName() {
        return "org.hibernate.mapping.Component";
    }

    protected String toOneClassName() {
        return "org.hibernate.mapping.ToOne";
    }

    protected String valueClassName() {
        return "org.hibernate.mapping.Value";
    }

    protected String tableClassName() {
        return "org.hibernate.mapping.Table";
    }

    protected String listClassName() {
        return "org.hibernate.mapping.List";
    }

    protected String columnClassName() {
        return "org.hibernate.mapping.Column";
    }

    protected String dependantValueClassName() {
        return "org.hibernate.mapping.DependantValue";
    }

    protected String anyClassName() {
        return "org.hibernate.mapping.Any";
    }

    protected String setClassName() {
        return "org.hibernate.mapping.Set";
    }

    protected String arrayClassName() {
        return "org.hibernate.mapping.Array";
    }

    protected String primitiveArrayClassName() {
        return "org.hibernate.mapping.PrimitiveArray";
    }

    protected String identifierBagClassName() {
        return "org.hibernate.mapping.IdentifierBag";
    }

    protected String bagClassName() {
        return "org.hibernate.mapping.Bag";
    }

    protected String keyValueClassName() {
        return "org.hibernate.mapping.KeyValue";
    }

    protected String fetchModeClassName() {
        return "org.hibernate.FetchMode";
    }

    protected String persistentClassClassName() {
        return "org.hibernate.mapping.PersistentClass";
    }

    private void initializeColumns() {
        this.columns = new HashSet();
        Iterator iterator = (Iterator)Util.invokeMethod(this.getTarget(), "getColumnIterator", new Class[0], new Object[0]);
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!this.getColumnClass().isAssignableFrom(object.getClass())) continue;
            this.columns.add(this.getFacadeFactory().createColumn(object));
        }
    }

    private void initializeProperties() {
        this.properties = new HashSet();
        Iterator iterator = (Iterator)Util.invokeMethod(this.getTarget(), "getPropertyIterator", new Class[0], new Object[0]);
        while (iterator.hasNext()) {
            this.properties.add(this.getFacadeFactory().createProperty(iterator.next()));
        }
    }
}

