/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.runtime.common;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.jboss.tools.hibernate.runtime.common.AbstractFacade;
import org.jboss.tools.hibernate.runtime.common.IFacadeFactory;
import org.jboss.tools.hibernate.runtime.common.Util;
import org.jboss.tools.hibernate.runtime.spi.IHQLCodeAssist;
import org.jboss.tools.hibernate.runtime.spi.IHQLCompletionHandler;

public abstract class AbstractHQLCodeAssistFacade
extends AbstractFacade
implements IHQLCodeAssist {
    public AbstractHQLCodeAssistFacade(IFacadeFactory facadeFactory, Object target) {
        super(facadeFactory, target);
    }

    public void codeComplete(String query, int currentOffset, IHQLCompletionHandler handler) {
        Util.invokeMethod(this.getTarget(), "codeComplete", new Class[]{String.class, Integer.TYPE, this.getIHQLCompletionRequestorClass()}, new Object[]{query, currentOffset, this.createIHQLCompletionRequestor(handler)});
    }

    protected Object createIHQLCompletionRequestor(IHQLCompletionHandler handler) {
        return Proxy.newProxyInstance(this.getFacadeFactoryClassLoader(), new Class[]{this.getIHQLCompletionRequestorClass()}, (InvocationHandler)new HQLCompletionRequestorInvocationHandler(handler));
    }

    protected Class<?> getIHQLCompletionRequestorClass() {
        return Util.getClass(this.getIHQLCompletionRequestorClassName(), this.getFacadeFactoryClassLoader());
    }

    protected String getIHQLCompletionRequestorClassName() {
        return "org.hibernate.tool.ide.completion.IHQLCompletionRequestor";
    }

    protected class HQLCompletionRequestorInvocationHandler
    implements InvocationHandler {
        private IHQLCompletionHandler handler = null;

        public HQLCompletionRequestorInvocationHandler(IHQLCompletionHandler handler) {
            this.handler = handler;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Boolean result = null;
            String methodName = method.getName();
            if ("accept".equals(methodName)) {
                result = this.handler.accept(AbstractHQLCodeAssistFacade.this.getFacadeFactory().createHQLCompletionProposal(args[0]));
            } else if ("completionFailure".equals(methodName)) {
                this.handler.completionFailure((String)args[0]);
            }
            return result;
        }
    }
}

