/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.runtime.common;

import org.jboss.tools.hibernate.runtime.common.AbstractFacade;
import org.jboss.tools.hibernate.runtime.common.IFacadeFactory;
import org.jboss.tools.hibernate.runtime.common.Util;
import org.jboss.tools.hibernate.runtime.spi.IColumn;
import org.jboss.tools.hibernate.runtime.spi.IDialect;
import org.jboss.tools.hibernate.runtime.spi.IMapping;
import org.jboss.tools.hibernate.runtime.spi.IValue;

public abstract class AbstractColumnFacade
extends AbstractFacade
implements IColumn {
    private IValue value = null;

    public AbstractColumnFacade(IFacadeFactory facadeFactory, Object target) {
        super(facadeFactory, target);
    }

    public String getName() {
        return (String)Util.invokeMethod(this.getTarget(), "getName", new Class[0], new Object[0]);
    }

    public Integer getSqlTypeCode() {
        return (Integer)Util.invokeMethod(this.getTarget(), "getSqlTypeCode", new Class[0], new Object[0]);
    }

    public String getSqlType() {
        return (String)Util.invokeMethod(this.getTarget(), "getSqlType", new Class[0], new Object[0]);
    }

    public int getLength() {
        return (Integer)Util.invokeMethod(this.getTarget(), "getLength", new Class[0], new Object[0]);
    }

    public int getDefaultLength() {
        return (Integer)Util.getFieldValue(this.getColumnClass(), "DEFAULT_LENGTH", null);
    }

    public int getPrecision() {
        return (Integer)Util.invokeMethod(this.getTarget(), "getPrecision", new Class[0], new Object[0]);
    }

    public int getDefaultPrecision() {
        return (Integer)Util.getFieldValue(this.getColumnClass(), "DEFAULT_PRECISION", null);
    }

    public int getScale() {
        return (Integer)Util.invokeMethod(this.getTarget(), "getScale", new Class[0], new Object[0]);
    }

    public int getDefaultScale() {
        return (Integer)Util.getFieldValue(this.getColumnClass(), "DEFAULT_SCALE", null);
    }

    public boolean isNullable() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isNullable", new Class[0], new Object[0]);
    }

    public IValue getValue() {
        Object targetValue = this.getTargetValue();
        if (targetValue != null && this.value == null) {
            this.value = this.getFacadeFactory().createValue(targetValue);
        }
        return this.value;
    }

    public boolean isUnique() {
        return (Boolean)Util.invokeMethod(this.getTarget(), "isUnique", new Class[0], new Object[0]);
    }

    public String getSqlType(IDialect dialect, IMapping mapping) {
        Object dialectTarget = Util.invokeMethod(dialect, "getTarget", new Class[0], new Object[0]);
        Object mappingTarget = Util.invokeMethod(mapping, "getTarget", new Class[0], new Object[0]);
        return (String)Util.invokeMethod(this.getTarget(), "getSqlType", new Class[]{this.getDialectClass(), this.getMappingClass()}, new Object[]{dialectTarget, mappingTarget});
    }

    public void setSqlType(String sqlType) {
        Util.invokeMethod(this.getTarget(), "setSqlType", new Class[]{String.class}, new Object[]{sqlType});
    }

    protected Class<?> getColumnClass() {
        return Util.getClass(this.getColumnClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getDialectClass() {
        return Util.getClass(this.getDialectClassName(), this.getFacadeFactoryClassLoader());
    }

    protected Class<?> getMappingClass() {
        return Util.getClass(this.getMappingClassName(), this.getFacadeFactoryClassLoader());
    }

    protected String getColumnClassName() {
        return "org.hibernate.mapping.Column";
    }

    protected String getDialectClassName() {
        return "org.hibernate.dialect.Dialect";
    }

    protected String getMappingClassName() {
        return "org.hibernate.engine.spi.Mapping";
    }

    private Object getTargetValue() {
        return Util.invokeMethod(this.getTarget(), "getValue", new Class[0], new Object[0]);
    }
}

