/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.project;

import com.openshift.restclient.model.IProject;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.databinding.ParametrizableWizardPageSupport;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIMessages;
import org.jboss.tools.openshift.internal.ui.validator.ProjectNameValidator;
import org.jboss.tools.openshift.internal.ui.wizard.project.NewProjectWizardModel;

public class NewProjectWizardPage
extends AbstractOpenShiftWizardPage {
    private NewProjectWizardModel model;

    public NewProjectWizardPage(NewProjectWizardModel model, IWizard wizard) {
        this("New OpenShift Project", "Please provide name, display name and description", model, wizard);
    }

    protected NewProjectWizardPage(String title, String description, NewProjectWizardModel model, IWizard wizard) {
        super(title, description, "", wizard);
        this.model = model;
    }

    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridDataFactory.fillDefaults().grab(true, false).align(4, 128).applyTo((Control)parent);
        GridLayoutFactory.fillDefaults().margins(6, 6).numColumns(2).applyTo(parent);
        Label lblName = new Label(parent, 0);
        lblName.setText(OpenShiftUIMessages.Name);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)lblName);
        Text txtName = new Text(parent, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)txtName);
        ISWTObservableValue nameTextObservable = WidgetProperties.text((int)24).observe((Widget)txtName);
        Binding nameBinding = ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)nameTextObservable).validatingAfterConvert((IValidator)new ProjectNameValidator(this.getDescription(), this.model.getUnavailableNames()))).to(BeanProperties.value((String)"projectName").observe((Object)this.model)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)nameBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        Label lblDisplayName = new Label(parent, 0);
        lblDisplayName.setText(OpenShiftUIMessages.DisplayName);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)lblDisplayName);
        Text txtDispalayName = new Text(parent, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)txtDispalayName);
        ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observe((Widget)txtDispalayName)).validatingAfterConvert(new IValidator(){

            public IStatus validate(Object value) {
                String param = (String)value;
                if (StringUtils.isNotEmpty((String)param) && (param.contains("\t") || param.contains("\n"))) {
                    return ValidationStatus.error((String)"Display name may not contain tabs or new lines");
                }
                return ValidationStatus.ok();
            }
        })).to(BeanProperties.value((String)"displayName").observe((Object)this.model)).in(dbc);
        Label lblDescription = new Label(parent, 0);
        lblDescription.setText(OpenShiftUIMessages.Description);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)lblDisplayName);
        Text txtDescription = new Text(parent, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)txtDescription);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observe((Widget)txtDescription)).to(BeanProperties.value((String)"description").observe((Object)this.model)).in(dbc);
    }

    public IProject getProject() {
        return this.model.getProject();
    }

    protected NewProjectWizardModel getModel() {
        return this.model;
    }

    protected void setupWizardPageSupport(DataBindingContext dbc) {
        ParametrizableWizardPageSupport.create((int)12, (WizardPage)this, (DataBindingContext)dbc);
    }
}

