/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.project;

import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.model.IProject;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.openshift.common.ui.wizard.AbstractOpenShiftWizard;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.wizard.project.NewProjectWizardModel;
import org.jboss.tools.openshift.internal.ui.wizard.project.NewProjectWizardPage;

public class NewProjectWizard
extends AbstractOpenShiftWizard<NewProjectWizardModel> {
    private NewProjectWizardPage newProjectWizardPage;

    public NewProjectWizard(Connection connection, List<IProject> projects) {
        super("Create OpenShift Project", (Object)new NewProjectWizardModel(connection, projects));
    }

    public boolean performFinish() {
        AbstractDelegatingMonitorJob job = new AbstractDelegatingMonitorJob(NLS.bind((String)"Creating project {0}...", (Object)((NewProjectWizardModel)((Object)this.getModel())).getProjectName())){

            protected IStatus doRun(IProgressMonitor monitor) {
                try {
                    ((NewProjectWizardModel)((Object)NewProjectWizard.this.getModel())).createProject();
                    return Status.OK_STATUS;
                }
                catch (OpenShiftException e) {
                    String problem = e.getStatus() == null ? e.getMessage() : e.getStatus().getMessage();
                    return OpenShiftUIActivator.statusFactory().errorStatus(NLS.bind((String)"Could not create project \"{0}\": {1}", (Object)((NewProjectWizardModel)((Object)NewProjectWizard.this.getModel())).getProjectName(), (Object)problem), (Throwable)e);
                }
            }
        };
        try {
            WizardUtils.runInWizard((Job)job, (IWizardContainer)this.getContainer());
        }
        catch (InterruptedException | InvocationTargetException e) {
            OpenShiftUIActivator.getDefault().getLogger().logError("Could not create project", (Throwable)e);
        }
        return job.getResult().isOK();
    }

    public void addPages() {
        this.newProjectWizardPage = new NewProjectWizardPage((NewProjectWizardModel)((Object)this.getModel()), (IWizard)this);
        this.addPage((IWizardPage)this.newProjectWizardPage);
    }

    public IProject getProject() {
        return this.newProjectWizardPage.getProject();
    }
}

