/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.newapp;

import com.openshift.restclient.model.template.IParameter;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.map.ObservableMap;
import org.eclipse.core.databinding.observable.map.WritableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.internal.common.ui.databinding.IsNotNull2BooleanConverter;
import org.jboss.tools.openshift.internal.common.ui.utils.TableViewerBuilder;
import org.jboss.tools.openshift.internal.common.ui.utils.TableViewerCellDecorationManager;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.ITemplateParametersPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.TemplateParameterDetailViews;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.TemplateParameterViewerUtils;

public class TemplateParametersPage
extends AbstractOpenShiftWizardPage {
    private ITemplateParametersPageModel model;
    private TableViewer viewer;

    public TemplateParametersPage(IWizard wizard, ITemplateParametersPageModel model) {
        super("Template Parameters", "Edit the parameter values to be substituted into the template.", "Template Parameter Page", wizard);
        this.model = model;
    }

    protected void doCreateControls(Composite container, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().numColumns(2).margins(10, 10).applyTo(container);
        Composite tableContainer = new Composite(container, 0);
        IObservableList parametersObservable = BeanProperties.list((String)"parameters").observe((Object)this.model);
        this.viewer = this.createTable(tableContainer, parametersObservable, dbc);
        GridDataFactory.fillDefaults().span(1, 5).align(4, 4).grab(true, true).hint(500, 300).applyTo((Control)tableContainer);
        IObservableValue selectedParameter = BeanProperties.value((String)"selectedParameter").observe((Object)this.model);
        ValueBindingBuilder.bind((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)this.viewer)).to(selectedParameter).in(dbc);
        this.viewer.setInput((Object)parametersObservable);
        this.viewer.addDoubleClickListener(this.onDoubleClick());
        Button editExistingButton = new Button(container, 8);
        GridDataFactory.fillDefaults().align(4, 4).hint(100, -1).applyTo((Control)editExistingButton);
        editExistingButton.setText("Edit...");
        editExistingButton.addSelectionListener(this.onEdit());
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)editExistingButton)).notUpdatingParticipant()).to(selectedParameter).converting((IConverter)new IsNotNull2BooleanConverter())).in(dbc);
        Button resetButton = new Button(container, 8);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)resetButton);
        resetButton.setText("Reset");
        resetButton.addSelectionListener(this.onReset());
        Label requiredExplanationLabel = new Label(container, 0);
        requiredExplanationLabel.setText("* = value required, click the 'Edit...' button or double-click on a value to edit it.");
        GridDataFactory.fillDefaults().grab(true, false).align(4, 4).span(2, 1).applyTo((Control)requiredExplanationLabel);
        Group detailsContainer = new Group(container, 0);
        detailsContainer.setText("Details");
        GridDataFactory.fillDefaults().align(4, 4).span(2, 1).hint(-1, 106).applyTo((Control)detailsContainer);
        new TemplateParameterDetailViews(selectedParameter, (Composite)detailsContainer, dbc).createControls();
    }

    private IListChangeListener onParametersChanged(final TableViewerCellDecorationManager cellDecorations, final ObservableMap validationStatusByParameter) {
        return new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                validationStatusByParameter.clear();
                cellDecorations.hideAll();
            }
        };
    }

    private IDoubleClickListener onDoubleClick() {
        return new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                IParameter param = (IParameter)selection.getFirstElement();
                TemplateParametersPage.this.openEditDialog(param);
            }
        };
    }

    public TableViewer createTable(Composite tableContainer, IObservableList parametersObservable, DataBindingContext dbc) {
        Table table = new Table(tableContainer, 68352);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        Image decorationImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        WritableMap cellsValidationStatusObservable = new WritableMap(String.class, IStatus.class);
        TableViewerCellDecorationManager decorations = new TableViewerCellDecorationManager(decorationImage, table);
        parametersObservable.addListChangeListener(this.onParametersChanged(decorations, (ObservableMap)cellsValidationStatusObservable));
        TableViewer viewer = new TableViewerBuilder(table, tableContainer).contentProvider((IStructuredContentProvider)new ArrayContentProvider()).column(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Assert.isLegal((boolean)(cell.getElement() instanceof IParameter), (String)"cell element is not a IParameter");
                IParameter parameter = (IParameter)cell.getElement();
                String label = parameter.getName();
                if (parameter.isRequired()) {
                    label = this.markRequired(label);
                }
                cell.setText(label);
            }

            private String markRequired(String label) {
                label = String.valueOf(label) + " *";
                return label;
            }

            public String getToolTipText(Object object) {
                Assert.isLegal((boolean)(object instanceof IParameter), (String)"cell element is not a IParameter");
                return ((IParameter)object).getDescription();
            }

            public int getToolTipDisplayDelayTime(Object object) {
                return 0;
            }
        }).name("Name").align(16384).weight(1).minWidth(180).buildColumn().column(new CellLabelProvider((ObservableMap)cellsValidationStatusObservable, decorations){
            private final /* synthetic */ ObservableMap val$cellsValidationStatusObservable;
            private final /* synthetic */ TableViewerCellDecorationManager val$decorations;
            {
                this.val$cellsValidationStatusObservable = observableMap;
                this.val$decorations = tableViewerCellDecorationManager;
            }

            public void update(ViewerCell cell) {
                Assert.isLegal((boolean)(cell.getElement() instanceof IParameter), (String)"cell element is not a IParameter");
                IParameter parameter = (IParameter)cell.getElement();
                String label = TemplateParameterViewerUtils.getValueLabel(parameter);
                cell.setText(label);
                IStatus validationStatus = this.validate(parameter);
                this.val$cellsValidationStatusObservable.put((Object)parameter.getName(), (Object)validationStatus);
                this.val$decorations.toggle(!validationStatus.isOK(), cell);
            }

            private IStatus validate(IParameter parameter) {
                if (parameter.isRequired() && StringUtils.isEmpty((String)parameter.getValue()) && StringUtils.isEmpty((String)parameter.getGeneratorName())) {
                    return ValidationStatus.error((String)NLS.bind((String)"Parameter {0} is required, please provide a value.", (Object)parameter.getName()));
                }
                return ValidationStatus.ok();
            }

            public String getToolTipText(Object object) {
                Assert.isLegal((boolean)(object instanceof IParameter), (String)"cell element is not a IParameter");
                return ((IParameter)object).getDescription();
            }

            public int getToolTipDisplayDelayTime(Object object) {
                return 0;
            }
        }).name("Value").align(16384).weight(1).buildColumn().buildViewer();
        viewer.setComparator((ViewerComparator)new TemplateParameterViewerUtils.ParameterNameViewerComparator());
        viewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        dbc.addValidationStatusProvider((ValidationStatusProvider)new MultiValidator((ObservableMap)cellsValidationStatusObservable){
            private final /* synthetic */ ObservableMap val$cellsValidationStatusObservable;
            {
                this.val$cellsValidationStatusObservable = observableMap;
            }

            protected IStatus validate() {
                for (IStatus cellValidationStatus : this.val$cellsValidationStatusObservable.values()) {
                    if (cellValidationStatus == null || cellValidationStatus.isOK()) continue;
                    return cellValidationStatus;
                }
                return ValidationStatus.ok();
            }
        });
        return viewer;
    }

    private SelectionListener onEdit() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateParametersPage.this.openEditDialog(TemplateParametersPage.this.getSelectedParameter());
            }
        };
    }

    private void openEditDialog(IParameter parameter) {
        InputDialog dialog = new InputDialog(this.getShell(), "Edit Template Parameter", NLS.bind((String)"Please enter a value for {0}.\n{1}", (Object)parameter.getName(), (Object)parameter.getDescription()), parameter.getValue(), (IInputValidator)(parameter.isRequired() ? new RequiredValueInputValidator(parameter.getName()) : null));
        if (dialog.open() == 0) {
            this.model.updateParameterValue(parameter, dialog.getValue());
            this.viewer.refresh();
        }
    }

    private SelectionListener onReset() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TemplateParametersPage.this.model.resetParameter(TemplateParametersPage.this.getSelectedParameter());
                TemplateParametersPage.this.viewer.refresh();
            }
        };
    }

    private IParameter getSelectedParameter() {
        return (IParameter)this.viewer.getStructuredSelection().getFirstElement();
    }

    private static class RequiredValueInputValidator
    implements IInputValidator {
        private String field;

        public RequiredValueInputValidator(String field) {
            this.field = field;
        }

        public String isValid(String newText) {
            if (StringUtils.isEmpty((String)newText)) {
                return NLS.bind((String)"{0} is a required value, please provide a value.", (Object)this.field);
            }
            return null;
        }
    }
}

