/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.newapp;

import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.UnsupportedVersionException;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.template.ITemplate;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.list.MultiListProperty;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.fieldassist.AutoCompleteField;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.progress.UIJob;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.common.core.utils.ProjectUtils;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.egit.core.EGitUtils;
import org.jboss.tools.openshift.egit.ui.util.EGitUIUtils;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.internal.common.core.job.JobChainBuilder;
import org.jboss.tools.openshift.internal.common.ui.SelectExistingProjectDialog;
import org.jboss.tools.openshift.internal.common.ui.databinding.IsNotNull2BooleanConverter;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.databinding.TabFolderSelectionProperty;
import org.jboss.tools.openshift.internal.common.ui.job.UIUpdatingJob;
import org.jboss.tools.openshift.internal.common.ui.utils.StyledTextUtils;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.common.ui.wizard.OkCancelButtonWizardDialog;
import org.jboss.tools.openshift.internal.core.util.ResourceUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.dialog.ResourceSummaryDialog;
import org.jboss.tools.openshift.internal.ui.treeitem.Model2ObservableTreeItemConverter;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem2ModelConverter;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItemLabelProvider;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItemStyledCellLabelProvider;
import org.jboss.tools.openshift.internal.ui.wizard.builder.ProjectBuilderTypeDetector;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.ITemplateListPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.ResourceDetailsContentProvider;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.ResourceDetailsLabelProvider;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.TemplateDetailViews;
import org.jboss.tools.openshift.internal.ui.wizard.newapp.TemplateTreeItems;
import org.jboss.tools.openshift.internal.ui.wizard.project.ManageProjectsWizard;
import org.jboss.tools.openshift.internal.ui.wizard.project.NewProjectWizard;

public class TemplateListPage
extends AbstractOpenShiftWizardPage {
    private static final int LOCAL_TEMPLATE_TAB_INDEX = 1;
    private ITemplateListPageModel model;
    private TreeViewer templatesViewer;

    public TemplateListPage(IWizard wizard, ITemplateListPageModel model) {
        super("Select template", "Server template choices may be filtered by typing the name of a tag in the text field.", "templateList", wizard);
        this.model = model;
    }

    protected void doCreateControls(final Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().numColumns(3).margins(10, 6).spacing(6, 6).applyTo(parent);
        this.createProjectControls(parent, dbc);
        IObservableValue selectedEclipseProject = this.createEclipseProjectControls(parent, dbc);
        TabFolder tabContainer = new TabFolder(parent, 0);
        GridDataFactory.fillDefaults().span(3, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)tabContainer);
        tabContainer.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                parent.layout(true, false);
            }
        });
        IObservableValue useLocalTemplateObservable = BeanProperties.value((String)"useLocalTemplate").observe((Object)this.model);
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)new TabFolderSelectionProperty().observe((Widget)tabContainer)).converting((IConverter)new Converter(Integer.class, Boolean.class){

            public Object convert(Object fromObject) {
                return Integer.valueOf(1).equals(fromObject);
            }
        })).to(useLocalTemplateObservable).converting((IConverter)new Converter(Boolean.class, Integer.class){

            public Object convert(Object fromObject) {
                return fromObject != null && (Boolean)fromObject != false ? 1 : 0;
            }
        })).in(dbc);
        IObservableValue serverTemplate = this.createServerTemplateControls(tabContainer, useLocalTemplateObservable, dbc);
        IObservableValue localTemplateFilename = this.createLocalTemplateControls(tabContainer, useLocalTemplateObservable, dbc);
        this.createDetailsGroup(parent, dbc);
        this.model.setUseLocalTemplate(false);
        IObservableValue selectedTemplate = BeanProperties.value((String)"selectedTemplate").observe((Object)this.model);
        TemplateListPageValidator pageValidator = new TemplateListPageValidator(useLocalTemplateObservable, localTemplateFilename, serverTemplate, selectedTemplate, selectedEclipseProject, parent);
        dbc.addValidationStatusProvider((ValidationStatusProvider)pageValidator);
        ControlDecorationSupport.create((ValidationStatusProvider)pageValidator, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
    }

    private IObservableValue createEclipseProjectControls(Composite parent, DataBindingContext dbc) {
        Label existingProjectLabel = new Label(parent, 0);
        existingProjectLabel.setText("Use existing workspace project:");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)existingProjectLabel);
        Text existingProjectNameText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)existingProjectNameText);
        ISWTObservableValue projectNameTextObservable = WidgetProperties.text((int)24).observe((Widget)existingProjectNameText);
        IObservableValue eclipseProjectObservable = BeanProperties.value((String)"eclipseProject").observe((Object)this.model);
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)projectNameTextObservable).converting((IConverter)new Converter(String.class, IProject.class){

            public Object convert(Object fromObject) {
                String name = (String)fromObject;
                return ProjectUtils.getProject((String)name);
            }
        })).to(eclipseProjectObservable).converting((IConverter)new Converter(IProject.class, String.class){

            public Object convert(Object fromObject) {
                return fromObject == null ? "" : ((IProject)fromObject).getName();
            }
        })).in(dbc);
        ControlDecoration dec = new ControlDecoration((Control)existingProjectNameText, 131200);
        FieldDecoration contentProposalFieldIndicator = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        dec.setImage(contentProposalFieldIndicator.getImage());
        dec.setDescriptionText("Auto-completion is enabled when you start typing a project name.");
        dec.setShowOnlyOnFocus(true);
        new AutoCompleteField((Control)existingProjectNameText, (IControlContentAdapter)new TextContentAdapter(), ProjectUtils.getAllAccessibleProjectNames());
        Button browseProjectsButton = new Button(parent, 0);
        browseProjectsButton.setText("Browse...");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).hint(100, -1).grab(false, false).applyTo((Control)browseProjectsButton);
        browseProjectsButton.addSelectionListener(this.onBrowseProjects());
        final Link gitLabel = new Link(parent, 0);
        gitLabel.setText("The project needs to be <a>shared with Git</a> and have a remote repository accessible by OpenShift");
        gitLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IProject p = TemplateListPage.this.model.getEclipseProject();
                        TemplateListPage.this.model.setEclipseProject(null);
                        EGitUIUtils.openGitSharingWizard((Shell)Display.getCurrent().getActiveShell(), (IProject)p);
                        TemplateListPage.this.model.setEclipseProject(p);
                    }
                });
            }
        });
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)gitLabel);
        eclipseProjectObservable.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                IProject p = (IProject)event.getObservableValue().getValue();
                TemplateListPage.this.toggleEgitLink(gitLabel, p);
            }
        });
        this.toggleEgitLink(gitLabel, this.model.getEclipseProject());
        return projectNameTextObservable;
    }

    private SelectionListener onBrowseProjects() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectExistingProjectDialog dialog = new SelectExistingProjectDialog(TemplateListPage.this.model.getEclipseProject() == null ? null : TemplateListPage.this.model.getEclipseProject().getName(), TemplateListPage.this.getShell());
                if (dialog.open() == 0) {
                    Object selectedProject = dialog.getFirstResult();
                    TemplateListPage.this.model.setEclipseProject((IProject)selectedProject);
                }
            }
        };
    }

    private void createProjectControls(Composite parent, DataBindingContext dbc) {
        Label projectLabel = new Label(parent, 0);
        projectLabel.setText("OpenShift project: ");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)projectLabel);
        ComboViewer projectsViewer = new ComboViewer(parent);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo(projectsViewer.getControl());
        projectsViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        projectsViewer.setLabelProvider((IBaseLabelProvider)new ObservableTreeItemLabelProvider());
        projectsViewer.setInput((Object)BeanProperties.list((String)"projectItems").observe((Object)this.model));
        IViewerObservableValue selectedProjectObservable = ViewerProperties.singleSelection().observe((Viewer)projectsViewer);
        Binding selectedProjectBinding = ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)selectedProjectObservable).converting((IConverter)new ObservableTreeItem2ModelConverter(com.openshift.restclient.model.IProject.class))).validatingAfterConvert(new IValidator(){

            public IStatus validate(Object value) {
                if (value instanceof com.openshift.restclient.model.IProject) {
                    return ValidationStatus.ok();
                }
                return ValidationStatus.cancel((String)"Please choose an OpenShift project.");
            }
        })).to(BeanProperties.value((String)"project").observe((Object)this.model)).converting((IConverter)new Model2ObservableTreeItemConverter(TemplateTreeItems.INSTANCE))).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)selectedProjectBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
        BeanProperties.value((String)"connection").observe((Object)this.model).addValueChangeListener(this.onConnectionChanged());
        StyledText manageProjectsLink = StyledTextUtils.emulateLinkWidget((String)"<a>Manage Projects</a>", (StyledText)new StyledText(parent, 64));
        GridDataFactory.fillDefaults().align(16384, 0x1000000).indent(8, 0).applyTo((Control)manageProjectsLink);
        manageProjectsLink.addListener(3, this.onManageProjectsClicked());
        Label filler = new Label(parent, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).applyTo((Control)filler);
    }

    private Listener onManageProjectsClicked() {
        return new Listener(){

            public void handleEvent(Event event) {
                try {
                    WizardUtils.runInWizard((Job)new UIUpdatingJob("Opening projects wizard..."){

                        protected IStatus run(IProgressMonitor monitor) {
                            return Status.OK_STATUS;
                        }

                        protected IStatus updateUI(IProgressMonitor monitor) {
                            com.openshift.restclient.model.IProject selectedProject;
                            ManageProjectsWizard manageProjectsWizard = new ManageProjectsWizard((Connection)TemplateListPage.this.model.getConnection());
                            int result = new OkCancelButtonWizardDialog(TemplateListPage.this.getShell(), (IWizard)manageProjectsWizard).open();
                            if (manageProjectsWizard.hasChanged()) {
                                TemplateListPage.this.loadResources(TemplateListPage.this.templatesViewer, TemplateListPage.this.model);
                            }
                            if (result == 0 && (selectedProject = manageProjectsWizard.getSelectedProject()) != null) {
                                TemplateListPage.this.model.setProject(selectedProject);
                            }
                            return Status.OK_STATUS;
                        }
                    }, (IWizardContainer)TemplateListPage.this.getContainer());
                }
                catch (InterruptedException | InvocationTargetException exception) {}
            }
        };
    }

    private IObservableValue createLocalTemplateControls(TabFolder tabContainer, IObservableValue useLocalTemplate, DataBindingContext dbc) {
        TabItem localTemplatesTab = new TabItem(tabContainer, 0);
        localTemplatesTab.setText("Local template");
        Composite parent = new Composite((Composite)tabContainer, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(10, 10).spacing(6, 2).applyTo(parent);
        Label lbl = new Label(parent, 0);
        lbl.setText("Select a local template:");
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)lbl);
        Text txtLocalTemplateFileName = new Text(parent, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)txtLocalTemplateFileName);
        ISWTObservableValue localTemplateFilename = WidgetProperties.text((int)24).observe((Widget)txtLocalTemplateFileName);
        ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)localTemplateFilename).to(BeanProperties.value((String)"localTemplateFileName").observe((Object)this.model)).validatingBeforeSet(o -> this.isFile(o.toString()) ? ValidationStatus.ok() : ValidationStatus.error((String)(String.valueOf(txtLocalTemplateFileName.getText()) + " is not a file")))).in(dbc);
        Button btnBrowseFiles = new Button(parent, 0);
        btnBrowseFiles.setText("File system...");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).hint(100, -1).applyTo((Control)btnBrowseFiles);
        btnBrowseFiles.addSelectionListener((SelectionListener)this.onFileSystemBrowseClicked());
        Button btnBrowseWorkspaceFiles = new Button(parent, 0);
        btnBrowseWorkspaceFiles.setText("Workspace...");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).hint(100, -1).applyTo((Control)btnBrowseWorkspaceFiles);
        btnBrowseWorkspaceFiles.addSelectionListener(this.onBrowseWorkspaceClicked());
        localTemplatesTab.setControl((Control)parent);
        return localTemplateFilename;
    }

    private SelectionListener onBrowseWorkspaceClicked() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog dialog = this.createFileDialog(TemplateListPage.this.model.getLocalTemplateFileName());
                if (dialog.open() == 0 && dialog.getFirstResult() instanceof IFile) {
                    String path = ((IFile)dialog.getFirstResult()).getFullPath().toPortableString();
                    String file = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", path);
                    TemplateListPage.this.setLocalTemplate(file);
                }
            }

            private ElementTreeSelectionDialog createFileDialog(String selectedFile) {
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(TemplateListPage.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle("Select an OpenShift template");
                dialog.setMessage("Select an OpenShift template (*.json)");
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.addFilter(new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        return element instanceof IContainer || element instanceof IFile && ((IFile)element).getFileExtension().equals("json");
                    }
                });
                dialog.setAllowMultiple(false);
                IProject res = TemplateListPage.this.model.getEclipseProject();
                if (StringUtils.isNotBlank((String)selectedFile)) {
                    String prefix = "${workspace_loc:";
                    String path = selectedFile;
                    if (selectedFile.startsWith(prefix) && selectedFile.endsWith("}")) {
                        path = path.substring(prefix.length(), path.length() - 1);
                    }
                    res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                }
                if (res != null) {
                    dialog.setInitialSelection((Object)res);
                }
                return dialog;
            }
        };
    }

    private void setLocalTemplate(String file) {
        if (file == null || !this.isFile(file)) {
            return;
        }
        try {
            this.model.setLocalTemplateFileName(file);
            return;
        }
        catch (ClassCastException ex) {
            IStatus status = ValidationStatus.error((String)ex.getMessage(), (Throwable)ex);
            OpenShiftUIActivator.getDefault().getLogger().logStatus(status);
            ErrorDialog.openError((Shell)this.getShell(), (String)"Template Error", (String)NLS.bind((String)"The file \"{0}\" is not an OpenShift template.", (Object)file), (IStatus)status);
        }
        catch (UnsupportedVersionException ex) {
            IStatus status = ValidationStatus.error((String)ex.getMessage(), (Throwable)ex);
            OpenShiftUIActivator.getDefault().getLogger().logStatus(status);
            ErrorDialog.openError((Shell)this.getShell(), (String)"Template Error", (String)NLS.bind((String)"The file \"{0}\" is a template in a version that we do not support.", (Object)file), (IStatus)status);
        }
        catch (OpenShiftException ex) {
            IStatus status = ValidationStatus.error((String)ex.getMessage(), (Throwable)ex);
            OpenShiftUIActivator.getDefault().getLogger().logStatus(status);
            ErrorDialog.openError((Shell)this.getShell(), (String)"Template Error", (String)NLS.bind((String)"Unable to read and/or parse the file \"{0}\" as a template.", (Object)file), (IStatus)status);
        }
    }

    private boolean isFile(String path) {
        return StringUtils.isNotBlank((String)path) && Files.isRegularFile(Paths.get(this.substituteVariables(path), new String[0]), new LinkOption[0]);
    }

    private IObservableValue createServerTemplateControls(TabFolder tabFolder, IObservableValue uploadTemplate, DataBindingContext dbc) {
        TabItem serverTemplatesTab = new TabItem(tabFolder, 0);
        serverTemplatesTab.setText("Server templates");
        Composite parent = new Composite((Composite)tabFolder, 0);
        GridLayoutFactory.fillDefaults().margins(10, 6).spacing(2, 2).applyTo(parent);
        serverTemplatesTab.setControl((Control)parent);
        final Text txtTemplateFilter = UIUtils.createSearchText((Composite)parent);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)txtTemplateFilter);
        IObservableValue eclipseProjectObservable = BeanProperties.value((String)"eclipseProject").observe((Object)this.model);
        eclipseProjectObservable.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                TemplateListPage.this.filterTemplates(txtTemplateFilter, (IProject)event.getObservableValue().getValue());
            }
        });
        this.filterTemplates(txtTemplateFilter, this.model.getEclipseProject());
        this.templatesViewer = this.createServerTemplatesViewer(parent, txtTemplateFilter);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(400, 180).applyTo(this.templatesViewer.getControl());
        IViewerObservableValue selectedViewerServerTemplate = ViewerProperties.singleSelection().observe((Viewer)this.templatesViewer);
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)selectedViewerServerTemplate).converting((IConverter)new ObservableTreeItem2ModelConverter(ITemplate.class))).to(BeanProperties.value((String)"serverTemplate").observe((Object)this.model)).converting((IConverter)new Model2ObservableTreeItemConverter(TemplateTreeItems.INSTANCE))).in(dbc);
        this.templatesViewer.addDoubleClickListener(this.onServerTemplateDoubleClicked());
        txtTemplateFilter.addModifyListener(this.onFilterTextTyped(this.templatesViewer));
        return selectedViewerServerTemplate;
    }

    protected String findMatchingTags(IProject project) {
        return new ProjectBuilderTypeDetector().findTemplateFilter(project);
    }

    private void createDetailsGroup(Composite parent, DataBindingContext dbc) {
        Group detailsGroup = new Group(parent, 0);
        detailsGroup.setText("Template details");
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).span(3, 1).hint(-1, 106).applyTo((Control)detailsGroup);
        GridLayoutFactory.fillDefaults().margins(10, 6).spacing(2, 2).applyTo((Composite)detailsGroup);
        Composite detailsContainer = new Composite((Composite)detailsGroup, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)detailsContainer);
        new TemplateDetailViews(BeanProperties.value((String)"selectedTemplate").observe((Object)this.model), null, detailsContainer, dbc).createControls();
        Button btnDetails = new Button((Composite)detailsGroup, 0);
        btnDetails.setText("Defined Resources...");
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)btnDetails);
        IObservableValue selectedTemplate = BeanProperties.value((String)"selectedTemplate").observe((Object)this.model);
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)btnDetails)).notUpdatingParticipant()).to(selectedTemplate).converting((IConverter)new IsNotNull2BooleanConverter())).in(dbc);
        btnDetails.addSelectionListener((SelectionListener)this.onDefinedResourcesClicked());
    }

    private IDoubleClickListener onServerTemplateDoubleClicked() {
        return new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (TemplateListPage.hasTemplate(selection.getFirstElement()) && TemplateListPage.this.canFlipToNextPage()) {
                    TemplateListPage.this.getContainer().showPage(TemplateListPage.this.getNextPage());
                }
            }
        };
    }

    private TreeViewer createServerTemplatesViewer(Composite parent, Text templateFilterText) {
        TreeViewer viewer = new TreeViewer(parent, 2820);
        MultiListProperty childrenProperty = new MultiListProperty(new IListProperty[]{BeanProperties.list((String)"templates"), BeanProperties.list((String)"children")});
        ObservableListTreeContentProvider contentProvider = new ObservableListTreeContentProvider(childrenProperty.listFactory(), null);
        viewer.setContentProvider((IContentProvider)contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)new ObservableTreeItemStyledCellLabelProvider());
        viewer.setAutoExpandLevel(-1);
        viewer.setComparator((ViewerComparator)new TemplateComparator());
        viewer.addFilter((ViewerFilter)new TemplateViewerFilter(templateFilterText));
        viewer.setInput((Object)this.model);
        return viewer;
    }

    private SelectionAdapter onFileSystemBrowseClicked() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = this.createFileDialog(TemplateListPage.this.model.getLocalTemplateFileName());
                String file = dialog.open();
                TemplateListPage.this.setLocalTemplate(file);
            }

            private FileDialog createFileDialog(String selectedFile) {
                FileDialog dialog = new FileDialog(TemplateListPage.this.getShell(), 4096);
                dialog.setText("Select an OpenShift template");
                if (TemplateListPage.this.isFile(selectedFile)) {
                    File file = new File(selectedFile);
                    dialog.setFilterPath(file.getParentFile().getAbsolutePath());
                }
                return dialog;
            }
        };
    }

    private SelectionAdapter onDefinedResourcesClicked() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ITemplate template = TemplateListPage.this.model.getSelectedTemplate();
                new ResourceSummaryDialog(TemplateListPage.this.getShell(), template.getItems(), "Template Details", NLS.bind((String)"The following resources will be created by using template\n\"{0}\":", (Object)template.getName()), new ResourceDetailsLabelProvider(), new ResourceDetailsContentProvider()).open();
            }
        };
    }

    private ModifyListener onFilterTextTyped(final TreeViewer viewer) {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                viewer.refresh();
                viewer.expandAll();
            }
        };
    }

    private IValueChangeListener onConnectionChanged() {
        return new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                TemplateListPage.this.loadResources(TemplateListPage.this.templatesViewer, TemplateListPage.this.model);
                TemplateListPage.this.templatesViewer.expandAll();
            }
        };
    }

    private void loadResources(final TreeViewer templatesViewer, final ITemplateListPageModel model) {
        if (!model.hasConnection()) {
            return;
        }
        try {
            Job jobs = new JobChainBuilder((Job)new AbstractDelegatingMonitorJob("Loading projects, templates..."){

                protected IStatus doRun(IProgressMonitor monitor) {
                    model.loadResources();
                    return Status.OK_STATUS;
                }
            }).runWhenSuccessfullyDone((Job)new UIJob("Verifying required project..."){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (!model.hasProjects()) {
                        List<com.openshift.restclient.model.IProject> projects = new ObservableTreeItem2ModelConverter().convert(model.getProjectItems());
                        Connection connection = (Connection)model.getConnection();
                        NewProjectWizard newProjectWizard = new NewProjectWizard(connection, projects);
                        if (1 == WizardUtils.openWizardDialog((IWizard)newProjectWizard, (Shell)TemplateListPage.this.getShell())) {
                            WizardUtils.close((IWizard)TemplateListPage.this.getWizard());
                            return Status.CANCEL_STATUS;
                        }
                        model.loadResources();
                        model.setProject(newProjectWizard.getProject());
                    }
                    return Status.OK_STATUS;
                }
            }).runWhenSuccessfullyDone((Job)new UIJob("Expanding resource tree..."){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    templatesViewer.expandAll();
                    return Status.OK_STATUS;
                }
            }).build();
            WizardUtils.runInWizard((Job)jobs, (IWizardContainer)this.getContainer());
        }
        catch (InterruptedException | InvocationTargetException exception) {}
    }

    protected void onPageActivated(DataBindingContext dbc) {
        this.loadResources(this.templatesViewer, this.model);
        ((Composite)this.getControl()).layout(true, true);
    }

    private static boolean hasTemplate(Object item) {
        return item instanceof ITemplate || item instanceof ObservableTreeItem && ((ObservableTreeItem)((Object)item)).getModel() instanceof ITemplate;
    }

    private IStatus getGitDirtyStatus(IProject project) {
        try {
            if (EGitUtils.isDirty((IProject)project, (boolean)false, (IProgressMonitor)new NullProgressMonitor())) {
                return ValidationStatus.error((String)NLS.bind((String)"The project {0} has uncommitted changes. Please commit those changes first.", (Object)project.getName()));
            }
            return ValidationStatus.ok();
        }
        catch (IOException | GitAPIException | NoWorkTreeException throwable) {
            return ValidationStatus.error((String)NLS.bind((String)"The git repository for project {0} looks corrupt. Please fix it before using it.", (Object)project.getName()));
        }
    }

    private void filterTemplates(Text text, IProject project) {
        String tags = this.findMatchingTags(project);
        if (tags != null && !text.isDisposed()) {
            text.setText(tags);
        }
    }

    private void toggleEgitLink(Link gitLabel, IProject p) {
        if (gitLabel.isDisposed()) {
            return;
        }
        boolean showLink = p != null && !EGitUtils.isSharedWithGit((IProject)p);
        UIUtils.setVisibleAndExclude((boolean)showLink, (Control)gitLabel);
    }

    private String substituteVariables(String string) {
        try {
            return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(string);
        }
        catch (CoreException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static class TemplateComparator
    extends ViewerComparator {
        public int compare(Viewer viewer, Object e1, Object e2) {
            if (TemplateListPage.hasTemplate(e1) && TemplateListPage.hasTemplate(e2)) {
                String t1 = ((ITemplate)((ObservableTreeItem)((Object)e1)).getModel()).getName();
                String t2 = ((ITemplate)((ObservableTreeItem)((Object)e2)).getModel()).getName();
                return t1.compareTo(t2);
            }
            return super.compare(viewer, e1, e2);
        }
    }

    private class TemplateListPageValidator
    extends MultiValidator {
        private IObservableValue useLocalTemplate;
        private IObservableValue localTemplateFilename;
        private IObservableValue serverTemplate;
        private IObservableValue selectedTemplate;
        private IObservableValue projectNameObservable;
        private IObservableList mutableTargets = new WritableList();
        private Composite composite;

        public TemplateListPageValidator(IObservableValue useLocalTemplate, IObservableValue localTemplateFilename, IObservableValue serverTemplate, IObservableValue selectedTemplate, IObservableValue projectNameObservable, Composite composite) {
            this.useLocalTemplate = useLocalTemplate;
            useLocalTemplate.getValue();
            this.localTemplateFilename = localTemplateFilename;
            this.serverTemplate = serverTemplate;
            this.selectedTemplate = selectedTemplate;
            this.projectNameObservable = projectNameObservable;
            this.composite = composite;
        }

        protected IStatus validate() {
            IStatus status;
            block19: {
                status = ValidationStatus.ok();
                this.mutableTargets.clear();
                String projectName = (String)this.projectNameObservable.getValue();
                if (!StringUtils.isEmpty((String)projectName)) {
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                    if (!ProjectUtils.exists((IProject)project)) {
                        status = ValidationStatus.error((String)NLS.bind((String)"The project {0} does not exist in your workspace.", (Object)projectName));
                    } else if (!ProjectUtils.isAccessible((IProject)project)) {
                        status = ValidationStatus.error((String)NLS.bind((String)"The project {0} is not open.", (Object)projectName));
                    } else if (EGitUtils.isSharedWithGit((IProject)project)) {
                        try {
                            List repos = EGitUtils.getRemoteGitRepos((IProject)project);
                            if (repos == null || repos.isEmpty()) {
                                status = ValidationStatus.error((String)NLS.bind((String)"A remote Git repository using the HTTP(S) protocol must be defined on project {0}", (Object)projectName));
                                break block19;
                            }
                            status = TemplateListPage.this.getGitDirtyStatus(project);
                        }
                        catch (CoreException e) {
                            status = ValidationStatus.error((String)NLS.bind((String)"Can not read Git config on project {0} : {1}", (Object)projectName, (Object)e.getMessage()));
                        }
                    } else {
                        status = ValidationStatus.error((String)NLS.bind((String)"The project {0} is not shared with Git.", (Object)projectName));
                    }
                }
            }
            if (!status.isOK()) {
                this.mutableTargets.add((Object)this.projectNameObservable);
            } else if (Boolean.TRUE.equals(this.useLocalTemplate.getValue())) {
                String localTemplate = (String)this.localTemplateFilename.getValue();
                if (StringUtils.isNotEmpty((String)localTemplate)) {
                    if (!TemplateListPage.this.isFile(localTemplate)) {
                        status = ValidationStatus.error((String)NLS.bind((String)"{0} is not a valid file.", (Object)localTemplate));
                        this.mutableTargets.add((Object)this.localTemplateFilename);
                    }
                } else if (this.selectedTemplate.getValue() == null) {
                    status = ValidationStatus.cancel((String)"Please select a local template file.");
                    this.mutableTargets.add((Object)this.localTemplateFilename);
                }
            } else if (this.selectedTemplate.getValue() == null) {
                status = ValidationStatus.cancel((String)"Please select a server template.");
                this.mutableTargets.add((Object)this.serverTemplate);
            }
            this.composite.redraw();
            return status;
        }

        public IObservableList getTargets() {
            return this.mutableTargets;
        }
    }

    private static class TemplateViewerFilter
    extends ViewerFilter {
        private Text filterText;

        public TemplateViewerFilter(Text filterText) {
            this.filterText = filterText;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (!(element instanceof ObservableTreeItem) || !(((ObservableTreeItem)((Object)element)).getModel() instanceof ITemplate)) {
                return true;
            }
            ITemplate template = (ITemplate)((ObservableTreeItem)((Object)element)).getModel();
            return ResourceUtils.isMatching((String)this.filterText.getText(), (IResource)template);
        }
    }
}

