/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.importapp.operation;

import com.openshift.restclient.OpenShiftException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.op.CloneOperation;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.egit.core.EGitUtils;
import org.jboss.tools.openshift.egit.ui.util.EGitUIUtils;
import org.jboss.tools.openshift.internal.common.ui.application.importoperation.GeneralProjectImportOperation;
import org.jboss.tools.openshift.internal.common.ui.application.importoperation.MavenProjectImportOperation;
import org.jboss.tools.openshift.internal.common.ui.application.importoperation.WontOverwriteException;

public class ImportNewProject {
    private static final String PLATFORM_SEPARATOR = Matcher.quoteReplacement(File.separator);
    private File cloneDestination;
    private String gitUrl;
    private String gitRef;
    private Collection<String> filters;

    public ImportNewProject(String gitUrl, String gitRef, File cloneDestination, Collection<String> filters) {
        this.gitUrl = gitUrl;
        this.gitRef = gitRef;
        this.cloneDestination = cloneDestination;
        this.filters = ImportNewProject.sanitize(filters);
    }

    public void execute(IProgressMonitor monitor) throws OpenShiftException, CoreException, InterruptedException, URISyntaxException, InvocationTargetException, IOException, NoWorkTreeException, GitAPIException {
        if (this.cloneDestinationExists()) {
            throw new WontOverwriteException(NLS.bind((String)"There's already a folder at {0}. The new OpenShift project would overwrite it. Please choose another destination to clone to.", (Object)this.getCloneDestination().getAbsolutePath()), new Object[0]);
        }
        File repositoryFolder = this.cloneRepository(this.gitUrl, this.cloneDestination, this.gitRef, monitor);
        List<IProject> importedProjects = this.importProjectsFrom(repositoryFolder, this.filters, monitor);
        this.connectToGitRepo(importedProjects, repositoryFolder, monitor);
    }

    private List<IProject> importProjectsFrom(File folder, Collection<String> filters, IProgressMonitor monitor) throws CoreException, InterruptedException {
        MavenProjectImportOperation mavenImport = new MavenProjectImportOperation(folder);
        mavenImport.setFilters(filters);
        List importedProjects = mavenImport.isMavenProject() ? mavenImport.importToWorkspace(monitor) : new GeneralProjectImportOperation(folder).importToWorkspace(monitor);
        return importedProjects;
    }

    private void connectToGitRepo(List<IProject> projects, File projectFolder, IProgressMonitor monitor) throws CoreException {
        for (IProject project : projects) {
            if (project == null) continue;
            EGitUtils.connect((IProject)project, (IProgressMonitor)monitor);
        }
    }

    protected File cloneRepository(String gitUrl, File destination, String gitRef, IProgressMonitor monitor) throws OpenShiftException, InvocationTargetException, InterruptedException, URISyntaxException {
        monitor.subTask(NLS.bind((String)"Cloning  {0}...", (Object)gitUrl));
        EGitUIUtils.ensureEgitUIIsStarted();
        EGitUtils.cloneRepository((String)gitUrl, (String)"origin", (String)gitRef, (File)destination, (CloneOperation.PostCloneTask)EGitUIUtils.ADD_TO_REPOVIEW_TASK, (IProgressMonitor)monitor);
        return destination;
    }

    protected File getCloneDestination() {
        return this.cloneDestination;
    }

    protected boolean cloneDestinationExists() {
        return this.cloneDestination != null && this.cloneDestination.exists();
    }

    private static Collection<String> sanitize(Collection<String> filters) {
        LinkedHashSet<String> sanitized = null;
        if (filters != null) {
            sanitized = new LinkedHashSet<String>(filters.size());
            for (String path : filters) {
                if (!StringUtils.isNotBlank((String)path)) continue;
                sanitized.add(ImportNewProject.makePlatformDependent(path));
            }
        }
        return sanitized;
    }

    private static String makePlatformDependent(String path) {
        return path.replaceAll("/", PLATFORM_SEPARATOR).replaceAll("\\\\", PLATFORM_SEPARATOR);
    }
}

