/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.importapp;

import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.jboss.tools.common.ui.DelegatingProgressMonitor;
import org.jboss.tools.common.ui.JobUtils;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.internal.common.core.UsageStats;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.common.ui.wizard.IConnectionAwareWizard;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.explorer.ResourceGrouping;
import org.jboss.tools.openshift.internal.ui.wizard.importapp.BuildConfigWizardPage;
import org.jboss.tools.openshift.internal.ui.wizard.importapp.GitCloningWizardPage;
import org.jboss.tools.openshift.internal.ui.wizard.importapp.ImportApplicationWizardModel;
import org.jboss.tools.openshift.internal.ui.wizard.importapp.ImportJob;

public class ImportApplicationWizard
extends Wizard
implements IWorkbenchWizard,
IConnectionAwareWizard<Connection> {
    private ImportApplicationWizardModel model;

    public ImportApplicationWizard() {
        this.setWindowTitle("Import OpenShift Application");
        this.setNeedsProgressMonitor(true);
        this.model = new ImportApplicationWizardModel();
    }

    public ImportApplicationWizard(Map<IProject, Collection<IBuildConfig>> projectsAndBuildConfigs) {
        this();
        if (projectsAndBuildConfigs != null && projectsAndBuildConfigs.size() == 1) {
            Map.Entry<IProject, Collection<IBuildConfig>> entry = projectsAndBuildConfigs.entrySet().iterator().next();
            IProject project = entry.getKey();
            Connection connection = ConnectionsRegistryUtil.safeGetConnectionFor((IResource)project);
            this.setModelConnection(connection);
            Collection<IBuildConfig> buildConfigs = entry.getValue();
            if (buildConfigs.size() == 1) {
                this.model.setSelectedItem(buildConfigs.iterator().next());
            } else {
                this.model.setSelectedItem(project);
            }
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (this.model.getConnection() != null && this.model.getSelectedItem() != null) {
            return;
        }
        Connection connection = (Connection)UIUtils.getFirstElement((ISelection)selection, Connection.class);
        if (connection != null) {
            this.model.setConnection(connection);
        } else {
            IResource resource = (IResource)UIUtils.getFirstElement((ISelection)selection, IResource.class);
            if (resource != null) {
                this.setModelConnection(ConnectionsRegistryUtil.safeGetConnectionFor((IResource)resource));
                this.model.setSelectedItem(resource);
            } else {
                IProject project = (IProject)UIUtils.getFirstElement((ISelection)selection, IProject.class);
                if (project != null) {
                    this.setModelConnection(ConnectionsRegistryUtil.safeGetConnectionFor((IResource)project));
                    this.model.setSelectedItem(project);
                } else {
                    ResourceGrouping grouping = (ResourceGrouping)UIUtils.getFirstElement((ISelection)selection, ResourceGrouping.class);
                    if (grouping != null) {
                        this.setModelConnection(ConnectionsRegistryUtil.safeGetConnectionFor((IResource)grouping.getProject()));
                        this.model.setSelectedItem(grouping.getProject());
                    }
                }
            }
        }
    }

    public void addPages() {
        if (this.model.getSelectedBuildConfig() == null) {
            this.addPage((IWizardPage)new BuildConfigWizardPage((IWizard)this, this.model));
        }
        this.addPage((IWizardPage)new GitCloningWizardPage((IWizard)this, this.model));
    }

    public boolean performFinish() {
        boolean success = this.importProject();
        UsageStats.getInstance().importV3Application(this.model.getConnection().getHost(), success);
        return success;
    }

    private boolean importProject() {
        try {
            DelegatingProgressMonitor delegatingMonitor = new DelegatingProgressMonitor();
            ImportJob importJob = new ImportJob(this.model.getGitUrl(), this.model.getCloneDestination(), (org.jboss.tools.foundation.core.jobs.DelegatingProgressMonitor)delegatingMonitor).setGitRef(this.model.getGitRef());
            String gitContextDir = this.model.getGitContextDir();
            if (!StringUtils.isEmptyOrNull((String)gitContextDir)) {
                importJob.setFilters(Collections.singleton(gitContextDir));
            }
            IStatus jobResult = WizardUtils.runInWizard((Job)importJob, (org.jboss.tools.foundation.core.jobs.DelegatingProgressMonitor)delegatingMonitor, (IWizardContainer)this.getContainer());
            return JobUtils.isOk((IStatus)jobResult);
        }
        catch (Exception e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Could not create local git repository.", (IStatus)OpenShiftUIActivator.statusFactory().errorStatus("An exception occurred while creating local git repository.", (Throwable)e));
            return false;
        }
    }

    public Connection getConnection() {
        return this.model.getConnection();
    }

    public boolean hasConnection() {
        return this.model.hasConnection();
    }

    public void setConnection(Connection connection) {
        this.model.setConnection(connection);
    }

    public Object getContext() {
        return null;
    }

    private void setModelConnection(Connection connection) {
        if (connection != null) {
            this.model.setConnection(connection);
        }
    }
}

