/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.deployimage;

import com.openshift.restclient.model.IServicePort;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.internal.common.ui.databinding.IsNotNull2BooleanConverter;
import org.jboss.tools.openshift.internal.common.ui.utils.TableViewerBuilder;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.IServiceAndRoutingPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.ServicePortAdapter;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.ServicePortDialog;

public class ServicesAndRoutingPage
extends AbstractOpenShiftWizardPage {
    private static final String PAGE_NAME = "Services && Routing Settings Page";
    private static final String PAGE_TITLE = "Services && Routing Settings";
    private static final String PAGE_DESCRIPTION = "";
    private IServiceAndRoutingPageModel model;
    TableViewer portsViewer;

    protected ServicesAndRoutingPage(IWizard wizard, IServiceAndRoutingPageModel model) {
        super(PAGE_TITLE, PAGE_DESCRIPTION, PAGE_NAME, wizard);
        this.model = model;
    }

    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo(parent);
        this.createExposedPortsControl(parent, dbc);
        Composite routingContainer = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)routingContainer);
        GridLayoutFactory.fillDefaults().margins(6, 6).numColumns(2).applyTo(routingContainer);
        Button btnAddRoute = new Button(routingContainer, 32);
        btnAddRoute.setText("Add Route");
        btnAddRoute.setToolTipText("Adding a route to the service will make the image accessible\noutside of the OpenShift cluster.");
        GridDataFactory.fillDefaults().align(4, 4).grab(false, false).applyTo((Control)btnAddRoute);
        ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)btnAddRoute)).to(BeanProperties.value((String)"addRoute").observe((Object)this.model)).in(dbc);
    }

    private void createExposedPortsControl(Composite parent, DataBindingContext dbc) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(6, 6).applyTo(container);
        Label label = new Label(container, 0);
        label.setText("Service Ports:");
        label.setToolTipText("The exposed ports of the image.");
        GridDataFactory.fillDefaults().align(4, 4).span(2, 1).applyTo((Control)label);
        Composite tableContainer = new Composite(container, 0);
        this.portsViewer = this.createTable(tableContainer);
        GridDataFactory.fillDefaults().span(1, 5).align(4, 4).grab(true, true).applyTo((Control)tableContainer);
        ValueBindingBuilder.bind((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)this.portsViewer)).to(BeanProperties.value((String)"selectedServicePort").observe((Object)this.model)).in(dbc);
        this.portsViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.portsViewer.setInput((Object)BeanProperties.list((String)"servicePorts").observe((Object)this.model));
        Button btnAdd = new Button(container, 8);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)btnAdd);
        btnAdd.setText("Add...");
        btnAdd.setToolTipText("Add a port to be exposed by the service which is not explicilty declared by the image.");
        btnAdd.addSelectionListener(this.onAdd());
        Button btnEdit = new Button(container, 8);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)btnEdit);
        btnEdit.setText("Edit...");
        btnEdit.setToolTipText("Edit a port to be exposed by the service.");
        btnEdit.addSelectionListener((SelectionListener)new EditHandler());
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)btnEdit)).notUpdatingParticipant()).to(BeanProperties.value((String)"selectedServicePort").observe((Object)this.model)).converting((IConverter)new IsNotNull2BooleanConverter())).in(dbc);
        Button removeButton = new Button(container, 8);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)removeButton);
        removeButton.setText("Remove...");
        removeButton.setToolTipText("Remove a port that will be exposed by the service.");
        removeButton.addSelectionListener(this.onRemove());
        ((ValueBindingBuilder.ModelDefinition)((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.enabled().observe((Widget)removeButton)).notUpdatingParticipant()).to(BeanProperties.value((String)"selectedServicePort").observe((Object)this.model)).converting((IConverter)new IsNotNull2BooleanConverter())).in(dbc);
        Button btnReset = new Button(container, 8);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)btnReset);
        btnReset.setText("Reset");
        btnReset.setToolTipText("Resets the list of ports to the exposed ports of the image.");
        btnReset.addSelectionListener(this.onReset());
    }

    private SelectionListener onAdd() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String message = "Add a port to be exposed by the service";
                ServicePortAdapter port = new ServicePortAdapter();
                port.setPort(Collections.max(ServicesAndRoutingPage.this.model.getServicePorts(), new Comparator<IServicePort>(){

                    @Override
                    public int compare(IServicePort first, IServicePort second) {
                        return Integer.compare(first.getPort(), second.getPort());
                    }
                }).getPort() + 1);
                port.setTargetPort(Collections.max(ServicesAndRoutingPage.this.model.getServicePorts(), new Comparator<IServicePort>(){

                    @Override
                    public int compare(IServicePort first, IServicePort second) {
                        return Integer.compare(first.getTargetPort(), second.getTargetPort());
                    }
                }).getPort() + 1);
                ServicePortDialog dialog = new ServicePortDialog(port, message, ServicesAndRoutingPage.this.model.getServicePorts());
                if (dialog.open() == 0) {
                    port.setName(NLS.bind((String)"{0}-tcp", (Object)port.getPort()));
                    ServicesAndRoutingPage.this.model.addServicePort(port);
                }
            }
        };
    }

    protected TableViewer createTable(Composite tableContainer) {
        Table table = new Table(tableContainer, 68352);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableViewer viewer = new TableViewerBuilder(table, tableContainer).contentProvider((IStructuredContentProvider)new ArrayContentProvider()).column((TableViewerBuilder.IColumnLabelProvider)new TableViewerBuilder.IColumnLabelProvider<IServicePort>(){

            public String getValue(IServicePort port) {
                return port.getName();
            }
        }).name("Name").align(16384).weight(2).minWidth(50).buildColumn().column((TableViewerBuilder.IColumnLabelProvider)new TableViewerBuilder.IColumnLabelProvider<IServicePort>(){

            public String getValue(IServicePort port) {
                return ServicesAndRoutingPage.PAGE_DESCRIPTION + port.getPort();
            }
        }).name("Service Port").align(16384).weight(1).minWidth(25).buildColumn().column((TableViewerBuilder.IColumnLabelProvider)new TableViewerBuilder.IColumnLabelProvider<IServicePort>(){

            public String getValue(IServicePort port) {
                return ServicesAndRoutingPage.PAGE_DESCRIPTION + port.getTargetPort();
            }
        }).name("Pod Port").align(16384).weight(1).minWidth(25).buildColumn().buildViewer();
        viewer.addDoubleClickListener((IDoubleClickListener)new EditHandler());
        return viewer;
    }

    private SelectionListener onRemove() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IServicePort port = (IServicePort)UIUtils.getFirstElement((ISelection)ServicesAndRoutingPage.this.portsViewer.getSelection(), IServicePort.class);
                if (MessageDialog.openQuestion((Shell)ServicesAndRoutingPage.this.getShell(), (String)"Remove port", (String)NLS.bind((String)"Are you sure you want to delete the port {0}?", (Object)port.getPort()))) {
                    ServicesAndRoutingPage.this.model.removeServicePort(port);
                    ServicesAndRoutingPage.this.portsViewer.refresh();
                }
            }
        };
    }

    private SelectionListener onReset() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openQuestion((Shell)ServicesAndRoutingPage.this.getShell(), (String)"Reset ports", (String)"Are you sure you want to reset the serviced ports to those exposed by the image?")) {
                    ServicesAndRoutingPage.this.model.resetServicePorts();
                    ServicesAndRoutingPage.this.portsViewer.refresh();
                }
            }
        };
    }

    class EditHandler
    extends SelectionAdapter
    implements IDoubleClickListener {
        EditHandler() {
        }

        public void doubleClick(DoubleClickEvent event) {
            this.handleEvent();
        }

        public void widgetSelected(SelectionEvent e) {
            this.handleEvent();
        }

        public void handleEvent() {
            String message = "Edit the port to be exposed by the service";
            IServicePort port = ServicesAndRoutingPage.this.model.getSelectedServicePort();
            ServicePortAdapter target = new ServicePortAdapter(port);
            ServicePortDialog dialog = new ServicePortDialog(target, message, ServicesAndRoutingPage.this.model.getServicePorts());
            if (dialog.open() == 0) {
                target.setName(NLS.bind((String)"{0}-tcp", (Object)target.getPort()));
                ServicesAndRoutingPage.this.model.updateServicePort(port, target);
                ServicesAndRoutingPage.this.model.setSelectedServicePort(target);
            }
        }
    }
}

