/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.deployimage;

import com.openshift.restclient.model.IServicePort;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.common.ui.wizard.OkCancelButtonWizardDialog;

public class ServicePortDialog
extends AbstractOpenShiftWizardPage {
    static final String PROPERTY_SERVICE_PORT = "port";
    static final String PROPERTY_POD_PORT = "targetPort";
    private IServicePort model;
    private List<IServicePort> ports;
    private final int servicePort;
    private final int podPort;

    public ServicePortDialog(IServicePort model, String message, List<IServicePort> ports) {
        super("Configure Service Ports", message, "", null);
        this.model = model;
        this.ports = ports;
        this.servicePort = model.getPort();
        this.podPort = model.getTargetPort();
    }

    protected void doCreateControls(Composite parent, DataBindingContext dbc) {
        GridLayoutFactory.fillDefaults().margins(1, 1).applyTo(parent);
        Composite dialogArea = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)dialogArea);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(25, 25).applyTo(dialogArea);
        Label lblServicePort = new Label(dialogArea, 0);
        lblServicePort.setText("Service port:");
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)lblServicePort);
        final Spinner servicePortSpinner = new Spinner(dialogArea, 2048);
        servicePortSpinner.setMinimum(1);
        servicePortSpinner.setMaximum(65535);
        servicePortSpinner.setToolTipText("The port exposed by the service that will route to the pod.");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)servicePortSpinner);
        Binding servicePortBinding = ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)servicePortSpinner)).validatingAfterConvert((IValidator)new ServicePortValidator())).to(BeanProperties.value((String)PROPERTY_SERVICE_PORT).observe((Object)this.model)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)servicePortBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        new Label(dialogArea, 0);
        Label lblPodPort = new Label(dialogArea, 0);
        lblPodPort.setText("Pod port:");
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)lblPodPort);
        final Spinner podPortSpinner = new Spinner(dialogArea, 2048);
        podPortSpinner.setMinimum(1);
        podPortSpinner.setMaximum(65535);
        podPortSpinner.setToolTipText("The port exposed by the pod which will accept traffic");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)podPortSpinner);
        Binding podPortBinding = ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.selection().observe((Widget)podPortSpinner)).validatingAfterConvert((IValidator)new PodPortValidator())).to(BeanProperties.value((String)PROPERTY_POD_PORT).observe((Object)this.model)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)podPortBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater());
        servicePortSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                podPortSpinner.setSelection(servicePortSpinner.getSelection());
            }
        });
        Label lbl = new Label(dialogArea, 0);
        lbl.setText("Pod port is linked to service port changes");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)lbl);
    }

    public int open() {
        ServicePortDialog page = this;
        Wizard wizard = new Wizard((IWizardPage)page){
            private final /* synthetic */ IWizardPage val$page;
            {
                this.val$page = iWizardPage;
            }

            public boolean performFinish() {
                return true;
            }

            public void addPages() {
                this.addPage(this.val$page);
            }
        };
        wizard.setNeedsProgressMonitor(true);
        wizard.setWindowTitle("Service Ports");
        this.setWizard((IWizard)wizard);
        OkCancelButtonWizardDialog dialog = new OkCancelButtonWizardDialog(this.getShell(), (IWizard)wizard);
        return dialog.open();
    }

    class PodPortValidator
    implements IValidator {
        PodPortValidator() {
        }

        public IStatus validate(Object value) {
            Integer newPort = (Integer)value;
            if (newPort != ServicePortDialog.this.podPort) {
                for (IServicePort port : ServicePortDialog.this.ports) {
                    if (newPort.intValue() != port.getTargetPort()) continue;
                    return ValidationStatus.error((String)"The pod port number must be unique among all the other pod ports exposed by this OpenShift service.");
                }
            }
            return ValidationStatus.OK_STATUS;
        }
    }

    class ServicePortValidator
    implements IValidator {
        ServicePortValidator() {
        }

        public IStatus validate(Object value) {
            Integer newPort = (Integer)value;
            if (ServicePortDialog.this.servicePort != newPort) {
                for (IServicePort port : ServicePortDialog.this.ports) {
                    if (newPort.intValue() != port.getPort()) continue;
                    return ValidationStatus.error((String)"The service port number must be unique among all the other ports exposed by this OpenShift service.");
                }
            }
            return ValidationStatus.OK_STATUS;
        }
    }
}

