/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.deployimage;

import com.openshift.restclient.model.IPort;
import com.openshift.restclient.model.IServicePort;
import org.jboss.tools.common.databinding.ObservablePojo;

class ServicePortAdapter
extends ObservablePojo
implements IServicePort {
    private String name;
    private int port;
    private int containerPort;
    private String protocol;

    ServicePortAdapter(IPort port) {
        this.name = port.getName();
        this.port = port.getContainerPort();
        this.containerPort = port.getContainerPort();
        this.protocol = port.getProtocol();
    }

    ServicePortAdapter(IServicePort port) {
        this.name = port.getName();
        this.port = port.getPort();
        this.containerPort = port.getTargetPort() == 0 ? this.port : port.getTargetPort();
        this.protocol = port.getProtocol();
    }

    public ServicePortAdapter() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.firePropertyChange("name", this.name, this.name);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
        this.firePropertyChange("port", this.port, this.port);
    }

    public int getTargetPort() {
        return this.containerPort;
    }

    public void setTargetPort(int port) {
        this.containerPort = port;
        this.firePropertyChange("targetPort", this.containerPort, this.containerPort);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String proto) {
        this.protocol = proto;
        this.firePropertyChange("protocol", this.protocol, this.protocol);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.port;
        result = 31 * result + this.containerPort;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ServicePortAdapter other = (ServicePortAdapter)((Object)obj);
        if (this.port != other.port) {
            return false;
        }
        if (this.containerPort != other.containerPort) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.protocol == null ? other.protocol != null : !this.protocol.equals(other.protocol));
    }
}

