/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.deployimage;

import com.openshift.restclient.images.DockerImageURI;
import com.openshift.restclient.model.IPort;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IServicePort;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.linuxtools.docker.core.DockerConnectionManager;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainerConfig;
import org.eclipse.linuxtools.docker.core.IDockerImageInfo;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;
import org.jboss.tools.openshift.internal.common.ui.wizard.IKeyValueItem;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.wizard.common.EnvironmentVariable;
import org.jboss.tools.openshift.internal.ui.wizard.common.ResourceLabelsPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.IDeployImageParameters;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.PortSpecAdapter;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.ServicePortAdapter;

public class DeployImageWizardModel
extends ResourceLabelsPageModel
implements IDeployImageParameters {
    private static final int DEFAULT_REPLICA_COUNT = 1;
    private Connection connection;
    private IProject project;
    private String name;
    private String image;
    private Collection<IProject> projects = Collections.emptyList();
    private List<EnvironmentVariable> environmentVariables = Collections.emptyList();
    private Map<String, String> imageEnvVars = new HashMap<String, String>();
    private EnvironmentVariable selectedEnvironmentVariable = null;
    private List<String> volumes = Collections.emptyList();
    private String selectedVolume;
    private List<IPort> portSpecs = Collections.emptyList();
    private int replicas;
    private boolean addRoute = false;
    List<IServicePort> servicePorts = new ArrayList<IServicePort>();
    IServicePort selectedServicePort = null;
    private IDockerConnection dockerConnection;
    private boolean imageInfoInitialized;
    private ArrayList<IServicePort> imagePorts;
    private boolean originatedFromDockerExplorer;

    @Override
    public void setOriginatedFromDockerExplorer(boolean orig) {
        this.originatedFromDockerExplorer = orig;
    }

    @Override
    public boolean originatedFromDockerExplorer() {
        return this.originatedFromDockerExplorer;
    }

    @Override
    public List<IDockerConnection> getDockerConnections() {
        List<IDockerConnection> all = Arrays.asList(DockerConnectionManager.getInstance().getConnections());
        return all;
    }

    @Override
    public IDockerConnection getDockerConnection() {
        List<IDockerConnection> all;
        if (this.dockerConnection == null && (all = this.getDockerConnections()).size() == 1) {
            this.setDockerConnection(all.get(0));
        }
        return this.dockerConnection;
    }

    @Override
    public Collection<Connection> getConnections() {
        return ConnectionsRegistrySingleton.getInstance().getAll(Connection.class);
    }

    public Connection getConnection() {
        Collection<Connection> connections;
        if (this.connection == null && (connections = this.getConnections()).size() == 1) {
            this.setConnection(connections.iterator().next());
        }
        return this.connection;
    }

    public void initModel(final Connection connection, final IProject project) {
        this.connection = connection;
        this.firePropertyChange("connection", this.connection, this.connection);
        if (this.connection != null) {
            AbstractDelegatingMonitorJob job = new AbstractDelegatingMonitorJob("Loading projects..."){

                protected IStatus doRun(IProgressMonitor monitor) {
                    try {
                        List projects = connection.getResources("Project");
                        DeployImageWizardModel.this.setProjects(projects);
                        return Status.OK_STATUS;
                    }
                    catch (Exception e) {
                        return new Status(4, "org.jboss.tools.openshift.ui", "Unable to load the OpenShift projects for the selected connection.", (Throwable)e);
                    }
                }
            };
            if (project != null) {
                job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        DeployImageWizardModel.this.setProject(project);
                    }
                });
            }
            job.schedule();
        }
    }

    public void setConnection(Connection connection) {
        this.initModel(connection, null);
    }

    @Override
    public void setProjects(Collection<IProject> projects) {
        if (projects == null) {
            projects = Collections.emptyList();
        }
        this.projects = projects;
        this.firePropertyChange("projects", this.projects, this.projects);
        if (!projects.isEmpty() && !projects.contains(this.getProject())) {
            this.setProject(null);
        }
        if (projects.size() == 1) {
            this.setProject(projects.iterator().next());
        }
    }

    @Override
    public Collection<IProject> getProjects() {
        return this.projects;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public void setProject(IProject project) {
        this.project = project;
        this.firePropertyChange("project", this.project, this.project);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.firePropertyChange("name", this.name, this.name);
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public void setImage(String image) {
        if (StringUtils.isBlank((String)image)) {
            return;
        }
        this.image = image;
        this.firePropertyChange("image", this.image, this.image);
        DockerImageURI uri = new DockerImageURI(image);
        this.setName(uri.getName());
        this.resetImageInfo();
        this.initContainerInfo();
    }

    private void resetImageInfo() {
        this.setEnvironmentVariables(new ArrayList<EnvironmentVariable>());
        this.setVolumes(new ArrayList<String>());
        this.setPortSpecs(new ArrayList<IPort>());
        this.setReplicas(1);
        this.imageInfoInitialized = false;
    }

    @Override
    public List<EnvironmentVariable> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    private synchronized void initContainerInfo() {
        if (this.imageInfoInitialized || this.dockerConnection == null) {
            return;
        }
        IDockerImageInfo info = this.dockerConnection.getImageInfo(this.getImage());
        if (info == null) {
            return;
        }
        IDockerContainerConfig imageConfig = info.config();
        this.setEnvVars(imageConfig.env());
        ArrayList<IPort> portSpecs = new ArrayList<IPort>();
        Set specs = imageConfig.exposedPorts();
        for (String spec : specs) {
            try {
                portSpecs.add(new PortSpecAdapter(spec));
            }
            catch (IllegalArgumentException e) {
                OpenShiftUIActivator.getDefault().getLogger().logError((Throwable)e);
            }
        }
        this.setPortSpecs(portSpecs);
        this.setVolumes(new ArrayList<String>(imageConfig.volumes()));
        this.imageInfoInitialized = true;
    }

    private void setEnvVars(List<String> env) {
        ArrayList<EnvironmentVariable> envVars = new ArrayList<EnvironmentVariable>(env.size());
        for (String var : env) {
            String[] split = var.split("=");
            envVars.add(new EnvironmentVariable(split[0], split[1]));
        }
        this.setEnvironmentVariables(envVars);
    }

    @Override
    public void setEnvironmentVariables(List<EnvironmentVariable> envVars) {
        this.environmentVariables = envVars;
        this.firePropertyChange("environmentVariables", this.environmentVariables, this.environmentVariables);
        this.imageEnvVars.clear();
        for (IKeyValueItem iKeyValueItem : envVars) {
            this.imageEnvVars.put(iKeyValueItem.getKey(), iKeyValueItem.getValue());
        }
    }

    @Override
    public void setVolumes(List<String> volumes) {
        this.volumes = volumes;
        this.firePropertyChange("volumes", this.volumes, this.volumes);
    }

    @Override
    public List<String> getVolumes() {
        return this.volumes;
    }

    public void setPortSpecs(List<IPort> portSpecs) {
        this.portSpecs = portSpecs;
        this.firePropertyChange("portSpecs", this.portSpecs, this.portSpecs);
        this.setServicePortsFromPorts(portSpecs);
    }

    private void setServicePortsFromPorts(List<IPort> portSpecs) {
        this.imagePorts = new ArrayList(portSpecs.size());
        ArrayList<IServicePort> servicePorts = new ArrayList<IServicePort>(portSpecs.size());
        for (IPort port : portSpecs) {
            servicePorts.add(new ServicePortAdapter(port));
            this.imagePorts.add(new ServicePortAdapter(port));
        }
        this.setServicePorts(servicePorts);
    }

    private void setServicePorts(List<IServicePort> servicePorts) {
        this.servicePorts = servicePorts;
        this.firePropertyChange("servicePorts", this.servicePorts, this.servicePorts);
    }

    @Override
    public List<IPort> getPortSpecs() {
        return this.portSpecs;
    }

    @Override
    public int getReplicas() {
        return this.replicas;
    }

    @Override
    public void setReplicas(int replicas) {
        this.replicas = replicas;
        this.firePropertyChange("replicas", this.replicas, this.replicas);
    }

    public boolean hasConnection() {
        return this.connection != null;
    }

    public Object getContext() {
        return null;
    }

    @Override
    public boolean isAddRoute() {
        return this.addRoute;
    }

    @Override
    public void setAddRoute(boolean addRoute) {
        this.addRoute = addRoute;
        this.firePropertyChange("addRoute", this.addRoute, this.addRoute);
    }

    @Override
    public List<IServicePort> getServicePorts() {
        return this.servicePorts;
    }

    @Override
    public void setSelectedEnvironmentVariable(EnvironmentVariable envVar) {
        this.selectedEnvironmentVariable = envVar;
        this.firePropertyChange("selectedEnvironmentVariable", this.selectedEnvironmentVariable, this.selectedEnvironmentVariable);
    }

    @Override
    public EnvironmentVariable getSelectedEnvironmentVariable() {
        return this.selectedEnvironmentVariable;
    }

    @Override
    public void removeEnvironmentVariable(EnvironmentVariable envVar) {
        int i = this.environmentVariables.indexOf(envVar);
        if (i > -1) {
            ArrayList<EnvironmentVariable> old = new ArrayList<EnvironmentVariable>(this.environmentVariables);
            this.environmentVariables.remove(i);
            this.fireIndexedPropertyChange("environmentVariables", i, old, Collections.unmodifiableList(this.environmentVariables));
        }
    }

    @Override
    public void updateEnvironmentVariable(EnvironmentVariable envVar, String key, String value) {
        int i = this.environmentVariables.indexOf(envVar);
        if (i > -1) {
            ArrayList<EnvironmentVariable> old = new ArrayList<EnvironmentVariable>(this.environmentVariables);
            EnvironmentVariable prev = this.environmentVariables.get(i);
            this.environmentVariables.set(i, new EnvironmentVariable(key, value, prev.isNew()));
            this.fireIndexedPropertyChange("environmentVariables", i, old, Collections.unmodifiableList(this.environmentVariables));
        }
    }

    @Override
    public void resetEnvironmentVariable(EnvironmentVariable envVar) {
        if (this.imageEnvVars.containsKey(envVar.getKey())) {
            this.updateEnvironmentVariable(envVar, envVar.getKey(), this.imageEnvVars.get(envVar.getKey()));
        }
    }

    @Override
    public void addEnvironmentVariable(String key, String value) {
        ArrayList<EnvironmentVariable> old = new ArrayList<EnvironmentVariable>(this.environmentVariables);
        this.environmentVariables.add(new EnvironmentVariable(key, value, true));
        this.firePropertyChange("environmentVariables", old, Collections.unmodifiableList(this.environmentVariables));
    }

    @Override
    public void addServicePort(IServicePort port) {
        if (this.servicePorts.contains(port)) {
            return;
        }
        ArrayList<IServicePort> old = new ArrayList<IServicePort>(this.servicePorts);
        this.servicePorts.add(port);
        this.firePropertyChange("servicePorts", old, Collections.unmodifiableList(this.servicePorts));
    }

    @Override
    public void updateServicePort(IServicePort source, IServicePort target) {
        int pos = this.servicePorts.indexOf(source);
        if (pos > -1) {
            ArrayList<IServicePort> old = new ArrayList<IServicePort>(this.servicePorts);
            this.servicePorts.set(pos, target);
            this.fireIndexedPropertyChange("servicePorts", pos, old, Collections.unmodifiableList(this.servicePorts));
        }
    }

    @Override
    public void setSelectedVolume(String volume) {
        this.selectedVolume = volume;
        this.firePropertyChange("selectedVolume", this.selectedVolume, this.selectedVolume);
    }

    @Override
    public String getSelectedVolume() {
        return this.selectedVolume;
    }

    @Override
    public void updateVolume(String volume, String value) {
        LinkedHashSet<String> old = new LinkedHashSet<String>(this.volumes);
        this.volumes.remove(volume);
        this.volumes.add(value);
        this.firePropertyChange("volumes", old, Collections.unmodifiableList(this.volumes));
    }

    @Override
    public void setSelectedServicePort(IServicePort servicePort) {
        this.selectedServicePort = servicePort;
        this.firePropertyChange("selectedServicePort", this.selectedServicePort, this.selectedServicePort);
    }

    @Override
    public IServicePort getSelectedServicePort() {
        return this.selectedServicePort;
    }

    @Override
    public void removeServicePort(IServicePort port) {
        int index = this.servicePorts.indexOf(port);
        if (index > -1) {
            ArrayList<IServicePort> old = new ArrayList<IServicePort>(this.servicePorts);
            this.servicePorts.remove(port);
            this.fireIndexedPropertyChange("servicePorts", index, old, Collections.unmodifiableList(this.servicePorts));
        }
    }

    @Override
    public void setDockerConnection(IDockerConnection dockerConnection) {
        this.dockerConnection = dockerConnection;
        this.firePropertyChange("dockerConnection", this.dockerConnection, this.dockerConnection);
    }

    @Override
    public boolean imageExists(String image) {
        if (this.dockerConnection == null || StringUtils.isBlank((String)image)) {
            return false;
        }
        String[] imageDetails = image.split(":");
        if (imageDetails.length > 2) {
            return false;
        }
        String repo = imageDetails[0];
        String tag = imageDetails.length == 1 ? "latest" : imageDetails[1];
        return this.dockerConnection.hasImage(repo, tag);
    }

    @Override
    public void resetServicePorts() {
        List<IServicePort> ports = this.imagePorts.stream().map(sp -> new ServicePortAdapter((IServicePort)sp)).collect(Collectors.toList());
        this.setServicePorts(ports);
    }

    @Override
    public Map<String, String> getImageEnvVars() {
        return Collections.unmodifiableMap(this.imageEnvVars);
    }
}

