/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.wizard.deployimage;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.common.ui.JobUtils;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.foundation.core.jobs.DelegatingProgressMonitor;
import org.jboss.tools.openshift.common.ui.wizard.AbstractOpenShiftWizard;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.common.core.UsageStats;
import org.jboss.tools.openshift.internal.common.core.job.JobChainBuilder;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.dialog.ResourceSummaryDialog;
import org.jboss.tools.openshift.internal.ui.job.DeployImageJob;
import org.jboss.tools.openshift.internal.ui.job.RefreshResourcesJob;
import org.jboss.tools.openshift.internal.ui.wizard.common.IResourceLabelsPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.common.ResourceLabelsPage;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.DeployImagePage;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.DeploymentConfigPage;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.IDeployImagePageModel;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.IDeployImageParameters;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.IDeploymentConfigPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.IServiceAndRoutingPageModel;
import org.jboss.tools.openshift.internal.ui.wizard.deployimage.ServicesAndRoutingPage;

public class DeployImageWizard
extends AbstractOpenShiftWizard<IDeployImageParameters> {
    private static final String TITLE = "Deploy Image to OpenShift";

    public DeployImageWizard(IDeployImageParameters wizardModel) {
        super(TITLE, (Object)wizardModel);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.addPage((IWizardPage)new DeployImagePage((IWizard)this, (IDeployImagePageModel)this.getModel()));
        this.addPage((IWizardPage)new DeploymentConfigPage((IWizard)this, (IDeploymentConfigPageModel)this.getModel()));
        this.addPage((IWizardPage)new ServicesAndRoutingPage((IWizard)this, (IServiceAndRoutingPageModel)this.getModel()));
        this.addPage((IWizardPage)new ResourceLabelsPage((IWizard)this, (IResourceLabelsPageModel)this.getModel()));
    }

    public boolean performFinish() {
        final DeployImageJob deployJob = new DeployImageJob((IDeployImageParameters)this.getModel());
        deployJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                IStatus status = event.getResult();
                if (JobUtils.isOk((IStatus)status) || JobUtils.isWarning((IStatus)status)) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            String message = NLS.bind((String)"Results of deploying image \"{0}\".", (Object)((IDeployImageParameters)DeployImageWizard.this.getModel()).getName());
                            new ResourceSummaryDialog(DeployImageWizard.this.getShell(), deployJob.getResources(), DeployImageWizard.TITLE, message).open();
                        }
                    });
                    UIUtils.showOpenShiftExplorerView();
                }
            }
        });
        boolean success = false;
        try {
            try {
                Job job = new JobChainBuilder((Job)deployJob).runWhenSuccessfullyDone((Job)new RefreshResourcesJob(deployJob, true)).build();
                IStatus status = WizardUtils.runInWizard((Job)job, (DelegatingProgressMonitor)deployJob.getDelegatingProgressMonitor(), (IWizardContainer)this.getContainer());
                success = DeployImageWizard.isFailed(status);
            }
            catch (InterruptedException | InvocationTargetException e) {
                OpenShiftUIActivator.getDefault().getLogger().logError((Throwable)e);
                success = false;
                UsageStats.getInstance().newV3Application(((Connection)((IDeployImageParameters)this.getModel()).getConnection()).getHost(), success);
            }
        }
        finally {
            UsageStats.getInstance().newV3Application(((Connection)((IDeployImageParameters)this.getModel()).getConnection()).getHost(), success);
        }
        return success;
    }

    public static boolean isFailed(IStatus status) {
        return JobUtils.isOk((IStatus)status) || JobUtils.isWarning((IStatus)status);
    }
}

