/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.validator;

import java.util.regex.Pattern;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class EnvironmentVarKeyValidator
implements IValidator {
    private static final Pattern CIDENTIFIER_REGEXP = Pattern.compile("^[A-Za-z_][A-Za-z0-9_]*$");
    private final String failureMessage = "A valid {0} is alphanumeric (a-z, and 0-9), including the character '_', allowed anywhere except first position.";
    private final IStatus FAILED;

    public EnvironmentVarKeyValidator() {
        this("environment variable value");
    }

    public EnvironmentVarKeyValidator(String element) {
        this.FAILED = ValidationStatus.error((String)NLS.bind((String)"A valid {0} is alphanumeric (a-z, and 0-9), including the character '_', allowed anywhere except first position.", (Object)element));
    }

    public IStatus validate(Object paramObject) {
        if (!(paramObject instanceof String)) {
            return ValidationStatus.cancel((String)"Value is not an instance of a string");
        }
        String value = (String)paramObject;
        if (!CIDENTIFIER_REGEXP.matcher(value).matches()) {
            return this.FAILED;
        }
        return ValidationStatus.OK_STATUS;
    }
}

