/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.server;

import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.tools.common.databinding.ObservablePojo;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.ui.treeitem.IModelFactory;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem;

public class ServiceViewModel
extends ObservablePojo {
    public static final String PROPERTY_CONNECTION = "connection";
    public static final String PROPERTY_CONNECTIONS = "connections";
    public static final String PROPERTY_SERVICE = "service";
    public static final String PROPERTY_SERVICE_ITEMS = "serviceItems";
    private Connection connection;
    private List<Connection> connections = new ArrayList<Connection>();
    private List<ObservableTreeItem> serviceItems = new ArrayList<ObservableTreeItem>();
    private IService service;

    public ServiceViewModel(Connection connection) {
        this(null, connection);
    }

    public ServiceViewModel(IService service, Connection connection) {
        this.connection = connection;
        this.service = service;
    }

    protected void update(Connection connection, List<Connection> connections, IService service, List<ObservableTreeItem> serviceItems) {
        this.updateConnections(connections);
        this.updateConnection(connection);
        this.updateServiceItems(serviceItems);
        this.updateService(service, serviceItems);
    }

    protected void updateConnection(Connection connection) {
        this.connection = connection;
        this.firePropertyChange(PROPERTY_CONNECTION, this.connection, this.connection);
    }

    private void updateConnections(List<Connection> newConnections) {
        ArrayList<Connection> oldItems = new ArrayList<Connection>(this.connections);
        if (newConnections != this.connections) {
            this.connections.clear();
            if (newConnections != null) {
                this.connections.addAll(newConnections);
            }
            this.firePropertyChange(PROPERTY_CONNECTIONS, oldItems, this.connections);
        }
    }

    private void updateServiceItems(List<ObservableTreeItem> newServiceItems) {
        ArrayList<ObservableTreeItem> oldItems = new ArrayList<ObservableTreeItem>(this.serviceItems);
        if (newServiceItems != this.serviceItems) {
            this.serviceItems.clear();
            if (newServiceItems != null) {
                this.serviceItems.addAll(newServiceItems);
            }
            this.firePropertyChange(PROPERTY_SERVICE_ITEMS, oldItems, this.serviceItems);
        }
    }

    protected void updateService(IService service, List<ObservableTreeItem> serviceItems) {
        this.service = this.getServiceOrDefault(service, serviceItems);
        this.firePropertyChange(PROPERTY_SERVICE, null, this.service);
    }

    public void setConnections(List<Connection> connections) {
        this.update(this.connection, connections, this.service, this.serviceItems);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public List<Connection> getConnections() {
        return this.connections;
    }

    public void setConnection(Connection connection) {
        this.update(connection, this.connections, this.service, this.serviceItems);
    }

    public List<ObservableTreeItem> getServiceItems() {
        return this.serviceItems;
    }

    private void setServiceItems(List<ObservableTreeItem> items) {
        this.update(this.connection, this.connections, this.service, items);
    }

    public IService getService() {
        return this.service;
    }

    public void setService(IService service) {
        this.update(this.connection, this.connections, service, this.serviceItems);
    }

    protected IService getServiceOrDefault(IService service, List<ObservableTreeItem> services) {
        if (service == null) {
            service = this.getDefaultService(services);
        }
        return service;
    }

    private IService getDefaultService(List<ObservableTreeItem> items) {
        if (items == null || items.size() == 0) {
            return null;
        }
        Iterator<ObservableTreeItem> iterator = items.iterator();
        if (iterator.hasNext()) {
            ObservableTreeItem item = iterator.next();
            if (item.getModel() instanceof IService) {
                return (IService)item.getModel();
            }
            return this.getDefaultService(item.getChildren());
        }
        return null;
    }

    public void loadResources() {
        this.setConnections(this.loadConnections());
        if (this.connection == null) {
            return;
        }
        this.setServiceItems(this.loadServices(this.connection));
    }

    private List<Connection> loadConnections() {
        return (List)ConnectionsRegistrySingleton.getInstance().getAll(Connection.class);
    }

    protected List<ObservableTreeItem> loadServices(Connection connection) {
        ObservableTreeItem connectionItem = ServiceTreeItemsFactory.INSTANCE.create(connection);
        connectionItem.load();
        return connectionItem.getChildren();
    }

    static class ServiceTreeItemsFactory
    implements IModelFactory {
        private static final ServiceTreeItemsFactory INSTANCE = new ServiceTreeItemsFactory();

        ServiceTreeItemsFactory() {
        }

        @Override
        public <T> List<T> createChildren(Object parent) {
            if (parent instanceof Connection) {
                return ((Connection)parent).getResources("Project");
            }
            if (parent instanceof IProject) {
                return ((IProject)parent).getResources("Service");
            }
            return Collections.emptyList();
        }

        public List<ObservableTreeItem> create(Collection<?> openShiftObjects) {
            if (openShiftObjects == null) {
                return Collections.emptyList();
            }
            ArrayList<ObservableTreeItem> items = new ArrayList<ObservableTreeItem>();
            for (Object openShiftObject : openShiftObjects) {
                ObservableTreeItem item = this.create(openShiftObject);
                if (item == null) continue;
                items.add(item);
            }
            return items;
        }

        public ObservableTreeItem create(Object object) {
            return new ObservableTreeItem(object, this);
        }
    }
}

