/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.server;

import com.openshift.restclient.model.IService;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.jboss.tools.openshift.internal.common.ui.detailviews.AbstractStackedDetailViews;
import org.jboss.tools.openshift.internal.common.ui.utils.StyledTextUtils;

public class ServiceDetailViews
extends AbstractStackedDetailViews {
    private final AbstractStackedDetailViews.IDetailView templateView = new TemplateDetailView();

    public ServiceDetailViews(IObservableValue serviceObservable, Composite parent, DataBindingContext dbc) {
        super(serviceObservable, null, parent, dbc);
    }

    protected void createViewControls(Composite parent, Object context, DataBindingContext dbc) {
        this.templateView.createControls(parent, context, dbc);
        this.emptyView.createControls(parent, context, dbc);
    }

    protected AbstractStackedDetailViews.IDetailView[] getDetailViews() {
        return new AbstractStackedDetailViews.IDetailView[]{this.templateView, this.emptyView};
    }

    private class TemplateDetailView
    extends AbstractStackedDetailViews.EmptyView {
        private StyledText nameText;
        private StyledText namespaceText;
        private StyledText labelsText;
        private StyledText selectorsText;
        private StyledText ipText;
        private StyledText portText;

        private TemplateDetailView() {
            super((AbstractStackedDetailViews)ServiceDetailViews.this);
        }

        public Composite createControls(Composite parent, Object context, DataBindingContext dbc) {
            Composite container = this.setControl(new Composite(parent, 0));
            GridLayoutFactory.fillDefaults().numColumns(2).margins(8, 2).spacing(6, 2).applyTo(container);
            this.nameText = this.createLabeledValue("Name:", container);
            this.namespaceText = this.createLabeledValue("Namespace:", container);
            this.labelsText = this.createLabeledValue("Labels:", container);
            this.selectorsText = this.createLabeledValue("Selectors:", container);
            this.ipText = this.createLabeledValue("IP:", container);
            this.portText = this.createLabeledValue("Port:", container);
            return container;
        }

        private StyledText createLabeledValue(String labelText, Composite container) {
            Label label = new Label(container, 0);
            label.setText(labelText);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)label);
            StyledText styledText = new StyledText(container, 8);
            styledText.setAlwaysShowScrollBars(false);
            StyledTextUtils.setTransparent((StyledText)styledText);
            GridDataFactory.fillDefaults().align(16384, 0x1000000).grab(true, false).applyTo((Control)styledText);
            return styledText;
        }

        public void onVisible(IObservableValue serviceObservable, DataBindingContext dbc) {
            Object value = serviceObservable.getValue();
            if (!(value instanceof IService)) {
                return;
            }
            IService service = (IService)value;
            this.nameText.setText(service.getName());
            this.namespaceText.setText(service.getNamespace());
            this.labelsText.setText(org.jboss.tools.openshift.common.core.utils.StringUtils.toString((Map)service.getLabels()));
            this.selectorsText.setText(org.jboss.tools.openshift.common.core.utils.StringUtils.toString((Map)service.getSelector()));
            this.ipText.setText(StringUtils.join((Object[])new String[]{service.getPortalIP(), org.jboss.tools.openshift.common.core.utils.StringUtils.toStringOrNull((Object)service.getTargetPort())}, (char)':'));
            this.portText.setText(org.jboss.tools.openshift.common.core.utils.StringUtils.toStringOrNull((Object)service.getPort()));
        }

        public void onInVisible(IObservableValue templateObservable, DataBindingContext dbc) {
        }

        public boolean isViewFor(Object object) {
            return object instanceof IService;
        }
    }
}

