/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.server;

import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IService;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.tools.openshift.common.core.connection.ConnectionURL;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.utils.ProjectUtils;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.internal.common.core.util.CollectionUtils;
import org.jboss.tools.openshift.internal.ui.server.ServiceViewModel;
import org.jboss.tools.openshift.internal.ui.treeitem.IModelFactory;
import org.jboss.tools.openshift.internal.ui.treeitem.ObservableTreeItem;

public class ServerSettingsViewModel
extends ServiceViewModel {
    public static final String PROPERTY_DEPLOYPROJECT = "deployProject";
    public static final String PROPERTY_PROJECTS = "projects";
    public static final String PROPERTY_SOURCE_PATH = "sourcePath";
    public static final String PROPERTY_POD_PATH = "podPath";
    protected org.eclipse.core.resources.IProject deployProject;
    protected List<org.eclipse.core.resources.IProject> projects = new ArrayList<org.eclipse.core.resources.IProject>();
    private String sourcePath;
    protected String podPath;
    private IServerWorkingCopy server;

    public ServerSettingsViewModel(IServerWorkingCopy server, Connection connection) {
        super(connection);
        this.server = server;
    }

    protected void update(Connection connection, List<Connection> connections, org.eclipse.core.resources.IProject deployProject, List<org.eclipse.core.resources.IProject> projects, String sourcePath, String podPath, IService service, List<ObservableTreeItem> serviceItems) {
        this.update(connection, connections, service, serviceItems);
        this.updateProjects(projects);
        if (this.deployProject != deployProject) {
            sourcePath = null;
        }
        deployProject = this.updateDeployProject(deployProject, projects);
        this.updateSourcePath(sourcePath, deployProject);
        this.updatePodPath(podPath);
    }

    private void updateProjects(List<org.eclipse.core.resources.IProject> projects) {
        ArrayList<org.eclipse.core.resources.IProject> oldProjects = new ArrayList<org.eclipse.core.resources.IProject>(this.projects);
        ArrayList<org.eclipse.core.resources.IProject> newProjects = new ArrayList<org.eclipse.core.resources.IProject>();
        if (projects != null) {
            newProjects.addAll(projects);
        }
        this.projects.clear();
        this.projects.addAll(newProjects);
        this.firePropertyChange(PROPERTY_PROJECTS, oldProjects, this.projects);
    }

    protected org.eclipse.core.resources.IProject updateDeployProject(org.eclipse.core.resources.IProject deployProject, List<org.eclipse.core.resources.IProject> projects) {
        this.deployProject = this.getProjectOrDefault(deployProject, projects);
        this.firePropertyChange(PROPERTY_DEPLOYPROJECT, this.deployProject, this.deployProject);
        return this.deployProject;
    }

    protected void updateSourcePath(String sourcePath, org.eclipse.core.resources.IProject deployProject) {
        if (StringUtils.isEmpty((String)sourcePath) && ProjectUtils.isAccessible((org.eclipse.core.resources.IProject)deployProject)) {
            sourcePath = deployProject.getLocation().toString();
        }
        this.sourcePath = sourcePath;
        this.firePropertyChange(PROPERTY_SOURCE_PATH, this.sourcePath, this.sourcePath);
    }

    protected void updatePodPath(String newPodPath) {
        if (newPodPath == null) {
            newPodPath = "/opt/app-root/src";
        }
        this.podPath = newPodPath;
        this.firePropertyChange(PROPERTY_POD_PATH, this.podPath, this.podPath);
    }

    public void setDeployProject(org.eclipse.core.resources.IProject project) {
        this.update(this.getConnection(), this.getConnections(), project, this.projects, this.sourcePath, this.podPath, this.getService(), this.getServiceItems());
    }

    public org.eclipse.core.resources.IProject getDeployProject() {
        return this.deployProject;
    }

    protected void setProjects(List<org.eclipse.core.resources.IProject> projects) {
        this.update(this.getConnection(), this.getConnections(), this.deployProject, projects, this.sourcePath, this.podPath, this.getService(), this.getServiceItems());
    }

    public List<org.eclipse.core.resources.IProject> getProjects() {
        return this.projects;
    }

    public void setSourcePath(String sourcePath) {
        this.update(this.getConnection(), this.getConnections(), this.deployProject, this.projects, sourcePath, this.podPath, this.getService(), this.getServiceItems());
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setPodPath(String podPath) {
        this.update(this.getConnection(), this.getConnections(), this.deployProject, this.projects, this.sourcePath, podPath, this.getService(), this.getServiceItems());
    }

    public String getPodPath() {
        return this.podPath;
    }

    protected org.eclipse.core.resources.IProject getProjectOrDefault(org.eclipse.core.resources.IProject project, List<org.eclipse.core.resources.IProject> projects) {
        if (project == null) {
            project = (org.eclipse.core.resources.IProject)CollectionUtils.getFirstElement(projects);
        }
        return project;
    }

    @Override
    public void loadResources() {
        this.setProjects(this.loadProjects());
        super.loadResources();
    }

    protected List<org.eclipse.core.resources.IProject> loadProjects() {
        return ProjectUtils.getAllAccessibleProjects();
    }

    @Override
    protected List<ObservableTreeItem> loadServices(Connection connection) {
        ObservableTreeItem connectionItem = ServiceTreeItemsFactory.INSTANCE.create(connection);
        connectionItem.load();
        return connectionItem.getChildren();
    }

    public void updateServer() {
        this.updateServer(this.server);
    }

    private void updateServer(IServerWorkingCopy server) throws OpenShiftException {
        String connectionUrl = this.getConnectionUrl(this.getConnection());
        OpenShiftServerUtils.updateServer((String)OpenShiftServerUtils.getServerName((IService)this.getService(), (Connection)this.getConnection()), (String)connectionUrl, (IService)this.getService(), (String)this.sourcePath, (String)this.podPath, (org.eclipse.core.resources.IProject)this.deployProject, (IServerWorkingCopy)server);
        OpenShiftServerUtils.updateServerProject((String)connectionUrl, (IService)this.getService(), (String)this.sourcePath, (String)this.podPath, (org.eclipse.core.resources.IProject)this.deployProject);
    }

    private String getConnectionUrl(Connection connection) {
        try {
            ConnectionURL connectionUrl = ConnectionURL.forConnection((IConnection)connection);
            return connectionUrl.toString();
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            throw new OpenShiftException((Throwable)e, "Could not get url for connection {0}", new Object[]{connection.getHost()});
        }
    }

    protected IServerWorkingCopy getServer() {
        return this.server;
    }

    static class ServiceTreeItemsFactory
    implements IModelFactory {
        private static final ServiceTreeItemsFactory INSTANCE = new ServiceTreeItemsFactory();

        ServiceTreeItemsFactory() {
        }

        @Override
        public <T> List<T> createChildren(Object parent) {
            if (parent instanceof Connection) {
                return ((Connection)parent).getResources("Project");
            }
            if (parent instanceof IProject) {
                return ((IProject)parent).getResources("Service");
            }
            return Collections.emptyList();
        }

        public List<ObservableTreeItem> create(Collection<?> openShiftObjects) {
            if (openShiftObjects == null) {
                return Collections.emptyList();
            }
            ArrayList<ObservableTreeItem> items = new ArrayList<ObservableTreeItem>();
            for (Object openShiftObject : openShiftObjects) {
                ObservableTreeItem item = this.create(openShiftObject);
                if (item == null) continue;
                items.add(item);
            }
            return items;
        }

        public ObservableTreeItem create(Object object) {
            return new ObservableTreeItem(object, this);
        }
    }
}

