/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.server;

import com.openshift.restclient.model.IService;
import java.io.File;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.editor.IServerEditorPartInput;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;
import org.jboss.tools.common.ui.WizardUtils;
import org.jboss.tools.common.ui.databinding.ValueBindingBuilder;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.common.core.utils.FileUtils;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.server.OpenShiftServerUtils;
import org.jboss.tools.openshift.internal.common.core.job.JobChainBuilder;
import org.jboss.tools.openshift.internal.common.ui.SelectExistingProjectDialog;
import org.jboss.tools.openshift.internal.common.ui.connection.ConnectionColumLabelProvider;
import org.jboss.tools.openshift.internal.common.ui.connection.ConnectionWizard;
import org.jboss.tools.openshift.internal.common.ui.databinding.RequiredControlDecorationUpdater;
import org.jboss.tools.openshift.internal.common.ui.job.DisableAllWidgetsJob;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.ui.server.OpenShiftServerEditorModel;
import org.jboss.tools.openshift.internal.ui.server.SelectServiceWizard;

public class OpenShiftServerEditorSection
extends ServerEditorSection {
    private IServerEditorPartInput input;
    private OpenShiftServerEditorModel model;

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        if (input instanceof IServerEditorPartInput) {
            this.input = (IServerEditorPartInput)input;
        }
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 322);
        section.setText("OpenShift Server Adapter");
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)section);
        this.model = new OpenShiftServerEditorModel(this.server, null);
        Composite container = this.createControls((Composite)section, this.model);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)container);
        toolkit.paintBordersFor(container);
        toolkit.adapt(container);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)container);
        section.setClient((Control)container);
        this.loadResources((Composite)section, this.model);
    }

    private Composite createControls(Composite parent, OpenShiftServerEditorModel model) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(container);
        DataBindingContext dbc = new DataBindingContext();
        this.createConnectionContols(container, dbc);
        Group projectSettingGroup = new Group(container, 0);
        projectSettingGroup.setText("Project Settings:");
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).span(3, 1).applyTo((Control)projectSettingGroup);
        GridLayoutFactory.fillDefaults().margins(10, 10).applyTo((Composite)projectSettingGroup);
        Composite projectSettingsContainer = new Composite((Composite)projectSettingGroup, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)projectSettingsContainer);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(projectSettingsContainer);
        this.createProjectControls(projectSettingsContainer, dbc);
        this.createDeploymentControls(projectSettingsContainer, dbc);
        this.createSourcePathControls(projectSettingsContainer, dbc);
        this.createServiceControls(projectSettingsContainer, dbc);
        return container;
    }

    private void createConnectionContols(Composite parent, DataBindingContext dbc) {
        Label connectionLabel = new Label(parent, 0);
        connectionLabel.setText("Connection:");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)connectionLabel);
        Combo connectionCombo = new Combo(parent, -1);
        ComboViewer connectionViewer = new ComboViewer(connectionCombo);
        connectionViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        connectionViewer.setLabelProvider((IBaseLabelProvider)new ConnectionColumLabelProvider());
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)connectionCombo);
        connectionViewer.setInput((Object)BeanProperties.list((String)"connections").observe((Object)this.model));
        Binding connectionBinding = ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)connectionViewer)).validatingAfterGet(new IValidator(){

            public IStatus validate(Object value) {
                if (!(value instanceof Connection)) {
                    return ValidationStatus.cancel((String)"Please select a connection for this server adapter.");
                }
                return ValidationStatus.ok();
            }
        })).to(BeanProperties.value((String)"connection").observe((Object)this.model)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)connectionBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
        Button newConnectionButton = new Button(parent, 8);
        newConnectionButton.setText("New...");
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(100, -1).applyTo((Control)newConnectionButton);
        newConnectionButton.addSelectionListener(this.onNewConnection(connectionViewer));
    }

    private SelectionListener onNewConnection(final ComboViewer connectionViewer) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Connection connection = (Connection)UIUtils.getFirstElement((ISelection)connectionViewer.getSelection(), Connection.class);
                ConnectionWizard wizard = new ConnectionWizard((IConnection)connection);
                if (WizardUtils.openWizardDialog((IWizard)wizard, (Shell)connectionViewer.getControl().getShell()) == 0) {
                    connectionViewer.getControl().setEnabled(true);
                    connectionViewer.setInput((Object)ConnectionsRegistrySingleton.getInstance().getAll());
                    Connection selectedConnection = (Connection)ConnectionsRegistrySingleton.getInstance().getRecentConnection(Connection.class);
                    OpenShiftServerEditorSection.this.model.setConnection(selectedConnection);
                }
            }
        };
    }

    private void createProjectControls(Composite parent, DataBindingContext dbc) {
        Label projectLabel = new Label(parent, 0);
        projectLabel.setText("Eclipse Project: ");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)projectLabel);
        ComboViewer projectsViewer = new ComboViewer(parent);
        GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).grab(true, false).applyTo(projectsViewer.getControl());
        projectsViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        projectsViewer.setLabelProvider((IBaseLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (!(element instanceof IProject)) {
                    return null;
                }
                return ((IProject)element).getName();
            }
        });
        projectsViewer.setInput((Object)BeanProperties.list((String)"projects").observe((Object)this.model));
        IViewerObservableValue selectedProjectObservable = ViewerProperties.singleSelection().observe((Viewer)projectsViewer);
        Binding selectedProjectBinding = ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)selectedProjectObservable).validatingAfterConvert(new IValidator(){

            public IStatus validate(Object value) {
                if (value instanceof IProject) {
                    return ValidationStatus.ok();
                }
                return ValidationStatus.cancel((String)"Please choose a project to deploy.");
            }
        })).to(BeanProperties.value((String)"deployProject").observe((Object)this.model)).in(dbc);
        ControlDecorationSupport.create((ValidationStatusProvider)selectedProjectBinding, (int)16512, null, (ControlDecorationUpdater)new RequiredControlDecorationUpdater(true));
        Button browseProjectsButton = new Button(parent, 0);
        browseProjectsButton.setText("Browse...");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).hint(100, -1).applyTo((Control)browseProjectsButton);
        browseProjectsButton.addSelectionListener(this.onBrowseProjects(this.model, browseProjectsButton.getShell()));
    }

    private SelectionListener onBrowseProjects(final OpenShiftServerEditorModel model, final Shell shell) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selectedProject;
                SelectExistingProjectDialog dialog = new SelectExistingProjectDialog("Select a project to deploy", shell);
                if (dialog.open() == 0 && (selectedProject = dialog.getFirstResult()) instanceof IProject) {
                    model.setDeployProject((IProject)selectedProject);
                }
            }
        };
    }

    private void createSourcePathControls(Composite container, DataBindingContext dbc) {
        Label sourcePathLabel = new Label(container, 0);
        sourcePathLabel.setText("Source Path: ");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)sourcePathLabel);
        Text sourcePathText = new Text(container, 2056);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)sourcePathText);
        ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observe((Widget)sourcePathText)).validatingAfterConvert(new IValidator(){

            public IStatus validate(Object value) {
                if (!(value instanceof String) || StringUtils.isEmpty((Object)value)) {
                    return ValidationStatus.cancel((String)"Please provide a source path to deploy to the pod.");
                }
                if (!this.isValidFile((String)value)) {
                    return ValidationStatus.error((String)"Please provide a valid path to deploy to the pod");
                }
                return ValidationStatus.ok();
            }

            private boolean isValidFile(String path) {
                return FileUtils.exists((File)new File(path));
            }
        })).to(BeanProperties.value((String)"sourcePath").observe((Object)this.model)).in(dbc);
        Button browseSourceButton = new Button(container, 8);
        browseSourceButton.setText("Browse...");
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(100, -1).applyTo((Control)browseSourceButton);
        browseSourceButton.addSelectionListener((SelectionListener)this.onBrowseSource(browseSourceButton.getShell()));
        Button browseWorkspaceSourceButton = new Button(container, 8);
        browseWorkspaceSourceButton.setText("Workspace...");
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(100, -1).applyTo((Control)browseWorkspaceSourceButton);
        browseWorkspaceSourceButton.addSelectionListener((SelectionListener)this.onBrowseWorkspace(browseWorkspaceSourceButton.getShell()));
    }

    private SelectionAdapter onBrowseSource(final Shell shell) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(shell, 4096);
                dialog.setText("Choose the source path to sync");
                dialog.setFilterPath(OpenShiftServerEditorSection.this.model.getSourcePath());
                String filepath = dialog.open();
                if (!StringUtils.isEmpty((String)filepath)) {
                    OpenShiftServerEditorSection.this.model.setSourcePath(filepath);
                }
            }
        };
    }

    private SelectionAdapter onBrowseWorkspace(final Shell shell) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(shell, 4096);
                dialog.setText("Choose the source path to sync");
                dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
                String filepath = dialog.open();
                if (!StringUtils.isEmpty((String)filepath)) {
                    OpenShiftServerEditorSection.this.model.setSourcePath(filepath);
                }
            }
        };
    }

    private void createDeploymentControls(Composite parent, DataBindingContext dbc) {
        Label deployPathLabel = new Label(parent, 0);
        deployPathLabel.setText("Pod Deployment Path: ");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)deployPathLabel);
        Text deployPathText = new Text(parent, 2048);
        GridDataFactory.fillDefaults().span(3, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)deployPathText);
        ((ValueBindingBuilder.TargetDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observe((Widget)deployPathText)).validatingAfterConvert(new IValidator(){

            public IStatus validate(Object value) {
                if (!(value instanceof String) || StringUtils.isEmpty((Object)value)) {
                    return ValidationStatus.cancel((String)"Please provide a path to deploy to on the pod.");
                }
                if (!Path.isValidPosixPath((String)((String)value))) {
                    return ValidationStatus.error((String)"Please provide a valid path to deploy to on the pod");
                }
                return ValidationStatus.ok();
            }
        })).to(BeanProperties.value((String)"podPath").observe((Object)this.model)).in(dbc);
    }

    private void createServiceControls(Composite parent, DataBindingContext dbc) {
        Label serviceLabel = new Label(parent, 0);
        serviceLabel.setText("Service:");
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)serviceLabel);
        Text serviceText = new Text(parent, 2056);
        GridDataFactory.fillDefaults().span(2, 1).align(4, 0x1000000).grab(true, false).applyTo((Control)serviceText);
        ((ValueBindingBuilder.ModelDefinition)ValueBindingBuilder.bind((IObservableValue)WidgetProperties.text((int)24).observe((Widget)serviceText)).to(BeanProperties.value((String)"service").observe((Object)this.model)).converting((IConverter)new Converter(IService.class, String.class){

            public Object convert(Object fromObject) {
                if (!(fromObject instanceof IService)) {
                    return null;
                }
                return ((IService)fromObject).getName();
            }
        })).in(dbc);
        Button selectServiceButton = new Button(parent, 8);
        selectServiceButton.setText("Select...");
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(100, -1).applyTo((Control)selectServiceButton);
        selectServiceButton.addSelectionListener(this.onSelectService(this.model, selectServiceButton.getShell()));
    }

    private SelectionListener onSelectService(final OpenShiftServerEditorModel model, final Shell shell) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectServiceWizard selectServiceDialog = new SelectServiceWizard(NLS.bind((String)"Select a service that your server adapter {0} will publish to.", (Object)OpenShiftServerEditorSection.this.input.getServer().getName()), model.getService(), model.getConnection());
                if (WizardUtils.openWizardDialog((IWizard)selectServiceDialog, (Shell)shell) == 0) {
                    model.setService(selectServiceDialog.getService());
                }
            }
        };
    }

    private void loadResources(Composite container, final OpenShiftServerEditorModel model) {
        final IServerWorkingCopy server = this.input.getServer();
        final Connection connection = OpenShiftServerUtils.getConnection((IServerAttributes)server);
        final IProject deployProject = OpenShiftServerUtils.getDeployProject((IServerAttributes)server);
        Cursor busyCursor = new Cursor((Device)container.getDisplay(), 1);
        new JobChainBuilder((Job)new DisableAllWidgetsJob(true, container, busyCursor)).runWhenDone(new Job("Loading projects..."){

            protected IStatus run(IProgressMonitor monitor) {
                model.loadResources();
                return Status.OK_STATUS;
            }
        }).runWhenDone(new Job("Setting connection, deploy project..."){

            protected IStatus run(IProgressMonitor monitor) {
                model.setService(OpenShiftServerUtils.getService((IServerAttributes)server));
                if (deployProject != null) {
                    model.setDeployProject(deployProject);
                }
                if (connection != null) {
                    model.setConnection(connection);
                }
                return Status.OK_STATUS;
            }
        }).runWhenDone((Job)new DisableAllWidgetsJob(true, container, false, busyCursor)).schedule();
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
    }
}

