/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.server;

import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.common.ui.OpenShiftCommonImages;
import org.jboss.tools.openshift.internal.common.ui.connection.ConnectionWizardModel;
import org.jboss.tools.openshift.internal.common.ui.connection.ConnectionWizardPage;
import org.jboss.tools.openshift.internal.common.ui.wizard.AbstractOpenShiftWizardPage;
import org.jboss.tools.openshift.internal.common.ui.wizard.IConnectionAware;
import org.jboss.tools.openshift.internal.ui.server.OpenShiftServerTaskModelAccessor;

public class ConnectionWizardFragment
extends WizardFragment {
    private WrappedConnectionWizardPage connectionPage;

    public boolean hasComposite() {
        return true;
    }

    public boolean isComplete() {
        return this.connectionPage != null && this.connectionPage.isPageComplete();
    }

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.connectionPage = this.createConnectionWizardPage(parent, handle);
        this.updateWizardHandle(handle, this.connectionPage);
        this.getContainer(this.getPage(handle)).addPageChangingListener(this.onPageChanging(handle));
        return (Composite)this.connectionPage.getControl();
    }

    private IPageChangingListener onPageChanging(final IWizardHandle wizardHandle) {
        return new IPageChangingListener(){

            public void handlePageChanging(PageChangingEvent event) {
                if (event.getCurrentPage() == ConnectionWizardFragment.this.getPage(wizardHandle)) {
                    if (event.getTargetPage() == null || event.getTargetPage().equals(ConnectionWizardFragment.this.getPage(wizardHandle).getNextPage())) {
                        ConnectionWizardFragment.this.connectionPage.onPageWillGetDeactivated(AbstractOpenShiftWizardPage.Direction.FORWARDS, event);
                    } else {
                        ConnectionWizardFragment.this.connectionPage.onPageWillGetDeactivated(AbstractOpenShiftWizardPage.Direction.BACKWARDS, event);
                    }
                    IConnection connection = ConnectionWizardFragment.this.connectionPage.getConnection();
                    if (connection instanceof Connection) {
                        OpenShiftServerTaskModelAccessor.set((Connection)connection, ConnectionWizardFragment.this.getTaskModel());
                    }
                }
            }
        };
    }

    private WrappedConnectionWizardPage createConnectionWizardPage(Composite parent, IWizardHandle handle) {
        WrappedConnectionWizardPage connectionPage = new WrappedConnectionWizardPage(handle);
        connectionPage.createControl(parent);
        return connectionPage;
    }

    private void updateWizardHandle(IWizardHandle handle, ConnectionWizardPage connectionPage) {
        handle.setTitle(connectionPage.getTitle());
        handle.setDescription(connectionPage.getDescription());
        handle.setImageDescriptor(OpenShiftCommonImages.OPENSHIFT_LOGO_WHITE_MEDIUM);
    }

    private IWizardPage getPage(IWizardHandle wizardHandle) {
        return (IWizardPage)wizardHandle;
    }

    private WizardDialog getContainer(IWizardPage wizardPage) {
        return (WizardDialog)wizardPage.getWizard().getContainer();
    }

    private class WrappedConnectionWizardPage
    extends ConnectionWizardPage {
        private IWizardHandle wizardHandle;

        private WrappedConnectionWizardPage(IWizardHandle wizardHandle) {
            super(((IWizardPage)wizardHandle).getWizard(), (IConnectionAware)new ConnectionWizardModel(null, null), Connection.class);
            this.wizardHandle = wizardHandle;
        }

        public void setPageComplete(boolean complete) {
            super.setPageComplete(complete);
            this.wizardHandle.update();
        }

        public void setErrorMessage(String newMessage) {
            ((WizardPage)this.wizardHandle).setErrorMessage(newMessage);
        }

        public void setMessage(String newMessage, int newType) {
            this.wizardHandle.setMessage(newMessage, newType);
        }

        public void onPageWillGetDeactivated(AbstractOpenShiftWizardPage.Direction direction, PageChangingEvent event) {
            this.onPageWillGetDeactivated(direction, event, null);
        }
    }
}

