/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.route;

import com.openshift.restclient.model.route.IRoute;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.openshift.core.IRouteChooser;
import org.jboss.tools.openshift.internal.ui.dialog.SelectRouteDialog;

public class RouteChooser
implements IRouteChooser {
    private static final String NO_ROUTE_MSG = "Could not find a route that points to an url to show in a browser.";
    private Shell shell;

    public RouteChooser() {
        this(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
    }

    public RouteChooser(Shell shell) {
        this.shell = shell;
    }

    public IRoute chooseRoute(List<IRoute> routes) {
        SelectRouteDialog routeDialog = new SelectRouteDialog(routes, this.shell);
        if (routeDialog.open() == 0) {
            return routeDialog.getSelectedRoute();
        }
        return null;
    }

    public void noRouteErrorDialog() {
        MessageDialog.openWarning((Shell)this.shell, (String)"No route to open", (String)NO_ROUTE_MSG);
    }
}

