/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.preferences;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jboss.tools.foundation.ui.util.BrowserUtility;
import org.jboss.tools.openshift.internal.common.core.util.CommandLocationBinary;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;

public class OpenShiftPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String DOWNLOAD_INSTRUCTIONS_URL = "https://github.com/openshift/origin/blob/master/CONTRIBUTING.adoc#download-from-github";
    private FileFieldEditor cliLocationEditor;
    private OCBinaryName ocBinary = OCBinaryName.getInstance();

    public OpenShiftPreferencePage() {
        super(1);
    }

    public void createFieldEditors() {
        Link link = new Link(this.getFieldEditorParent(), 64);
        link.setText("The OpenShift Client binary (oc) is required for features such as Port Forwarding or Log Streaming. You can find more information about how to install it from <a>here</a>.");
        GridDataFactory.fillDefaults().span(3, 1).hint(300, -1).applyTo((Control)link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new BrowserUtility().checkedCreateExternalBrowser(OpenShiftPreferencePage.DOWNLOAD_INSTRUCTIONS_URL, "org.jboss.tools.openshift.ui", OpenShiftUIActivator.getDefault().getLog());
            }
        });
        this.cliLocationEditor = new FileFieldEditor("openshift.cli.location", NLS.bind((String)"''{0}'' executable location", (Object)this.ocBinary.getName()), this.getFieldEditorParent()){

            public boolean doCheckState() {
                return OpenShiftPreferencePage.this.validateLocation(this.getStringValue());
            }
        };
        this.cliLocationEditor.setFilterPath(SystemUtils.getUserHome());
        this.cliLocationEditor.setFileExtensions(this.ocBinary.getExtensions());
        this.cliLocationEditor.setValidateStrategy(0);
        this.addField((FieldEditor)this.cliLocationEditor);
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.performOk();
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(OpenShiftUIActivator.getDefault().getCorePreferenceStore());
    }

    protected void performDefaults() {
        String location = this.ocBinary.getLocation();
        if (StringUtils.isBlank((String)location)) {
            String message = NLS.bind((String)"Could not find the OpenShift Client binary \"{0}\" on your path.", (Object)this.ocBinary.getName());
            OpenShiftUIActivator.getDefault().getLogger().logWarning(message);
            MessageDialog.openWarning((Shell)this.getShell(), (String)"No OpenShift Client binary", (String)message);
            return;
        }
        this.cliLocationEditor.setStringValue(location);
    }

    public boolean performOk() {
        boolean valid = super.performOk() && this.validateLocation(this.cliLocationEditor.getStringValue());
        this.setValid(valid);
        return valid;
    }

    private boolean validateLocation(String location) {
        if (StringUtils.isBlank((String)location)) {
            return true;
        }
        File file = new File(location);
        if (!this.ocBinary.getName().equals(file.getName())) {
            this.setErrorMessage(NLS.bind((String)"{0} is not the OpenShift Client ''{1}'' executable.", (Object)file.getName(), (Object)this.ocBinary.getName()));
            return false;
        }
        if (!file.exists()) {
            this.setErrorMessage(NLS.bind((String)"{0} was not found.", (Object)file));
            return false;
        }
        if (!file.canExecute()) {
            this.setErrorMessage(NLS.bind((String)"{0} does not have execute permissions.", (Object)file));
            return false;
        }
        return true;
    }

    public static enum OCBinaryName {
        WINDOWS("oc.exe", new String[]{"exe"}),
        OTHER("oc", new String[0]);

        private String name;
        private String[] extensions;
        private CommandLocationBinary locationBinary;

        private OCBinaryName(String name, String[] extensions) {
            this.name = name;
            this.extensions = extensions;
        }

        public String getName() {
            return this.name;
        }

        public String[] getExtensions() {
            return this.extensions;
        }

        public String getLocation() {
            if (this.locationBinary == null) {
                this.locationBinary = new CommandLocationBinary("oc");
                this.locationBinary.addPlatformLocation("linux", "/usr/bin/oc");
                this.locationBinary.setDefaultPlatform("linux");
            }
            return this.locationBinary.findLocation();
        }

        public static OCBinaryName getInstance() {
            if (SystemUtils.IS_OS_WINDOWS) {
                return WINDOWS;
            }
            return OTHER;
        }
    }
}

