/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.portforwading;

import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.resources.IPortForwardable;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IPort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.launching.SocketUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.jboss.tools.common.databinding.ObservablePojo;
import org.jboss.tools.openshift.internal.common.ui.console.ConsoleUtils;

public class PortForwardingWizardModel
extends ObservablePojo {
    public static final String PROPERTY_FORWARDABLE_PORTS = "forwardablePorts";
    public static final String PROPERTY_PORT_FORWARDING = "portForwarding";
    public static final String PROPERTY_USE_FREE_PORTS = "useFreePorts";
    private static final Map<IPod, IPortForwardable> REGISTRY = new HashMap<IPod, IPortForwardable>();
    private Boolean useFreePorts = Boolean.FALSE;
    private final IPod pod;
    private final ConsoleListener consoleListener = new ConsoleListener();
    private Set<IPortForwardable.PortPair> ports = new HashSet<IPortForwardable.PortPair>();

    public PortForwardingWizardModel(IPod pod) {
        this.pod = pod;
        IPortForwardable forwardable = REGISTRY.get(pod);
        if (forwardable != null && forwardable.getPortPairs() != null && forwardable.getPortPairs().length > 0) {
            IPortForwardable.PortPair[] portPairArray = forwardable.getPortPairs();
            int n = portPairArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPortForwardable.PortPair p = portPairArray[n2];
                this.ports.add(p);
                ++n2;
            }
        } else {
            for (IPort port : pod.getContainerPorts()) {
                this.ports.add(new IPortForwardable.PortPair(port));
            }
        }
        this.ports = Collections.unmodifiableSet(this.ports);
    }

    public final String getPodName() {
        return String.valueOf(this.pod.getNamespace()) + "\\" + this.pod.getName();
    }

    public boolean getPortForwarding() {
        return this.isPortForwarding(this.pod);
    }

    public Collection<IPortForwardable.PortPair> getForwardablePorts() {
        return this.ports;
    }

    public void startPortForwarding() {
        if (this.isPortForwarding(this.pod)) {
            return;
        }
        IPortForwardable portForwardable = (IPortForwardable)this.pod.accept((CapabilityVisitor)new CapabilityVisitor<IPortForwardable, IPortForwardable>(){

            public IPortForwardable visit(IPortForwardable cap) {
                MessageConsole console = ConsoleUtils.findMessageConsole((String)PortForwardingWizardModel.this.getMessageConsoleName());
                PortForwardingWizardModel.this.consoleListener.setCapability(cap);
                ConsoleUtils.registerConsoleListener((IConsoleListener)PortForwardingWizardModel.this.consoleListener);
                MessageConsoleStream stream = console.newMessageStream();
                stream.println("Starting port-forwarding...");
                for (IPortForwardable.PortPair port : PortForwardingWizardModel.this.ports) {
                    stream.println(NLS.bind((String)"{0} {1} -> {2}", (Object[])new Object[]{port.getName(), port.getLocalPort(), port.getRemotePort()}));
                }
                cap.forwardPorts(PortForwardingWizardModel.this.ports.toArray(new IPortForwardable.PortPair[0]));
                stream.println("done.");
                ConsoleUtils.displayConsoleView((IConsole)console);
                PortForwardingWizardModel.this.firePropertyChange(PortForwardingWizardModel.PROPERTY_PORT_FORWARDING, false, PortForwardingWizardModel.this.getPortForwarding());
                return cap;
            }
        }, null);
        if (portForwardable != null) {
            REGISTRY.put(this.pod, portForwardable);
        }
    }

    private boolean isPortForwarding(IPod pod) {
        IPortForwardable capability = REGISTRY.get(pod);
        if (capability == null) {
            return false;
        }
        return capability.isForwarding();
    }

    private String getMessageConsoleName() {
        return NLS.bind((String)"Port forwarding to pod {0} ({1})", (Object)this.pod.getName(), (Object)this.pod.getNamespace());
    }

    public void stopPortForwarding() {
        if (!this.isPortForwarding(this.pod)) {
            return;
        }
        IPortForwardable cap = REGISTRY.remove(this.pod);
        try {
            MessageConsole console = ConsoleUtils.findMessageConsole((String)this.getMessageConsoleName());
            MessageConsoleStream stream = console.newMessageStream();
            stream.println("Stopping port-forwarding...");
            cap.stop();
            for (IPortForwardable.PortPair port : this.ports) {
                stream.println(NLS.bind((String)"{0} {1} -> {2}", (Object[])new Object[]{port.getName(), port.getLocalPort(), port.getRemotePort()}));
            }
            stream.println("done.");
            ConsoleUtils.displayConsoleView((IConsole)console);
            this.firePropertyChange(PROPERTY_PORT_FORWARDING, true, this.getPortForwarding());
        }
        finally {
            ConsoleUtils.deregisterConsoleListener((IConsoleListener)this.consoleListener);
        }
    }

    public Boolean getUseFreePorts() {
        return this.useFreePorts;
    }

    public void setUseFreePorts(Boolean useFreePorts) {
        if (!this.getPortForwarding()) {
            this.updateLocalPortBindings(useFreePorts);
        }
        this.useFreePorts = useFreePorts;
        this.firePropertyChange(PROPERTY_USE_FREE_PORTS, this.useFreePorts, this.useFreePorts);
    }

    private void updateLocalPortBindings(boolean useFreePorts) {
        ArrayList<String> bindings = new ArrayList<String>();
        for (IPortForwardable.PortPair port : this.ports) {
            if (useFreePorts) {
                port.setLocalPort(SocketUtil.findFreePort());
                continue;
            }
            port.setLocalPort(port.getRemotePort());
            String key = this.computeKey(port);
            while (bindings.contains(key)) {
                port.setLocalPort(SocketUtil.findFreePort());
                key = this.computeKey(port);
            }
            bindings.add(key);
        }
    }

    private String computeKey(IPortForwardable.PortPair port) {
        return "127.0.0.1:" + port.getLocalPort();
    }

    private class ConsoleListener
    implements IConsoleListener {
        private IPortForwardable cap;

        private ConsoleListener() {
        }

        public void setCapability(IPortForwardable cap) {
            this.cap = cap;
        }

        public void consolesRemoved(IConsole[] consoles) {
            String messageConsoleName = PortForwardingWizardModel.this.getMessageConsoleName();
            IConsole[] iConsoleArray = consoles;
            int n = consoles.length;
            int n2 = 0;
            while (n2 < n) {
                IConsole console = iConsoleArray[n2];
                if (console.getName().equals(messageConsoleName)) {
                    try {
                        this.cap.stop();
                        REGISTRY.remove(PortForwardingWizardModel.this.pod);
                        return;
                    }
                    finally {
                        ConsoleUtils.deregisterConsoleListener((IConsoleListener)this);
                    }
                }
                ++n2;
            }
        }

        public void consolesAdded(IConsole[] consoles) {
        }
    }
}

