/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.job;

import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.resources.IBuildTriggerable;
import com.openshift.restclient.model.IBuild;
import com.openshift.restclient.model.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.openshift.common.core.connection.ConnectionsRegistrySingleton;
import org.jboss.tools.openshift.common.core.connection.IConnection;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.internal.common.core.job.AbstractDelegatingMonitorJob;

public class StartBuildJob
extends AbstractDelegatingMonitorJob {
    private IResource buildsource;

    public StartBuildJob(IResource buildsource) {
        super("Start Build Job");
        this.buildsource = buildsource;
    }

    protected IStatus doRun(IProgressMonitor monitor) {
        try {
            monitor.beginTask("Starting build job", -1);
            IBuild build = (IBuild)this.buildsource.accept((CapabilityVisitor)new CapabilityVisitor<IBuildTriggerable, IBuild>(){

                public IBuild visit(IBuildTriggerable triggerable) {
                    return triggerable.trigger();
                }
            }, null);
            if (build == null) {
                Status status = new Status(1, "org.jboss.tools.openshift.ui", "Manually triggering builds is unsupported");
                return status;
            }
            Connection connection = ConnectionsRegistryUtil.getConnectionFor((IResource)this.buildsource);
            ConnectionsRegistrySingleton.getInstance().fireConnectionChanged((IConnection)connection, "openshift.resource", null, (Object)build);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (OpenShiftException e) {
            Status status = new Status(4, "org.jboss.tools.openshift.ui", NLS.bind((String)"Error starting build {0}.", (Object)this.buildsource.getName()), (Throwable)e);
            return status;
        }
        finally {
            monitor.done();
        }
    }
}

