/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.handler;

import com.openshift.restclient.model.IBuild;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IResource;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.ui.handler.AbstractOpenShiftCliHandler;
import org.jboss.tools.openshift.internal.ui.job.PodLogsJob;

public class PodLogsHandler
extends AbstractOpenShiftCliHandler {
    private static final String[] STATES = new String[]{"Running", "Succeeded", "Failed"};
    private static final String BUILDNAME_ANNOTATION = "openshift.io/build.name";

    @Override
    protected void handleEvent(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IPod pod = (IPod)UIUtils.getFirstElement((ISelection)selection, IPod.class);
        if (pod == null && (pod = this.getPodFromBuild(selection)) == null) {
            MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"No pod selected", (String)"Unable to determine the build pod in order to retrieve its log.");
            return;
        }
        this.showLogs(pod, event);
    }

    private void showLogs(IPod pod, ExecutionEvent event) {
        if (pod == null) {
            MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"No pod selected", (String)"No pod was selected to retrieve a log.");
            return;
        }
        if (!ArrayUtils.contains((Object[])STATES, (Object)pod.getStatus())) {
            MessageDialog.openError((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"Logs Unavailable", (String)NLS.bind((String)"The log is unavailable while the pod is in {0} state.", (Object)pod.getStatus()));
            return;
        }
        new PodLogsJob(pod).schedule();
    }

    private IPod getPodFromBuild(ISelection selection) {
        IBuild build = (IBuild)UIUtils.getFirstElement((ISelection)selection, IBuild.class);
        if (build != null) {
            String buildName = build.getName();
            Connection connection = ConnectionsRegistryUtil.safeGetConnectionFor((IResource)build);
            List pods = connection.getResources("Pod", build.getNamespace());
            for (IPod pod : pods) {
                if (!buildName.equals(pod.getAnnotation(BUILDNAME_ANNOTATION))) continue;
                return pod;
            }
        }
        return null;
    }
}

