/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.handler;

import com.openshift.restclient.model.IBuild;
import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.IDeploymentConfig;
import com.openshift.restclient.model.IImageStream;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.foundation.ui.util.BrowserUtility;
import org.jboss.tools.openshift.common.core.utils.StringUtils;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.core.connection.ConnectionsRegistryUtil;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;

public class OpenInWebConsoleHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String msg;
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IResource resource = (IResource)UIUtils.getFirstElement((ISelection)currentSelection, IResource.class);
        Connection connection = null;
        connection = resource == null ? (Connection)UIUtils.getFirstElement((ISelection)currentSelection, Connection.class) : ConnectionsRegistryUtil.safeGetConnectionFor((IResource)resource);
        if (connection == null) {
            msg = "Could not find an OpenShift connection to open a console for";
        } else {
            String url = this.getWebConsoleUrl(connection, resource);
            if (!StringUtils.isEmpty((String)url)) {
                new BrowserUtility().checkedCreateInternalBrowser(url, "", "org.jboss.tools.openshift.ui", OpenShiftUIActivator.getDefault().getLog());
                return Status.OK_STATUS;
            }
            msg = NLS.bind((String)"Could not determine the url for the web console on {0}", (Object)connection.getHost());
        }
        MessageDialog.openWarning((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"No Web Console Url", (String)msg);
        return new Status(2, "org.jboss.tools.openshift.ui", msg);
    }

    private String getWebConsoleUrl(Connection connection, IResource resource) {
        IProject project;
        StringBuilder url = new StringBuilder(connection.getHost()).append("/console");
        IProject iProject = project = resource == null ? null : resource.getProject();
        if (project != null) {
            url.append("/project/").append(project.getName());
        }
        if (resource != null && !(resource instanceof IProject)) {
            url.append("/browse");
            if (resource instanceof IBuildConfig || resource instanceof IBuild) {
                url.append("/builds");
            } else if (resource instanceof IDeploymentConfig) {
                url.append("/deployments");
            } else if (resource instanceof IPod) {
                url.append("/pods");
            } else if (resource instanceof IService) {
                url.append("/services");
            } else if (resource instanceof IImageStream) {
                url.append("/images");
            }
        }
        return url.toString();
    }
}

