/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.handler;

import com.openshift.restclient.model.IProject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jboss.tools.openshift.internal.common.ui.utils.UIUtils;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIActivator;
import org.jboss.tools.openshift.internal.ui.OpenShiftUIMessages;
import org.jboss.tools.openshift.internal.ui.job.DeleteResourceJob;
import org.jboss.tools.openshift.internal.ui.job.OpenShiftJobs;

public class DeleteProjectsHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        IProject project = (IProject)UIUtils.getFirstElement((ISelection)selection, IProject.class);
        if (project == null) {
            return OpenShiftUIActivator.statusFactory().cancelStatus("No project selected that we can delete.");
        }
        this.deleteProject(project, HandlerUtil.getActiveShell((ExecutionEvent)event));
        return null;
    }

    private void deleteProject(IProject project, Shell shell) {
        if (project == null) {
            return;
        }
        boolean confirm = MessageDialog.openConfirm((Shell)shell, (String)OpenShiftUIMessages.ProjectDeletionDialogTitle, (String)NLS.bind((String)OpenShiftUIMessages.ProjectDeletionConfirmation, (Object)project.getName()));
        if (!confirm) {
            return;
        }
        DeleteResourceJob job = OpenShiftJobs.createDeleteProjectJob(project);
        job.schedule();
    }
}

