/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.explorer;

import com.openshift.restclient.capability.CapabilityVisitor;
import com.openshift.restclient.capability.resources.ITags;
import com.openshift.restclient.model.IBuild;
import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.IDeploymentConfig;
import com.openshift.restclient.model.IImageStream;
import com.openshift.restclient.model.IPod;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.IReplicationController;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.IService;
import com.openshift.restclient.model.route.IRoute;
import com.openshift.restclient.model.template.ITemplate;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.openshift.core.connection.Connection;
import org.jboss.tools.openshift.internal.common.ui.OpenShiftCommonImages;
import org.jboss.tools.openshift.internal.common.ui.explorer.BaseExplorerLabelProvider;
import org.jboss.tools.openshift.internal.ui.OpenShiftImages;
import org.jboss.tools.openshift.internal.ui.explorer.ResourceGrouping;

public class OpenShiftExplorerLabelProvider
extends BaseExplorerLabelProvider {
    public String getText(Object element) {
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            String name = project.getName();
            if (StringUtils.isNotEmpty((String)project.getDisplayName())) {
                name = String.valueOf(project.getDisplayName()) + " (" + name + ")";
            }
            return name;
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        block20: {
            if (element instanceof ResourceGrouping) {
                return OpenShiftCommonImages.FOLDER;
            }
            if (!(element instanceof IResource)) break block20;
            IResource resource = (IResource)element;
            switch (resource.getKind()) {
                case "BuildConfig": {
                    return OpenShiftImages.BUILDCONFIG_IMG;
                }
                case "ImageStream": {
                    return OpenShiftImages.LAYER_IMG;
                }
                case "Pod": {
                    return OpenShiftImages.BLOCKS_IMG;
                }
                case "Project": {
                    return OpenShiftCommonImages.GLOBE_IMG;
                }
                case "Service": {
                    return OpenShiftImages.GEAR_IMG;
                }
            }
            return OpenShiftCommonImages.FILE;
        }
        return super.getImage(element);
    }

    public StyledString getStyledText(Object element) {
        block36: {
            if (!(element instanceof IResource)) break block36;
            IResource resource = (IResource)element;
            switch (resource.getKind()) {
                case "Build": {
                    return this.getStyledText((IBuild)resource);
                }
                case "BuildConfig": {
                    return this.getStyledText((IBuildConfig)resource);
                }
                case "DeploymentConfig": {
                    return this.getStyledText((IDeploymentConfig)resource);
                }
                case "ImageStream": {
                    return this.getStyledText((IImageStream)resource);
                }
                case "Pod": {
                    return this.getStyledText((IPod)resource);
                }
                case "Project": {
                    return this.getStyledText((IProject)element);
                }
                case "Route": {
                    return this.getStyledText((IRoute)resource);
                }
                case "ReplicationController": {
                    return this.getStyledText((IReplicationController)resource);
                }
                case "Service": {
                    IService service = (IService)resource;
                    return this.getStyledText(service);
                }
                case "Template": {
                    return this.getStyledText((ITemplate)element);
                }
            }
        }
        if (element instanceof ResourceGrouping) {
            return this.getStyledText((ResourceGrouping)element);
        }
        if (element instanceof Connection) {
            return this.getStyledText((Connection)element);
        }
        return super.getStyledText(element);
    }

    private StyledString getStyledText(IService service) {
        String serviceQualifiedText = String.format("selector: %s", org.jboss.tools.openshift.common.core.utils.StringUtils.serialize((Map)service.getSelector()));
        return this.style(service.getName(), serviceQualifiedText);
    }

    private StyledString getStyledText(IReplicationController replicationController) {
        return this.style(replicationController.getName(), String.format("selector: %s", org.jboss.tools.openshift.common.core.utils.StringUtils.serialize((Map)replicationController.getReplicaSelector())));
    }

    private StyledString getStyledText(IRoute route) {
        return this.style(route.getName(), String.format("%s%s", route.getHost(), route.getPath()));
    }

    private StyledString getStyledText(IBuild build) {
        return this.style(build.getName(), build.getStatus());
    }

    private StyledString getStyledText(IBuildConfig config) {
        return this.style(config.getName(), config.getSourceURI());
    }

    private StyledString getStyledText(IDeploymentConfig config) {
        return this.style(config.getName(), String.format("selector: %s", org.jboss.tools.openshift.common.core.utils.StringUtils.serialize((Map)config.getReplicaSelector())));
    }

    private StyledString getStyledText(IPod pod) {
        return this.style(pod.getName(), pod.getStatus());
    }

    private StyledString getStyledText(IImageStream repo) {
        return this.style(repo.getName(), repo.getDockerImageRepository().toString());
    }

    private StyledString getStyledText(Connection conn) {
        String prefix = StringUtils.defaultIfBlank((String)conn.getUsername(), (String)"<unknown user>");
        if (prefix == null) {
            prefix = "<unknown user>";
        }
        return this.style(prefix, conn.toString());
    }

    private StyledString getStyledText(ResourceGrouping grouping) {
        return new StyledString(org.jboss.tools.openshift.common.core.utils.StringUtils.humanize((String)(String.valueOf(grouping.getKind()) + "s")));
    }

    private StyledString getStyledText(ITemplate template) {
        String tags = (String)template.accept((CapabilityVisitor)new CapabilityVisitor<ITags, Object>(){

            public Object visit(ITags capability) {
                return NLS.bind((String)"({0})", (Object)StringUtils.join((Collection)capability.getTags(), (String)", "));
            }
        }, null);
        return this.style(template.getName(), tags);
    }

    private StyledString getStyledText(IProject project) {
        if (StringUtils.isNotBlank((String)project.getDisplayName())) {
            return this.style(project.getDisplayName(), project.getName());
        }
        return this.style(project.getName(), "");
    }

    private StyledString style(String baseText, String qualifiedText) {
        StyledString value = new StyledString(baseText);
        if (StringUtils.isNotBlank((String)qualifiedText)) {
            value.append(" ").append(qualifiedText, StyledString.QUALIFIER_STYLER);
        }
        return value;
    }
}

