/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.openshift.internal.ui.dialog;

import com.openshift.restclient.model.route.IRoute;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.jboss.tools.openshift.internal.common.ui.OpenShiftCommonImages;

public class SelectRouteDialog
extends ElementListSelectionDialog {
    public SelectRouteDialog(List<IRoute> routes, Shell shell) {
        super(shell, (ILabelProvider)new RouteLabelProvider());
        this.setTitle("Select Route");
        this.setMessage("Select the route to open in a browser.");
        this.setMultipleSelection(false);
        this.setAllowDuplicates(false);
        this.setElements(routes.toArray());
    }

    public IRoute getSelectedRoute() {
        Object[] results = this.getResult();
        if (results == null || results.length < 1) {
            return null;
        }
        return (IRoute)results[0];
    }

    private static class RouteLabelProvider
    extends LabelProvider {
        private RouteLabelProvider() {
        }

        public Image getImage(Object element) {
            return OpenShiftCommonImages.FILE;
        }

        public String getText(Object element) {
            if (!(element instanceof IRoute)) {
                return null;
            }
            IRoute route = (IRoute)element;
            return route.getName() + " (" + route.getHost() + route.getPath() + ")";
        }
    }
}

