/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ios.core.xcode;

import com.dd.plist.ASCIIPropertyListParser;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import com.dd.plist.PropertyListParser;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.config.ImageResourceBase;
import org.eclipse.thym.core.config.Splash;
import org.eclipse.thym.core.config.Widget;
import org.eclipse.thym.core.config.WidgetModel;
import org.eclipse.thym.core.engine.HybridMobileLibraryResolver;
import org.eclipse.thym.core.platform.AbstractProjectGeneratorDelegate;
import org.eclipse.thym.ios.core.IOSCore;
import org.eclipse.thym.ios.core.xcode.XCodeProjectUtils;

public class XcodeProjectGenerator
extends AbstractProjectGeneratorDelegate {
    public XcodeProjectGenerator() {
    }

    public XcodeProjectGenerator(IProject project, File generationFolder, String platform) {
        this.init(project, generationFolder, platform);
    }

    protected void generateNativeFiles(HybridMobileLibraryResolver resolver) throws CoreException {
        try {
            HybridProject hybridProject = HybridProject.getHybridProject((IProject)this.getProject());
            if (hybridProject == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.ios.core", "Not a hybrid mobile project, can not generate files"));
            }
            File destinationDir = this.getDestination();
            Path destinationPath = new Path(destinationDir.toString());
            String name = hybridProject.getBuildArtifactAppName();
            IPath prjPath = destinationPath.append(name);
            Widget widgetModel = WidgetModel.getModel((HybridProject)hybridProject).getWidgetForRead();
            String packageName = widgetModel.getId();
            File prjdir = prjPath.toFile();
            if (!prjdir.exists()) {
                prjdir.mkdirs();
            }
            org.eclipse.thym.core.internal.util.FileUtils.directoryCopy((URL)resolver.getTemplateFile((IPath)new Path("$appname")), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)prjdir));
            FileUtils.deleteQuietly((File)new File(prjdir, "__PROJECT_NAME__-Info.plist"));
            FileUtils.deleteQuietly((File)new File(prjdir, "__PROJECT_NAME__-Prefix.pch"));
            this.handleIcons(widgetModel, hybridProject);
            this.handleSplashScreens(widgetModel, hybridProject);
            IPath cordovaScriptPath = destinationPath.append("cordova");
            org.eclipse.thym.core.internal.util.FileUtils.directoryCopy((URL)resolver.getTemplateFile(cordovaScriptPath.makeRelativeTo((IPath)destinationPath)), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)cordovaScriptPath.toFile()));
            IPath nodeModules = cordovaScriptPath.append("node_modules");
            org.eclipse.thym.core.internal.util.FileUtils.directoryCopy((URL)resolver.getTemplateFile(nodeModules.makeRelativeTo((IPath)destinationPath)), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)nodeModules.toFile()));
            File wwwwCopyScript = cordovaScriptPath.append("lib").append("copy-www-build-step.sh").toFile();
            if (wwwwCopyScript.exists()) {
                wwwwCopyScript.setExecutable(true);
            }
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("__TESTING__", name);
            values.put("__PROJECT_NAME__", name);
            values.put("--ID--", packageName);
            IPath templatePath = prjPath.append(String.valueOf(name) + "-Info.plist");
            org.eclipse.thym.core.internal.util.FileUtils.templatedFileCopy((URL)resolver.getTemplateFile((IPath)new Path("$appname/$appname-Info.plist")), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)templatePath.toFile()), values);
            templatePath = prjPath.append(String.valueOf(name) + "-Prefix.pch");
            org.eclipse.thym.core.internal.util.FileUtils.templatedFileCopy((URL)resolver.getTemplateFile((IPath)new Path("$appname/$appname-Prefix.pch")), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)templatePath.toFile()), values);
            IPath xcodeprojDirPath = destinationPath.append(String.valueOf(name) + ".xcodeproj");
            File xcodeDir = xcodeprojDirPath.toFile();
            if (!xcodeDir.exists()) {
                xcodeDir.mkdir();
            }
            IPath xcodeprojectFilePath = xcodeprojDirPath.append("project.pbxproj");
            File xcodeprojectFile = xcodeprojectFilePath.toFile();
            org.eclipse.thym.core.internal.util.FileUtils.templatedFileCopy((URL)resolver.getTemplateFile((IPath)new Path("$appname.xcodeproj/project.pbxproj")), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)xcodeprojectFile), values);
            IPath classesPath = prjPath.append("Classes");
            templatePath = classesPath.append("AppDelegate.h");
            org.eclipse.thym.core.internal.util.FileUtils.templatedFileCopy((URL)resolver.getTemplateFile((IPath)new Path("$appname/Classes/AppDelegate.h")), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)templatePath.toFile()), values);
            templatePath = classesPath.append("AppDelegate.m");
            org.eclipse.thym.core.internal.util.FileUtils.templatedFileCopy((URL)resolver.getTemplateFile((IPath)new Path("$appname/Classes/AppDelegate.m")), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)templatePath.toFile()), values);
            templatePath = classesPath.append("MainViewController.h");
            org.eclipse.thym.core.internal.util.FileUtils.templatedFileCopy((URL)resolver.getTemplateFile((IPath)new Path("$appname/Classes/MainViewController.h")), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)templatePath.toFile()), values);
            templatePath = classesPath.append("MainViewController.m");
            org.eclipse.thym.core.internal.util.FileUtils.templatedFileCopy((URL)resolver.getTemplateFile((IPath)new Path("$appname/Classes/MainViewController.m")), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)templatePath.toFile()), values);
            templatePath = prjPath.append("main.m");
            org.eclipse.thym.core.internal.util.FileUtils.templatedFileCopy((URL)resolver.getTemplateFile((IPath)new Path("$appname/main.m")), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)templatePath.toFile()), values);
            IPath cordovaLibDirectory = this.getCordovaLibPath();
            org.eclipse.thym.core.internal.util.FileUtils.directoryCopy((URL)resolver.getTemplateFile((IPath)new Path("CordovaLib")), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)cordovaLibDirectory.toFile()));
            this.updateCordovaSubProjectPath(xcodeprojectFile, "CordovaLib/CordovaLib.xcodeproj", "<group>");
            File configxml = hybridProject.getConfigFile().getLocation().toFile();
            org.eclipse.thym.core.internal.util.FileUtils.fileCopy((URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)configxml), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)new File(prjdir, "/config.xml")));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.ios.core", "Error generating the native iOS project", (Throwable)e));
        }
    }

    private void handleSplashScreens(Widget widget, HybridProject hybridProject) throws CoreException {
        List splashes = widget.getSplashes();
        if (splashes == null || splashes.isEmpty()) {
            return;
        }
        PlatformSplash[] platformSplashes = this.getPlatformSplashes();
        File platformHome = new File(this.getDestination(), hybridProject.getBuildArtifactAppName());
        block2: for (Splash splash : splashes) {
            if (!splash.getPlatform().equals(this.getTargetShortName())) continue;
            IFile splashFile = hybridProject.getProject().getFile(splash.getSrc());
            if (!splashFile.exists()) {
                IOSCore.log(4, NLS.bind((String)"Missing splash image {0}", (Object)splash.getSrc()), null);
                continue;
            }
            PlatformSplash[] platformSplashArray = platformSplashes;
            int n = platformSplashes.length;
            int n2 = 0;
            while (n2 < n) {
                PlatformSplash platformSplash = platformSplashArray[n2];
                if (splash.getHeight() == platformSplash.height && splash.getWidth() == platformSplash.width) {
                    try {
                        org.eclipse.thym.core.internal.util.FileUtils.fileCopy((URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)splashFile.getLocation().toFile()), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)new File(platformHome, platformSplash.fileName)));
                        continue block2;
                    }
                    catch (IOException e) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.ios.core", "Error whiile processing iOS splash screens", (Throwable)e));
                    }
                }
                ++n2;
            }
        }
    }

    private PlatformSplash[] getPlatformSplashes() {
        return new PlatformSplash[]{new PlatformSplash("Resources/splash/Default~iphone.png", 320, 480), new PlatformSplash("Resources/splash/Default@2x~iphone.png", 640, 960), new PlatformSplash("Resources/splash/Default-Portrait~ipad.png", 768, 1024), new PlatformSplash("Resources/splash/Default-Portrait@2x~ipad.png", 1536, 2048), new PlatformSplash("Resources/splash/Default-Landscape~ipad.png", 1024, 768), new PlatformSplash("Resources/splash/Default-Landscape@2x~ipad.png", 2048, 1536), new PlatformSplash("Resources/splash/Default-568h@2x~iphone.png", 640, 1136), new PlatformSplash("Resources/splash/Default-667h.png", 750, 1334), new PlatformSplash("Resources/splash/Default-736h.png", 1242, 2208), new PlatformSplash("Resources/splash/Default-Landscape-736h.png", 2208, 1242)};
    }

    private void handleIcons(Widget widgetModel, HybridProject project) throws CoreException {
        List icons = widgetModel.getIcons();
        if (icons == null || icons.isEmpty()) {
            return;
        }
        Map<Integer, String> platformIcons = this.getPlatformIcons();
        ImageResourceBase defaultIcon = null;
        File iconsDir = new File(this.getDestination(), String.valueOf(project.getBuildArtifactAppName()) + "/Resources/icons");
        try {
            for (ImageResourceBase icon : icons) {
                if (icon.isDefault()) {
                    defaultIcon = icon;
                    continue;
                }
                if (!icon.getPlatform().equals(this.getTargetShortName())) continue;
                IFile iconFile = project.getProject().getFile(icon.getSrc());
                if (!iconFile.exists()) {
                    IOSCore.log(4, NLS.bind((String)"Missing icon file {0}", (Object)icon.getSrc()), null);
                    continue;
                }
                Integer size = Math.max(icon.getHeight(), icon.getWidth());
                String destinationPath = platformIcons.get(size);
                if (destinationPath == null) continue;
                org.eclipse.thym.core.internal.util.FileUtils.fileCopy((URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)iconFile.getLocation().toFile()), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)new File(iconsDir, destinationPath)));
                platformIcons.remove(size);
            }
            if (defaultIcon != null) {
                IFile iconFile = project.getProject().getFile(defaultIcon.getSrc());
                if (!iconFile.exists()) {
                    IOSCore.log(4, NLS.bind((String)"Missing icon file {0}", (Object)defaultIcon.getSrc()), null);
                } else {
                    Collection<String> remaing = platformIcons.values();
                    for (String string : remaing) {
                        org.eclipse.thym.core.internal.util.FileUtils.fileCopy((URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)iconFile.getLocation().toFile()), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)new File(iconsDir, string)));
                    }
                }
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.ios.core", "Error whiile processing iOS icons", (Throwable)e));
        }
    }

    private Map<Integer, String> getPlatformIcons() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(60, "icon-60.png");
        map.put(120, "icon-60@2x.png");
        map.put(180, "icon-60@3x.png");
        map.put(76, "icon-76.png");
        map.put(152, "icon-76@2x.png");
        map.put(29, "icon-small.png");
        map.put(58, "icon-small@2x.png");
        map.put(40, "icon-40.png");
        map.put(80, "icon-40@2x.png");
        map.put(57, "icon.png");
        map.put(114, "icon@2x.png");
        map.put(72, "icon-72.png");
        map.put(144, "icon-72@2x.png");
        map.put(50, "icon-50.png");
        map.put(100, "icon-50@2x.png");
        return map;
    }

    private void updateCordovaSubProjectPath(File pbxprojfile, String path, String sourcetree) throws CoreException {
        try {
            NSDictionary dict = (NSDictionary)ASCIIPropertyListParser.parse((File)pbxprojfile);
            NSDictionary objects = (NSDictionary)dict.objectForKey("objects");
            HashMap hashmap = objects.getHashMap();
            Collection values = hashmap.values();
            for (NSObject nsObject : values) {
                NSDictionary obj = (NSDictionary)nsObject;
                NSString isa = (NSString)obj.objectForKey("isa");
                NSString pathObj = (NSString)obj.objectForKey("path");
                if (isa == null || !isa.getContent().equals("PBXFileReference") || path == null || !pathObj.getContent().contains("CordovaLib.xcodeproj")) continue;
                obj.remove("path");
                obj.put("path", path);
                obj.remove("sourceTree");
                obj.put("sourceTree", sourcetree);
                if (!obj.containsKey("name")) {
                    obj.put("name", "CordovaLib.xcodeproj");
                }
                PropertyListParser.saveAsASCII((NSDictionary)dict, (File)pbxprojfile);
                break;
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.ios.core", "Error updating CordovaLib subproject", (Throwable)e));
        }
    }

    private IPath getCordovaLibPath() {
        return new Path(this.getDestination().toString()).append("CordovaLib");
    }

    protected void replaceCordovaPlatformFiles(HybridMobileLibraryResolver resolver) throws IOException {
        org.eclipse.thym.core.internal.util.FileUtils.fileCopy((URL)resolver.getTemplateFile(HybridMobileLibraryResolver.PATH_CORDOVA_JS), (URL)org.eclipse.thym.core.internal.util.FileUtils.toURL((File)new File(this.getPlatformWWWDirectory(), "cordova.js")));
    }

    protected File getPlatformWWWDirectory() {
        return XCodeProjectUtils.getPlatformWWWDirectory(this.getDestination());
    }

    private class PlatformSplash {
        int width;
        int height;
        String fileName;

        public PlatformSplash(String file, int w, int h) {
            this.fileName = file;
            this.width = w;
            this.height = h;
        }
    }
}

