/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ios.core.xcode;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.thym.core.plugin.actions.CopyFileAction;
import org.eclipse.thym.ios.core.pbxproject.PBXFile;
import org.eclipse.thym.ios.core.pbxproject.PBXProject;
import org.eclipse.thym.ios.core.pbxproject.PBXProjectException;

public class IOSSourceFileAction
extends CopyFileAction {
    private final boolean isFramework;
    private final String compilerFlags;
    private final File pbxFile;
    private final String path;

    public IOSSourceFileAction(File source, File target, File pbxFile, String path, boolean framework, String compilerFlags) {
        super(source, target);
        this.compilerFlags = compilerFlags;
        this.isFramework = framework;
        this.pbxFile = pbxFile;
        this.path = path;
    }

    public void install() throws CoreException {
        PBXProject project = new PBXProject(this.pbxFile);
        try {
            project.addSourceFile(this.getPBXFile());
            if (this.isFramework) {
                project.addFramework(this.getPBXFile());
                PBXFile searchPath = this.getPBXFile();
                String rawPath = searchPath.getPath();
                Path path = new Path(rawPath);
                path = path.removeFirstSegments(1);
                searchPath.setPath(path.toString());
                project.addToLibrarySearchPaths(searchPath);
            }
            project.persist();
        }
        catch (PBXProjectException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.ios.core", "Error updating XCode project file", (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.ios.core", "Error while saving updated XCode project file", (Throwable)e));
        }
        super.install();
    }

    private PBXFile getPBXFile() {
        PBXFile file = new PBXFile(this.path);
        file.setFramework(this.isFramework);
        if (this.compilerFlags != null && !this.compilerFlags.isEmpty()) {
            file.setCompilerFlags(this.compilerFlags);
        }
        return file;
    }

    public void unInstall() throws CoreException {
        super.unInstall();
    }
}

