/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.TableGenerator;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.SchemaContainer;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.jpt.jpa.ui.details.JptJpaUiDetailsMessages;
import org.eclipse.jpt.jpa.ui.internal.JpaHelpContextIds;
import org.eclipse.jpt.jpa.ui.internal.details.GeneratorComposite;
import org.eclipse.jpt.jpa.ui.internal.details.db.CatalogCombo;
import org.eclipse.jpt.jpa.ui.internal.details.db.ColumnCombo;
import org.eclipse.jpt.jpa.ui.internal.details.db.SchemaCombo;
import org.eclipse.jpt.jpa.ui.internal.details.db.TableCombo;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableGeneratorComposite
extends GeneratorComposite<TableGenerator> {
    static final Collection<String> SCHEMA_PICK_LIST_PROPERTIES = Arrays.asList("defaultCatalog", "specifiedCatalog");
    static final Collection<String> TABLE_PICK_LIST_PROPERTIES = Arrays.asList((String[])ArrayTools.addAll((Object[])SCHEMA_PICK_LIST_PROPERTIES.toArray(new String[0]), (Object[])new String[]{"defaultSchema", "specifiedSchema"}));
    static final Collection<String> COLUMN_PICK_LIST_PROPERTIES = Arrays.asList((String[])ArrayTools.addAll((Object[])TABLE_PICK_LIST_PROPERTIES.toArray(new String[0]), (Object[])new String[]{"defaultTableName", "specifiedTableName"}));

    public TableGeneratorComposite(Pane<?> parentPane, PropertyValueModel<TableGenerator> subjectHolder, Composite parent, GeneratorComposite.GeneratorBuilder<TableGenerator> builder) {
        super(parentPane, subjectHolder, parent, builder);
    }

    @Override
    protected String getPropertyName() {
        return "tableGenerator";
    }

    protected Composite addComposite(Composite container) {
        return this.addSubPane(container, 2, 0, 0, 0, 0);
    }

    protected void initializeLayout(Composite container) {
        this.addLabel(container, JptJpaUiDetailsMessages.TABLE_GENERATOR_COMPOSITE_NAME);
        this.addText(container, this.buildGeneratorNameHolder(), JpaHelpContextIds.MAPPING_TABLE_GENERATOR_NAME);
        this.addLabel(container, JptJpaUiDetailsMessages.TABLE_GENERATOR_COMPOSITE_TABLE);
        this.addTableNameCombo(container);
        this.addLabel(container, JptJpaUiDetailsMessages.TABLE_GENERATOR_COMPOSITE_SCHEMA);
        this.addSchemaCombo(container);
        this.addLabel(container, JptJpaUiDetailsMessages.TABLE_GENERATOR_COMPOSITE_CATALOG);
        this.addCatalogCombo(container);
        this.addLabel(container, JptJpaUiDetailsMessages.TABLE_GENERATOR_COMPOSITE_PK_COLUMN);
        this.addPkColumnCombo(container);
        this.addLabel(container, JptJpaUiDetailsMessages.TABLE_GENERATOR_COMPOSITE_VALUE_COLUMN);
        this.addValueColumnCombo(container);
        this.addLabel(container, JptJpaUiDetailsMessages.TABLE_GENERATOR_COMPOSITE_PK_COLUMN_VALUE);
        this.addPkColumnValueCombo(container);
        this.addLabel(container, JptJpaUiDetailsMessages.GENERATOR_COMPOSITE_ALLOCATION_SIZE);
        this.addAllocationSizeCombo(container);
        this.addLabel(container, JptJpaUiDetailsMessages.GENERATOR_COMPOSITE_INITIAL_VALUE);
        this.addInitialValueCombo(container);
    }

    private CatalogCombo<TableGenerator> addCatalogCombo(Composite container) {
        return new CatalogCombo<TableGenerator>((Pane)this, this.getSubjectHolder(), container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultCatalog");
                propertyNames.add("specifiedCatalog");
            }

            protected String getDefaultValue() {
                return ((TableGenerator)this.getSubject()).getDefaultCatalog();
            }

            protected boolean nullSubjectIsAllowed() {
                return true;
            }

            @Override
            protected JpaProject getJpaProject() {
                return TableGeneratorComposite.this.getJpaProject();
            }

            protected void setValue(String value) {
                ((TableGenerator)TableGeneratorComposite.this.retrieveGenerator()).setSpecifiedCatalog(value);
            }

            protected String getValue() {
                return ((TableGenerator)this.getSubject()).getSpecifiedCatalog();
            }

            protected String getHelpId() {
                return JpaHelpContextIds.MAPPING_TABLE_GENERATOR_CATALOG;
            }
        };
    }

    private ColumnCombo<TableGenerator> addPkColumnCombo(Composite parent) {
        return new ColumnCombo<TableGenerator>((Pane)this, this.getSubjectHolder(), parent){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultPkColumnName");
                propertyNames.add("specifiedPkColumnName");
                propertyNames.addAll(COLUMN_PICK_LIST_PROPERTIES);
            }

            protected void propertyChanged(String propertyName) {
                if (COLUMN_PICK_LIST_PROPERTIES.contains(propertyName)) {
                    this.repopulateComboBox();
                } else {
                    super.propertyChanged(propertyName);
                }
            }

            protected String getDefaultValue() {
                return ((TableGenerator)this.getSubject()).getDefaultPkColumnName();
            }

            protected boolean nullSubjectIsAllowed() {
                return true;
            }

            @Override
            protected JpaProject getJpaProject() {
                return TableGeneratorComposite.this.getJpaProject();
            }

            protected void setValue(String value) {
                ((TableGenerator)TableGeneratorComposite.this.retrieveGenerator()).setSpecifiedPkColumnName(value);
            }

            @Override
            protected Table getDbTable_() {
                return ((TableGenerator)this.getSubject()).getDbTable();
            }

            protected String getValue() {
                return ((TableGenerator)this.getSubject()).getSpecifiedPkColumnName();
            }

            protected String getHelpId() {
                return JpaHelpContextIds.MAPPING_TABLE_GENERATOR_PRIMARY_KEY_COLUMN;
            }
        };
    }

    private ColumnCombo<TableGenerator> addPkColumnValueCombo(Composite parent) {
        return new ColumnCombo<TableGenerator>((Pane)this, this.getSubjectHolder(), parent){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultPkColummValue");
                propertyNames.add("specifiedPkColummValue");
            }

            protected String getDefaultValue() {
                return ((TableGenerator)this.getSubject()).getDefaultPkColumnValue();
            }

            protected boolean nullSubjectIsAllowed() {
                return true;
            }

            @Override
            protected JpaProject getJpaProject() {
                return TableGeneratorComposite.this.getJpaProject();
            }

            protected void setValue(String value) {
                ((TableGenerator)TableGeneratorComposite.this.retrieveGenerator()).setSpecifiedPkColumnValue(value);
            }

            @Override
            protected Table getDbTable_() {
                return ((TableGenerator)this.getSubject()).getDbTable();
            }

            protected String getValue() {
                return ((TableGenerator)this.getSubject()).getSpecifiedPkColumnValue();
            }

            protected String getHelpId() {
                return JpaHelpContextIds.MAPPING_TABLE_GENERATOR_PRIMARY_KEY_COLUMN_VALUE;
            }
        };
    }

    private SchemaCombo<TableGenerator> addSchemaCombo(Composite container) {
        return new SchemaCombo<TableGenerator>((Pane)this, this.getSubjectHolder(), container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultSchema");
                propertyNames.add("specifiedSchema");
                propertyNames.addAll(SCHEMA_PICK_LIST_PROPERTIES);
            }

            protected void propertyChanged(String propertyName) {
                if (SCHEMA_PICK_LIST_PROPERTIES.contains(propertyName)) {
                    this.repopulateComboBox();
                } else {
                    super.propertyChanged(propertyName);
                }
            }

            protected String getDefaultValue() {
                return ((TableGenerator)this.getSubject()).getDefaultSchema();
            }

            protected boolean nullSubjectIsAllowed() {
                return true;
            }

            @Override
            protected JpaProject getJpaProject() {
                return TableGeneratorComposite.this.getJpaProject();
            }

            protected void setValue(String value) {
                ((TableGenerator)TableGeneratorComposite.this.retrieveGenerator()).setSpecifiedSchema(value);
            }

            protected String getValue() {
                return ((TableGenerator)this.getSubject()).getSpecifiedSchema();
            }

            @Override
            protected SchemaContainer getDbSchemaContainer() {
                TableGenerator tg = (TableGenerator)this.getSubject();
                if (tg != null) {
                    return tg.getDbSchemaContainer();
                }
                return ((TableGenerator)TableGeneratorComposite.this.getSubject()).getContextDefaultDbSchemaContainer();
            }

            @Override
            protected SchemaContainer getDbSchemaContainer_() {
                throw new UnsupportedOperationException();
            }

            protected String getHelpId() {
                return JpaHelpContextIds.MAPPING_TABLE_GENERATOR_SCHEMA;
            }
        };
    }

    private TableCombo<TableGenerator> addTableNameCombo(Composite parent) {
        return new TableCombo<TableGenerator>((Pane)this, this.getSubjectHolder(), parent){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultTableName");
                propertyNames.add("specifiedTableName");
                propertyNames.addAll(TABLE_PICK_LIST_PROPERTIES);
            }

            protected void propertyChanged(String propertyName) {
                if (TABLE_PICK_LIST_PROPERTIES.contains(propertyName)) {
                    this.repopulateComboBox();
                } else {
                    super.propertyChanged(propertyName);
                }
            }

            protected String getDefaultValue() {
                return ((TableGenerator)this.getSubject()).getDefaultTableName();
            }

            protected boolean nullSubjectIsAllowed() {
                return true;
            }

            @Override
            protected JpaProject getJpaProject() {
                return TableGeneratorComposite.this.getJpaProject();
            }

            protected void setValue(String value) {
                ((TableGenerator)TableGeneratorComposite.this.retrieveGenerator()).setSpecifiedTableName(value);
            }

            protected String getValue() {
                return ((TableGenerator)this.getSubject()).getSpecifiedTableName();
            }

            @Override
            protected Schema getDbSchema() {
                TableGenerator tg = (TableGenerator)this.getSubject();
                if (tg != null) {
                    return tg.getDbSchema();
                }
                return ((TableGenerator)TableGeneratorComposite.this.getSubject()).getContextDefaultDbSchema();
            }

            @Override
            protected Schema getDbSchema_() {
                throw new UnsupportedOperationException();
            }

            protected String getHelpId() {
                return JpaHelpContextIds.MAPPING_TABLE_GENERATOR_TABLE;
            }
        };
    }

    private ColumnCombo<TableGenerator> addValueColumnCombo(Composite parent) {
        return new ColumnCombo<TableGenerator>((Pane)this, this.getSubjectHolder(), parent){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultValueColumnName");
                propertyNames.add("specifiedValueColumnName");
                propertyNames.addAll(COLUMN_PICK_LIST_PROPERTIES);
            }

            protected void propertyChanged(String propertyName) {
                if (COLUMN_PICK_LIST_PROPERTIES.contains(propertyName)) {
                    this.repopulateComboBox();
                } else {
                    super.propertyChanged(propertyName);
                }
            }

            protected String getDefaultValue() {
                return ((TableGenerator)this.getSubject()).getDefaultValueColumnName();
            }

            protected boolean nullSubjectIsAllowed() {
                return true;
            }

            @Override
            protected JpaProject getJpaProject() {
                return TableGeneratorComposite.this.getJpaProject();
            }

            protected void setValue(String value) {
                ((TableGenerator)TableGeneratorComposite.this.retrieveGenerator()).setSpecifiedValueColumnName(value);
            }

            @Override
            protected Table getDbTable_() {
                return ((TableGenerator)this.getSubject()).getDbTable();
            }

            protected String getValue() {
                return ((TableGenerator)this.getSubject()).getSpecifiedValueColumnName();
            }

            protected String getHelpId() {
                return JpaHelpContextIds.MAPPING_TABLE_GENERATOR_VALUE_COLUMN;
            }
        };
    }
}

