/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.provisional;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.ApiDescriptionManager;
import org.eclipse.pde.api.tools.internal.JavadocTagManager;
import org.eclipse.pde.api.tools.internal.SessionManager;
import org.eclipse.pde.api.tools.internal.WorkspaceDeltaProcessor;
import org.eclipse.pde.api.tools.internal.provisional.IApiBaselineManager;
import org.eclipse.pde.api.tools.internal.provisional.ISessionManager;
import org.eclipse.pde.api.tools.internal.provisional.problems.IApiProblemTypes;
import org.eclipse.pde.api.tools.internal.util.FileManager;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.core.target.NameVersionDescriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ApiPlugin
extends Plugin
implements ISaveParticipant,
DebugOptionsListener {
    private static final String EE_DESCRIPTION_PREFIX = "org.eclipse.pde.api.tools.ee";
    public static final String EXTENSION_JAVADOC_TAGS = "apiJavadocTags";
    public static final String PLUGIN_ID = "org.eclipse.pde.api.tools";
    public static final String NATURE_ID = "org.eclipse.pde.api.tools.apiAnalysisNature";
    public static final int INTERNAL_ERROR = 120;
    public static final int ERROR = 121;
    public static final int REPORT_RESOLUTION_ERRORS = 122;
    public static final int REPORT_BASELINE_IS_DISPOSED = 123;
    public static final int SEVERITY_IGNORE = 0;
    public static final int SEVERITY_WARNING = 1;
    public static final int SEVERITY_ERROR = 2;
    public static final String VALUE_IGNORE = "Ignore";
    public static final String VALUE_WARNING = "Warning";
    public static final String VALUE_ERROR = "Error";
    public static final String VALUE_DISABLED = "Disabled";
    public static final String VALUE_ENABLED = "Enabled";
    public static final String BUILDER_ID = "org.eclipse.pde.api.tools.apiAnalysisBuilder";
    public static final String KNOWN_EE_FRAGMENTS = "knownEEFragments";
    private static ApiPlugin fgDefault = null;
    private static JavadocTagManager fgTagManager = null;
    private static ISessionManager fgSessionManager = null;
    private BundleContext fBundleContext = null;
    private static boolean DEBUG = false;
    private static final String DEBUG_FLAG = "org.eclipse.pde.api.tools/debug";
    private static final String BUILDER_DEBUG = "org.eclipse.pde.api.tools/debug/builder";
    private static final String DELTA_DEBUG = "org.eclipse.pde.api.tools/debug/delta";
    private static final String SEARCH_DEBUG = "org.eclipse.pde.api.tools/debug/search";
    private static final String CLASSFILE_VISITOR_DEBUG = "org.eclipse.pde.api.tools/debug/classfilevisitor";
    private static final String DESCRIPTOR_FRAMEWORK_DEBUG = "org.eclipse.pde.api.tools/debug/descriptor/framework";
    private static final String TAG_SCANNER_DEBUG = "org.eclipse.pde.api.tools/debug/tagscanner";
    private static final String PLUGIN_WORKSPACE_COMPONENT_DEBUG = "org.eclipse.pde.api.tools/debug/pluginworkspacecomponent";
    private static final String API_PROFILE_MANAGER_DEBUG = "org.eclipse.pde.api.tools/debug/profilemanager";
    private static final String API_FILTER_STORE_DEBUG = "org.eclipse.pde.api.tools/debug/apifilterstore";
    private static final String API_REFERENCE_ANALYZER_DEBUG = "org.eclipse.pde.api.tools/debug/refanalyzer";
    private static final String PROBLEM_DETECTOR_DEBUG = "org.eclipse.pde.api.tools/debug/problemdetector";
    private static final String REFERENCE_RESOLVER_DEBUG = "org.eclipse.pde.api.tools/debug/refresolver";
    private static final String API_DESCRIPTION = "org.eclipse.pde.api.tools/debug/apidescription";
    private static final String WORKSPACE_DELTA_PROCESSOR = "org.eclipse.pde.api.tools/debug/workspacedeltaprocessor";
    private static final String API_ANALYZER_DEBUG = "org.eclipse.pde.api.tools/debug/apianalyzer";
    private static final String USE_REPORT_CONVERTER_DEBUG = "org.eclipse.pde.api.tools/debug/usereportconverter";
    public static boolean DEBUG_USE_REPORT_CONVERTER = false;
    public static boolean DEBUG_SEARCH_ENGINE = false;
    public static boolean DEBUG_TAG_SCANNER = false;
    public static boolean DEBUG_API_COMPARATOR = false;
    public static boolean DEBUG_PROJECT_COMPONENT = false;
    public static boolean DEBUG_ELEMENT_DESCRIPTOR_FRAMEWORK = false;
    public static boolean DEBUG_CLASSFILE_COMPARATOR = false;
    public static boolean DEBUG_REFERENCE_RESOLVER = false;
    public static boolean DEBUG_REFERENCE_EXTRACTOR = false;
    public static boolean DEBUG_REFERENCE_ANALYZER = false;
    public static boolean DEBUG_API_ANALYZER = false;
    public static boolean DEBUG_PROBLEM_DETECTOR = false;
    public static boolean DEBUG_WORKSPACE_DELTA_PROCESSOR = false;
    public static boolean DEBUG_FILTER_STORE = false;
    public static boolean DEBUG_API_DESCRIPTION = false;
    public static boolean DEBUG_BASELINE_MANAGER = false;
    public static boolean DEBUG_BUILDER = false;
    public static String[] AllCompatibilityKeys = new String[]{IApiProblemTypes.API_COMPONENT_REMOVED_TYPE, IApiProblemTypes.API_COMPONENT_REMOVED_API_TYPE, IApiProblemTypes.API_COMPONENT_REMOVED_REEXPORTED_TYPE, IApiProblemTypes.API_COMPONENT_REMOVED_REEXPORTED_API_TYPE, IApiProblemTypes.ANNOTATION_REMOVED_FIELD, IApiProblemTypes.ANNOTATION_REMOVED_METHOD, IApiProblemTypes.ANNOTATION_REMOVED_TYPE_MEMBER, IApiProblemTypes.ANNOTATION_CHANGED_TYPE_CONVERSION, IApiProblemTypes.ANNOTATION_ADDED_METHOD_NO_DEFAULT_VALUE, IApiProblemTypes.INTERFACE_ADDED_FIELD, IApiProblemTypes.INTERFACE_ADDED_METHOD, IApiProblemTypes.INTERFACE_ADDED_RESTRICTIONS, IApiProblemTypes.INTERFACE_ADDED_SUPER_INTERFACE_WITH_METHODS, IApiProblemTypes.INTERFACE_ADDED_TYPE_PARAMETER, IApiProblemTypes.INTERFACE_REMOVED_TYPE_PARAMETER, IApiProblemTypes.INTERFACE_REMOVED_FIELD, IApiProblemTypes.INTERFACE_REMOVED_METHOD, IApiProblemTypes.INTERFACE_REMOVED_TYPE_MEMBER, IApiProblemTypes.INTERFACE_CHANGED_TYPE_CONVERSION, IApiProblemTypes.INTERFACE_CHANGED_CONTRACTED_SUPERINTERFACES_SET, IApiProblemTypes.ENUM_CHANGED_CONTRACTED_SUPERINTERFACES_SET, IApiProblemTypes.ENUM_CHANGED_TYPE_CONVERSION, IApiProblemTypes.ENUM_REMOVED_FIELD, IApiProblemTypes.ENUM_REMOVED_ENUM_CONSTANT, IApiProblemTypes.ENUM_REMOVED_METHOD, IApiProblemTypes.ENUM_REMOVED_TYPE_MEMBER, IApiProblemTypes.CLASS_ADDED_METHOD, IApiProblemTypes.CLASS_ADDED_RESTRICTIONS, IApiProblemTypes.CLASS_ADDED_TYPE_PARAMETER, IApiProblemTypes.CLASS_CHANGED_CONTRACTED_SUPERINTERFACES_SET, IApiProblemTypes.CLASS_CHANGED_NON_ABSTRACT_TO_ABSTRACT, IApiProblemTypes.CLASS_CHANGED_NON_FINAL_TO_FINAL, IApiProblemTypes.CLASS_CHANGED_TYPE_CONVERSION, IApiProblemTypes.CLASS_CHANGED_DECREASE_ACCESS, IApiProblemTypes.CLASS_REMOVED_FIELD, IApiProblemTypes.CLASS_REMOVED_METHOD, IApiProblemTypes.CLASS_REMOVED_CONSTRUCTOR, IApiProblemTypes.CLASS_REMOVED_SUPERCLASS, IApiProblemTypes.CLASS_REMOVED_TYPE_MEMBER, IApiProblemTypes.CLASS_REMOVED_TYPE_PARAMETER, IApiProblemTypes.FIELD_ADDED_VALUE, IApiProblemTypes.FIELD_CHANGED_TYPE, IApiProblemTypes.FIELD_CHANGED_VALUE, IApiProblemTypes.FIELD_CHANGED_DECREASE_ACCESS, IApiProblemTypes.FIELD_CHANGED_FINAL_TO_NON_FINAL_STATIC_CONSTANT, IApiProblemTypes.FIELD_CHANGED_NON_FINAL_TO_FINAL, IApiProblemTypes.FIELD_CHANGED_STATIC_TO_NON_STATIC, IApiProblemTypes.FIELD_CHANGED_NON_STATIC_TO_STATIC, IApiProblemTypes.FIELD_REMOVED_VALUE, IApiProblemTypes.FIELD_REMOVED_TYPE_ARGUMENT, IApiProblemTypes.METHOD_ADDED_RESTRICTIONS, IApiProblemTypes.METHOD_ADDED_TYPE_PARAMETER, IApiProblemTypes.METHOD_CHANGED_VARARGS_TO_ARRAY, IApiProblemTypes.METHOD_CHANGED_DECREASE_ACCESS, IApiProblemTypes.METHOD_CHANGED_NON_ABSTRACT_TO_ABSTRACT, IApiProblemTypes.METHOD_CHANGED_NON_STATIC_TO_STATIC, IApiProblemTypes.METHOD_CHANGED_STATIC_TO_NON_STATIC, IApiProblemTypes.METHOD_CHANGED_NON_FINAL_TO_FINAL, IApiProblemTypes.METHOD_REMOVED_ANNOTATION_DEFAULT_VALUE, IApiProblemTypes.METHOD_REMOVED_TYPE_PARAMETER, IApiProblemTypes.CONSTRUCTOR_ADDED_TYPE_PARAMETER, IApiProblemTypes.CONSTRUCTOR_CHANGED_VARARGS_TO_ARRAY, IApiProblemTypes.CONSTRUCTOR_CHANGED_DECREASE_ACCESS, IApiProblemTypes.CONSTRUCTOR_REMOVED_TYPE_PARAMETER, IApiProblemTypes.TYPE_PARAMETER_ADDED_CLASS_BOUND, IApiProblemTypes.TYPE_PARAMETER_CHANGED_CLASS_BOUND, IApiProblemTypes.TYPE_PARAMETER_REMOVED_CLASS_BOUND, IApiProblemTypes.TYPE_PARAMETER_ADDED_INTERFACE_BOUND, IApiProblemTypes.TYPE_PARAMETER_CHANGED_INTERFACE_BOUND, IApiProblemTypes.TYPE_PARAMETER_REMOVED_INTERFACE_BOUND, IApiProblemTypes.TYPE_PARAMETER_REMOVED_INTERFACE_BOUND, "report_api_breakage_when_major_version_incremented"};
    private HashSet<ISaveParticipant> savelisteners = new HashSet();
    private int logBits = 0;
    private static int LogBits = 0;
    private WorkspaceDeltaProcessor deltaProcessor = null;
    private static final int RESOLUTION_LOG_BIT = 1;
    private static final int BASELINE_DISPOSED_LOG_BIT = 2;

    public ApiPlugin() {
        fgDefault = this;
    }

    public static ApiPlugin getDefault() {
        return fgDefault;
    }

    public static void log(IStatus status) {
        block14: {
            ApiPlugin getDefault;
            block13: {
                getDefault = ApiPlugin.getDefault();
                if (getDefault != null) break block13;
                switch (status.getCode()) {
                    case 122: {
                        if ((LogBits & 1) == 0) {
                            Throwable exception = status.getException();
                            if (exception != null) {
                                exception.printStackTrace();
                            }
                            LogBits |= 1;
                            break;
                        }
                        break block14;
                    }
                    case 123: {
                        if ((LogBits & 2) == 0) {
                            Throwable exception = status.getException();
                            if (exception != null) {
                                exception.printStackTrace();
                            }
                            LogBits |= 2;
                            break;
                        }
                        break block14;
                    }
                    default: {
                        Throwable exception = status.getException();
                        if (exception != null) {
                            exception.printStackTrace();
                            break;
                        }
                        break block14;
                    }
                }
                break block14;
            }
            switch (status.getCode()) {
                case 122: {
                    if ((getDefault.logBits & 1) != 0) break;
                    getDefault.getLog().log(status);
                    getDefault.logBits |= 1;
                    break;
                }
                case 123: {
                    if ((getDefault.logBits & 2) != 0) break;
                    getDefault.getLog().log(status);
                    getDefault.logBits |= 2;
                    break;
                }
                default: {
                    getDefault.getLog().log(status);
                }
            }
        }
    }

    public static void log(Throwable t) {
        ApiPlugin.log(ApiPlugin.newErrorStatus("Error logged from API Tools Core: ", t));
    }

    public static void logErrorMessage(String message) {
        ApiPlugin.log(ApiPlugin.newErrorStatus("Internal message logged from API Tools Core: " + message, null));
    }

    public static IStatus newErrorStatus(String message, Throwable exception) {
        return new Status(4, PLUGIN_ID, 120, message, exception);
    }

    public static boolean isRunningInFramework() {
        return fgDefault != null;
    }

    public IApiBaselineManager getApiBaselineManager() {
        return ApiBaselineManager.getManager();
    }

    public static JavadocTagManager getJavadocTagManager() {
        if (fgTagManager == null) {
            fgTagManager = new JavadocTagManager();
        }
        return fgTagManager;
    }

    public void addSaveParticipant(ISaveParticipant participant) {
        if (participant != null) {
            this.savelisteners.add(participant);
        }
    }

    public void removeSaveParticipant(ISaveParticipant participant) {
        if (participant != null) {
            this.savelisteners.remove(participant);
        }
    }

    public void doneSaving(ISaveContext context) {
        for (ISaveParticipant sp : this.savelisteners) {
            sp.doneSaving(context);
        }
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
        for (ISaveParticipant sp : this.savelisteners) {
            sp.prepareToSave(context);
        }
    }

    public void rollback(ISaveContext context) {
        for (ISaveParticipant sp : this.savelisteners) {
            sp.rollback(context);
        }
    }

    public void saving(ISaveContext context) throws CoreException {
        for (ISaveParticipant sp : this.savelisteners) {
            sp.saving(context);
        }
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        if (node != null) {
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                ApiPlugin.log(e);
            }
        }
    }

    public void start(BundleContext context) throws Exception {
        try {
            super.start(context);
            Hashtable<String, String> props = new Hashtable<String, String>(2);
            props.put("listener.symbolic.name", PLUGIN_ID);
            context.registerService(DebugOptionsListener.class.getName(), (Object)this, props);
        }
        finally {
            ResourcesPlugin.getWorkspace().addSaveParticipant(PLUGIN_ID, (ISaveParticipant)this);
            this.fBundleContext = context;
            this.deltaProcessor = new WorkspaceDeltaProcessor();
            JavaCore.addElementChangedListener((IElementChangedListener)this.deltaProcessor, (int)1);
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.deltaProcessor, 14);
            this.checkForEEDescriptionChanges();
        }
    }

    private void checkForEEDescriptionChanges() {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
        if (node == null) {
            return;
        }
        String knownFragmentsList = node.get(KNOWN_EE_FRAGMENTS, null);
        Bundle[] allFragments = Platform.getFragments((Bundle)this.fBundleContext.getBundle());
        if (allFragments == null) {
            allFragments = new Bundle[]{};
        }
        if (knownFragmentsList == null) {
            String list = this.getListOfEEFragments(allFragments);
            node.put(KNOWN_EE_FRAGMENTS, list);
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                ApiPlugin.log(e);
            }
            return;
        }
        HashSet<NameVersionDescriptor> knownFragments = new HashSet<NameVersionDescriptor>();
        StringTokenizer tokenizer = new StringTokenizer(knownFragmentsList, ";");
        String name = null;
        while (tokenizer.hasMoreTokens()) {
            name = tokenizer.nextToken().trim();
            if (name.length() <= 0 || !tokenizer.hasMoreTokens()) continue;
            knownFragments.add(new NameVersionDescriptor(name, tokenizer.nextToken()));
        }
        boolean mustRebuild = false;
        int i = 0;
        while (i < allFragments.length) {
            if (allFragments[i].getSymbolicName().indexOf(EE_DESCRIPTION_PREFIX) >= 0) {
                NameVersionDescriptor current = new NameVersionDescriptor(allFragments[i].getSymbolicName(), allFragments[i].getVersion().toString());
                if (knownFragments.contains(current)) {
                    knownFragments.remove(current);
                } else {
                    mustRebuild = true;
                    break;
                }
            }
            ++i;
        }
        if (knownFragments.size() > 0) {
            mustRebuild = true;
        }
        if (mustRebuild) {
            IProject[] projects = Util.getApiProjects();
            if (projects != null) {
                int i2 = 0;
                while (i2 < projects.length) {
                    try {
                        projects[i2].build(6, BUILDER_ID, null, null);
                    }
                    catch (CoreException e) {
                        ApiPlugin.log(e.getStatus());
                    }
                    ++i2;
                }
            }
            String list = this.getListOfEEFragments(allFragments);
            node.put(KNOWN_EE_FRAGMENTS, list);
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                ApiPlugin.log(e);
            }
        }
    }

    private String getListOfEEFragments(Bundle[] allFragments) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < allFragments.length) {
            if (allFragments[i].getSymbolicName().indexOf(EE_DESCRIPTION_PREFIX) >= 0) {
                result.append(allFragments[i].getSymbolicName());
                result.append(';');
                result.append(allFragments[i].getVersion().toString());
                result.append(';');
            }
            ++i;
        }
        return result.toString();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            ApiDescriptionManager.shutdown();
            ApiBaselineManager.getManager().stop();
            ResourcesPlugin.getWorkspace().removeSaveParticipant(PLUGIN_ID);
            FileManager.getManager().deleteFiles();
            this.fBundleContext = null;
            if (this.deltaProcessor != null) {
                JavaCore.removeElementChangedListener((IElementChangedListener)this.deltaProcessor);
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.deltaProcessor);
            }
        }
        finally {
            super.stop(context);
        }
    }

    public int getSeverityLevel(String prefkey, IProject project) {
        IPreferencesService service = Platform.getPreferencesService();
        IScopeContext[] context = null;
        context = this.hasProjectSettings(project) ? new IScopeContext[]{new ProjectScope(project), InstanceScope.INSTANCE, DefaultScope.INSTANCE} : new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
        String value = service.get(prefkey, null, (Preferences[])this.getPreferences(context));
        if (VALUE_ERROR.equals(value)) {
            return 2;
        }
        if (VALUE_WARNING.equals(value)) {
            return 1;
        }
        return 0;
    }

    IEclipsePreferences[] getPreferences(IScopeContext[] context) {
        if (context != null) {
            ArrayList<IEclipsePreferences> nodes = new ArrayList<IEclipsePreferences>(context.length);
            IEclipsePreferences node = null;
            int i = 0;
            while (i < context.length) {
                node = context[i].getNode(PLUGIN_ID);
                if (node != null) {
                    nodes.add(node);
                }
                ++i;
            }
            if (nodes.size() > 0) {
                return nodes.toArray(new IEclipsePreferences[nodes.size()]);
            }
        }
        return null;
    }

    boolean hasProjectSettings(IProject project) {
        if (project != null) {
            ProjectScope scope = new ProjectScope(project);
            IEclipsePreferences node = scope.getNode(PLUGIN_ID);
            try {
                return node != null && node.keys().length > 0;
            }
            catch (BackingStoreException bse) {
                ApiPlugin.log(bse);
            }
        }
        return false;
    }

    public ISessionManager getSessionManager() {
        if (fgSessionManager == null) {
            fgSessionManager = new SessionManager();
        }
        return fgSessionManager;
    }

    public boolean getEnableState(String prefkey, IProject project) {
        IPreferencesService service = Platform.getPreferencesService();
        IScopeContext[] context = null;
        context = this.hasProjectSettings(project) ? new IScopeContext[]{new ProjectScope(project), InstanceScope.INSTANCE, DefaultScope.INSTANCE} : new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
        String value = service.get(prefkey, null, (Preferences[])this.getPreferences(context));
        return VALUE_ENABLED.equals(value);
    }

    public Object acquireService(String serviceName) {
        ServiceReference reference = this.fBundleContext.getServiceReference(serviceName);
        if (reference == null) {
            return null;
        }
        return this.fBundleContext.getService(reference);
    }

    public void optionsChanged(DebugOptions options) {
        DEBUG = options.getBooleanOption(DEBUG_FLAG, false);
        boolean option = options.getBooleanOption(DELTA_DEBUG, false);
        DEBUG_API_COMPARATOR = DEBUG_CLASSFILE_COMPARATOR = DEBUG && option;
        DEBUG_BUILDER = DEBUG && options.getBooleanOption(BUILDER_DEBUG, false);
        DEBUG_SEARCH_ENGINE = DEBUG && options.getBooleanOption(SEARCH_DEBUG, false);
        DEBUG_REFERENCE_EXTRACTOR = DEBUG && options.getBooleanOption(CLASSFILE_VISITOR_DEBUG, false);
        DEBUG_ELEMENT_DESCRIPTOR_FRAMEWORK = DEBUG && options.getBooleanOption(DESCRIPTOR_FRAMEWORK_DEBUG, false);
        DEBUG_TAG_SCANNER = DEBUG && options.getBooleanOption(TAG_SCANNER_DEBUG, false);
        DEBUG_PROJECT_COMPONENT = DEBUG && options.getBooleanOption(PLUGIN_WORKSPACE_COMPONENT_DEBUG, false);
        DEBUG_BASELINE_MANAGER = DEBUG && options.getBooleanOption(API_PROFILE_MANAGER_DEBUG, false);
        DEBUG_FILTER_STORE = DEBUG && options.getBooleanOption(API_FILTER_STORE_DEBUG, false);
        DEBUG_REFERENCE_ANALYZER = DEBUG && options.getBooleanOption(API_REFERENCE_ANALYZER_DEBUG, false);
        DEBUG_REFERENCE_RESOLVER = DEBUG && options.getBooleanOption(REFERENCE_RESOLVER_DEBUG, false);
        DEBUG_PROBLEM_DETECTOR = DEBUG && options.getBooleanOption(PROBLEM_DETECTOR_DEBUG, false);
        DEBUG_API_DESCRIPTION = DEBUG && options.getBooleanOption(API_DESCRIPTION, false);
        DEBUG_WORKSPACE_DELTA_PROCESSOR = DEBUG && options.getBooleanOption(WORKSPACE_DELTA_PROCESSOR, false);
        DEBUG_API_ANALYZER = DEBUG && options.getBooleanOption(API_ANALYZER_DEBUG, false);
        DEBUG_USE_REPORT_CONVERTER = DEBUG && options.getBooleanOption(USE_REPORT_CONVERTER_DEBUG, false);
    }
}

