/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.model.ApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;

public abstract class ApiMember
extends ApiElement
implements IApiMember {
    private int fFlags = -1;
    private String fSignature;
    private String fGenericSignature;

    protected ApiMember(IApiElement parent, String name, String signature, String genericSig, int type, int flags) {
        super(parent, type, name);
        this.fFlags = flags;
        this.fSignature = signature;
        this.fGenericSignature = genericSig;
    }

    @Override
    public String getSignature() {
        return this.fSignature;
    }

    @Override
    public String getGenericSignature() {
        return this.fGenericSignature;
    }

    @Override
    public int getModifiers() {
        return this.fFlags;
    }

    @Override
    public IApiType getEnclosingType() throws CoreException {
        return (IApiType)this.getAncestor(2);
    }

    @Override
    public IApiComponent getApiComponent() {
        return (IApiComponent)this.getAncestor(1);
    }

    @Override
    public String getPackageName() {
        try {
            IApiType type = this.getEnclosingType();
            if (type != null) {
                return type.getPackageName();
            }
        }
        catch (CoreException coreException) {}
        return "";
    }

    public boolean equals(Object obj) {
        IApiElement element;
        if (obj instanceof IApiElement && (element = (IApiElement)obj).getType() == this.getType()) {
            return this.enclosingTypesEqual(this, element) && this.getName().equals(element.getName());
        }
        return false;
    }

    protected boolean enclosingTypesEqual(IApiElement e1, IApiElement e2) {
        IApiType t1 = (IApiType)e1.getAncestor(2);
        IApiType t2 = (IApiType)e2.getAncestor(2);
        if (t1 == null) {
            return t2 == null;
        }
        return t1.equals(t2);
    }

    public int hashCode() {
        IApiType enclosing = (IApiType)this.getAncestor(2);
        return this.getType() + this.getName().hashCode() + (enclosing == null ? 0 : enclosing.hashCode());
    }

    public void setModifiers(int access) {
        this.fFlags = access;
    }
}

