/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.ui.wizard.service;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.jboss.tools.common.ui.CommonUIMessages;
import org.jboss.tools.common.ui.CommonUIPlugin;
import org.jboss.tools.common.ui.wizard.service.NewServiceWizardPage;
import org.jboss.tools.common.ui.wizard.service.RegisterServiceUtil;

public class NewServiceCreationWizard
extends NewElementWizard {
    protected NewTypeWizardPage fPage;
    boolean openEditorAfterFinish = true;

    public NewServiceCreationWizard() {
        this.setWindowTitle(CommonUIMessages.NEW_SERVICE_WIZARD_TITLE);
    }

    public void setOpenEditorAfterFinish(boolean b) {
        this.openEditorAfterFinish = b;
    }

    public void addPages() {
        super.addPages();
        if (this.fPage == null) {
            this.fPage = new NewServiceWizardPage();
            ((NewClassWizardPage)this.fPage).init(this.getSelection());
        }
        this.addPage((IWizardPage)this.fPage);
    }

    protected boolean canRunForked() {
        return !this.fPage.isEnclosingTypeSelected();
    }

    public boolean performFinish() {
        IResource resource;
        boolean res = super.performFinish();
        if (res && ((NewServiceWizardPage)this.fPage).isToBeRegisteredInMetaInf()) {
            try {
                this.registerService();
            }
            catch (CoreException e) {
                CommonUIPlugin.getDefault().logError(e);
            }
        }
        if (res && this.openEditorAfterFinish && (resource = this.fPage.getModifiedResource()) != null) {
            this.selectAndReveal(resource);
            this.openResource((IFile)resource);
        }
        return res;
    }

    private void registerService() throws CoreException {
        IProject project = this.fPage.getCreatedType().getResource().getProject();
        String typeName = this.fPage.getCreatedType().getFullyQualifiedName();
        String serviceType = ((NewServiceWizardPage)this.fPage).getServiceRawType();
        RegisterServiceUtil.registerService(project, typeName, serviceType);
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.fPage.createType(monitor);
    }

    public IJavaElement getCreatedElement() {
        return this.fPage.getCreatedType();
    }
}

