/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.ui.actions.xpl;

import java.util.Iterator;
import java.util.ResourceBundle;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.SelectMarkerRulerAction;

public class SelectAnnotationRulerAction
extends SelectMarkerRulerAction {
    private ITextEditor fTextEditor;
    private Position fPosition;
    private boolean fHasCorrection;
    private ResourceBundle fBundle;

    public SelectAnnotationRulerAction(ResourceBundle bundle, String prefix, ITextEditor editor, IVerticalRulerInfo ruler) {
        super(bundle, prefix, editor, ruler);
        this.fBundle = bundle;
        this.fTextEditor = editor;
    }

    public void run() {
        this.runWithEvent(null);
    }

    public void runWithEvent(Event event) {
        if (this.fHasCorrection) {
            ITextOperationTarget operation = (ITextOperationTarget)this.fTextEditor.getAdapter(ITextOperationTarget.class);
            if (operation != null && operation.canDoOperation(22)) {
                this.fTextEditor.selectAndReveal(this.fPosition.getOffset(), this.fPosition.getLength());
                operation.doOperation(22);
            }
            return;
        }
        super.run();
    }

    public void update() {
        if (this.fTextEditor.getDocumentProvider() == null) {
            return;
        }
        this.findAnnotation();
        this.setEnabled(true);
        if (this.fHasCorrection) {
            this.initialize(this.fBundle, "SelectAnnotationRulerAction.QuickFix.");
            return;
        }
        this.initialize(this.fBundle, "SelectAnnotationRulerAction.GotoAnnotation.");
        super.update();
    }

    private void findAnnotation() {
        this.fPosition = null;
        this.fHasCorrection = false;
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        IAnnotationAccessExtension annotationAccess = this.getAnnotationAccessExtension();
        IDocument document = this.getDocument();
        if (model == null) {
            return;
        }
        Iterator iter = model.getAnnotationIterator();
        int layer = Integer.MIN_VALUE;
        while (iter.hasNext()) {
            boolean isReadOnly;
            Position position;
            Annotation annotation = (Annotation)iter.next();
            if (annotation.isMarkedDeleted()) continue;
            int annotationLayer = layer;
            if (annotationAccess != null && (annotationLayer = annotationAccess.getLayer(annotation)) < layer || !this.includesRulerLine(position = model.getPosition(annotation), document)) continue;
            boolean bl = isReadOnly = this.fTextEditor instanceof ITextEditorExtension && ((ITextEditorExtension)this.fTextEditor).isEditorInputReadOnly();
            if (isReadOnly) continue;
            this.fPosition = position;
            this.fHasCorrection = true;
            layer = annotationLayer;
        }
    }
}

