/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.target.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.jboss.ide.eclipse.freemarker.editor.SingleTokenScanner;
import org.jboss.ide.eclipse.freemarker.editor.partitions.PartitionType;
import org.jboss.ide.eclipse.freemarker.preferences.Preferences;
import org.jboss.ide.eclipse.freemarker.target.TargetMultiLineRule;
import org.jboss.ide.eclipse.freemarker.target.xml.XmlTagRule;

public enum XmlPartitionType {
    COMMENT(Preferences.PreferenceKey.COLOR_XML_COMMENT){

        @Override
        public IPredicateRule createPartitioningRule() {
            return new TargetMultiLineRule("<!--", "-->", (IToken)new Token((Object)this.name()), '\u0000', true);
        }
    }
    ,
    TAG(Preferences.PreferenceKey.COLOR_XML_TAG){

        @Override
        public IPredicateRule createPartitioningRule() {
            return new XmlTagRule((IToken)new Token((Object)this.name()));
        }
    }
    ,
    OTHER(Preferences.PreferenceKey.COLOR_TEXT){

        @Override
        public IPredicateRule createPartitioningRule() {
            return null;
        }
    };

    final Preferences.PreferenceKey foregroundPreferenceKey;
    private static final Map<String, XmlPartitionType> FAST_LOOKUP;

    static {
        XmlPartitionType[] partitionTypes = XmlPartitionType.values();
        HashMap<String, XmlPartitionType> fastLookUp = new HashMap<String, XmlPartitionType>();
        XmlPartitionType[] xmlPartitionTypeArray = partitionTypes;
        int n = partitionTypes.length;
        int n2 = 0;
        while (n2 < n) {
            XmlPartitionType partitionType = xmlPartitionTypeArray[n2];
            fastLookUp.put(partitionType.name(), partitionType);
            ++n2;
        }
        FAST_LOOKUP = Collections.unmodifiableMap(fastLookUp);
    }

    private XmlPartitionType(Preferences.PreferenceKey foregroundPreferenceKey) {
        this.foregroundPreferenceKey = foregroundPreferenceKey;
    }

    public abstract IPredicateRule createPartitioningRule();

    public ITokenScanner createColoringTokenizer() {
        return new SingleTokenScanner(PartitionType.createColoringToken(this.foregroundPreferenceKey));
    }

    public static XmlPartitionType fastValueOf(String name) {
        return FAST_LOOKUP.get(name);
    }

    /* synthetic */ XmlPartitionType(String string, int n, Preferences.PreferenceKey preferenceKey, XmlPartitionType xmlPartitionType) {
        this(preferenceKey);
    }
}

