/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.ISourceViewer;
import org.jboss.ide.eclipse.freemarker.Plugin;
import org.jboss.ide.eclipse.freemarker.model.Item;
import org.jboss.ide.eclipse.freemarker.model.ItemSet;

public abstract class AbstractItem
implements Item {
    private ITypedRegion region;
    private ISourceViewer viewer;
    private IResource resource;
    private List<Item> subDirectives;
    private Item parentItem;
    private final ItemSet itemSet;
    protected Item[] relatedItems;
    protected List<Item> relatedItemsArr;
    private String contents;
    private ContentWithOffset standardSplit;
    private String treeDisplay;
    private static final char[] descriptorTokens = new char[]{'/', '#', '@', '[', ']', '<', '>'};
    String firstToken = null;

    protected AbstractItem(ItemSet itemSet) {
        this.itemSet = itemSet;
    }

    @Override
    public final void load(ITypedRegion region, ISourceViewer viewer, IResource resource) {
        this.region = region;
        this.viewer = viewer;
        this.resource = resource;
        this.init(region, viewer, resource);
    }

    protected abstract void init(ITypedRegion var1, ISourceViewer var2, IResource var3);

    @Override
    public boolean isStartItem() {
        return false;
    }

    @Override
    public boolean isEndItem() {
        return false;
    }

    @Override
    public boolean relatesToItem(Item directive) {
        return false;
    }

    @Override
    public void relateItem(Item directive) {
        if (this.relatedItemsArr == null) {
            this.relatedItemsArr = new ArrayList<Item>();
        }
        this.relatedItemsArr.add(directive);
    }

    @Override
    public boolean isNestable() {
        return this.getContents() != null && !this.getContents().endsWith("/");
    }

    @Override
    public ITypedRegion getRegion() {
        return this.region;
    }

    @Override
    public List<Item> getChildItems() {
        if (this.subDirectives == null) {
            this.subDirectives = new ArrayList<Item>(0);
        }
        return this.subDirectives;
    }

    @Override
    public void addSubDirective(Item directive) {
        this.getChildItems().add(directive);
        directive.setParentItem(this);
    }

    public ISourceViewer getViewer() {
        return this.viewer;
    }

    protected Item getRelatedItem() {
        return null;
    }

    @Override
    public Item[] getRelatedItems() {
        if (this.relatedItems == null) {
            this.relatedItems = this.relatedItemsArr != null ? this.relatedItemsArr.toArray(new Item[this.relatedItemsArr.size()]) : (this.getRelatedItem() == null ? new Item[0] : new Item[]{this.getRelatedItem()});
        }
        return this.relatedItems;
    }

    @Override
    public String getContents() {
        if (this.contents == null) {
            this.contents = this.getFullContents();
            if (this.contents != null) {
                this.contents = this.contents.trim();
            }
        }
        return this.contents;
    }

    public ContentWithOffset splitContents(int offset) {
        if (offset == -1 && this.standardSplit != null) {
            return this.standardSplit;
        }
        String s = this.getFullContents();
        if (s == null) {
            return new ContentWithOffset(new String[0], -1, -1, -1, -1, -1, -1, false, false);
        }
        int actualIndex = 0;
        int actualIndexOffset = 0;
        int actualOffset = 0;
        int indexOffset = 0;
        int offsetCount = 0;
        int totalOffsetCount = 0;
        int spacesEncountered = 0;
        int totalSpacesEncountered = 0;
        int cursorPos = this.getCursorPosition(offset);
        ArrayList<String> arr = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        Stack<Character> currentStack = new Stack<Character>();
        boolean escape = false;
        boolean doEscape = false;
        boolean doAppend = true;
        boolean encounteredSpace = false;
        boolean nextCharSpace = false;
        int i = 0;
        while (i < s.length()) {
            encounteredSpace = false;
            char c = s.charAt(i);
            if (totalOffsetCount == cursorPos) {
                actualIndex = arr.size();
                actualOffset = totalOffsetCount;
                indexOffset = offsetCount;
                actualIndexOffset = offset - cursorPos - indexOffset;
                if (c == ' ') {
                    nextCharSpace = true;
                }
            }
            ++totalOffsetCount;
            if ((c == ' ' || c == '=' || c == '\r' || c == '\n') && current.length() != 0) {
                if (currentStack.size() == 0) {
                    arr.add(current.toString());
                    current = new StringBuilder();
                    offsetCount = 0;
                    if (c == '=') {
                        arr.add("=");
                        current = new StringBuilder();
                    } else {
                        encounteredSpace = true;
                        ++spacesEncountered;
                        ++totalSpacesEncountered;
                    }
                }
                doAppend = false;
            }
            if (!escape) {
                if (c == '\"') {
                    if (currentStack.size() > 0) {
                        if (((Character)currentStack.peek()).charValue() == '\"') {
                            currentStack.pop();
                        } else {
                            currentStack.push(Character.valueOf(c));
                        }
                    } else {
                        currentStack.push(Character.valueOf(c));
                    }
                } else if (c == '(') {
                    currentStack.push(Character.valueOf(c));
                } else if (c == ')') {
                    if (currentStack.size() > 0 && ((Character)currentStack.peek()).charValue() == ')') {
                        currentStack.pop();
                    }
                } else if (c == '{') {
                    currentStack.push(Character.valueOf(c));
                } else if (c == '}') {
                    if (currentStack.size() > 0 && ((Character)currentStack.peek()).charValue() == '{') {
                        currentStack.pop();
                    }
                } else if (c == '\\') {
                    doEscape = true;
                } else {
                    int j = 0;
                    while (j < this.getDescriptors().length) {
                        if (c == this.getDescriptors()[j]) {
                            doAppend = false;
                            break;
                        }
                        ++j;
                    }
                }
            }
            if (doAppend) {
                current.append(c);
                ++offsetCount;
            }
            escape = doEscape;
            doEscape = false;
            doAppend = true;
            ++i;
        }
        if (current.length() > 0) {
            arr.add(current.toString());
            if (totalOffsetCount == cursorPos) {
                actualOffset = totalOffsetCount;
                indexOffset = offsetCount;
                actualIndexOffset = offset - cursorPos - indexOffset;
            }
        } else if (arr.size() == 0) {
            arr.add("");
        }
        if (totalOffsetCount == cursorPos) {
            actualIndex = arr.size() - 1;
            actualOffset = totalOffsetCount;
            indexOffset = offsetCount;
            actualIndexOffset = offset - cursorPos - indexOffset;
        }
        ContentWithOffset contentWithOffset = new ContentWithOffset(arr.toArray(new String[arr.size()]), actualIndex, actualIndexOffset, indexOffset, actualOffset, spacesEncountered, totalSpacesEncountered, encounteredSpace, nextCharSpace);
        if (offset == -1) {
            this.standardSplit = contentWithOffset;
        }
        return contentWithOffset;
    }

    protected int getCursorPosition(int offset) {
        return offset - this.getOffset();
    }

    public String[] splitContents() {
        ContentWithOffset rtn = this.splitContents(-1);
        return rtn.getContents();
    }

    @Override
    public Item getParentItem() {
        return this.parentItem;
    }

    @Override
    public void setParentItem(Item parentItem) {
        this.parentItem = parentItem;
    }

    @Override
    public Item getStartItem() {
        return this;
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof Item) {
            return ((Item)arg0).getRegion().equals(this.getRegion());
        }
        return false;
    }

    public int hashCode() {
        return this.getRegion().hashCode();
    }

    @Override
    public String getTreeDisplay() {
        if (this.treeDisplay == null) {
            this.treeDisplay = this.getContents();
            if (this.treeDisplay != null && this.treeDisplay.length() > 0 && this.treeDisplay.charAt(this.treeDisplay.length() - 1) == '/') {
                this.treeDisplay = this.treeDisplay.substring(0, this.treeDisplay.length() - 1);
            }
            this.treeDisplay = this.treeDisplay.trim();
        }
        return this.treeDisplay;
    }

    @Override
    public String getTreeImage() {
        return null;
    }

    @Override
    public boolean isStartAndEndItem() {
        return false;
    }

    public String getSplitValue(int index) {
        String[] values = this.splitContents();
        if (values != null && values.length > index) {
            return values[index];
        }
        return null;
    }

    @Override
    public ICompletionProposal[] getCompletionProposals(int offset, Map<String, Class<?>> context) {
        return null;
    }

    public char[] getDescriptors() {
        return descriptorTokens;
    }

    public ItemSet getItemSet() {
        return this.itemSet;
    }

    public String getFullContents() {
        try {
            return this.viewer.getDocument().get(this.region.getOffset(), this.region.getLength());
        }
        catch (BadLocationException e) {
            Plugin.log(e);
            return null;
        }
    }

    public int getOffset() {
        return this.getRegion().getOffset();
    }

    public int getLength() {
        return this.getRegion().getLength();
    }

    @Override
    public String getFirstToken() {
        if (this.firstToken == null) {
            StringBuilder sb = new StringBuilder();
            String content = this.getContents();
            int i = 0;
            while (i < content.length()) {
                char c = content.charAt(i);
                if (c == '\"') {
                    return null;
                }
                if (c == '?') {
                    this.firstToken = sb.toString();
                    break;
                }
                if (c == ' ' || c == '(' || c == ')' && sb.length() > 0) {
                    this.firstToken = sb.toString();
                    break;
                }
                sb.append(c);
                ++i;
            }
        }
        return this.firstToken;
    }

    public IResource getResource() {
        return this.resource;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    @Override
    public void addToContext(Map<String, Class<?>> context) {
    }

    @Override
    public void removeFromContext(Map<String, Class<?>> context) {
    }

    @Override
    public Item getEndItem() {
        return null;
    }

    @Override
    public String getName() {
        return this.getFirstToken();
    }

    public class ContentWithOffset {
        private String[] contents;
        private int index;
        private int indexOffset;
        private int offsetInIndex;
        private int offset;
        private int spacesEncountered;
        private int totalSpacesEncountered;
        private boolean wasLastCharSpace;
        private boolean isNextCharSpace;

        public ContentWithOffset(String[] contents, int index, int indexOffset, int offsetInIndex, int offset, int spacesEncountered, int totalSpacesEncountered, boolean wasLastCharSpace, boolean isNextCharSpace) {
            this.contents = contents;
            this.index = index;
            this.offsetInIndex = offsetInIndex;
            this.indexOffset = indexOffset;
            this.offset = offset;
            this.spacesEncountered = spacesEncountered;
            this.totalSpacesEncountered = totalSpacesEncountered;
            this.wasLastCharSpace = wasLastCharSpace;
            this.isNextCharSpace = isNextCharSpace;
        }

        public String[] getContents() {
            return this.contents;
        }

        public void setContents(String[] contents) {
            this.contents = contents;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public int getOffsetInIndex() {
            return this.offsetInIndex;
        }

        public int getSpacesEncountered() {
            return this.spacesEncountered;
        }

        public int getTotalSpacesEncountered() {
            return this.totalSpacesEncountered;
        }

        public boolean wasLastCharSpace() {
            return this.wasLastCharSpace;
        }

        public boolean isNextCharSpace() {
            return this.isNextCharSpace;
        }

        public int getIndexOffset() {
            return this.indexOffset;
        }
    }
}

