/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.linetracker;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.ui.console.FileLink;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.console.IHyperlink;
import org.jboss.ide.eclipse.freemarker.Plugin;

public class ConsoleLineTracker
implements IConsoleLineTracker {
    private IConsole console;
    private static final String CHECK = "freemarker";
    private static final String CHECK_LINE = "line:";
    private static final String CHECK_LINE2 = "on line ";
    private static final String CHECK_TEMPLATE = "template:";
    private static final String CHECK_TEMPLATE2 = " in ";

    public void init(IConsole cons) {
        this.console = cons;
    }

    public void lineAppended(IRegion line) {
        block14: {
            try {
                IFile file;
                int i2;
                String text = this.console.getDocument().get(line.getOffset(), line.getLength());
                if (text.indexOf(CHECK) < 0) break block14;
                int i1 = text.lastIndexOf(CHECK_TEMPLATE);
                if (i1 < 0 && (i2 = text.lastIndexOf(CHECK_LINE2)) >= 0) {
                    i1 = text.indexOf(CHECK_TEMPLATE2, i2);
                    i1 -= 6;
                }
                if (i1 <= 0) break block14;
                int linkOffset = i1 + 10;
                int linkLength = text.length() - linkOffset;
                String fileName = text.substring(linkOffset, text.length()).trim();
                if (fileName.endsWith(".")) {
                    fileName = fileName.substring(0, fileName.length() - 1);
                }
                int lineNumber = -1;
                try {
                    int i3;
                    int i22 = text.lastIndexOf(CHECK_LINE);
                    if (i22 > 0) {
                        i3 = text.indexOf(",", i22 += CHECK_LINE.length());
                        if (i3 > 0) {
                            lineNumber = Integer.parseInt(text.substring(i22, i3).trim());
                        }
                    } else {
                        i22 = text.lastIndexOf(CHECK_LINE2);
                        if (i22 > 0 && (i3 = text.indexOf(",", i22 += CHECK_LINE2.length())) > 0) {
                            lineNumber = Integer.parseInt(text.substring(i22, i3).trim());
                        }
                    }
                }
                catch (Exception e) {
                    Plugin.log(e);
                }
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                ArrayList<IResource> files = new ArrayList<IResource>();
                int i = 0;
                while (i < projects.length) {
                    IProject project = projects[i];
                    JavaCore.create((IProject)project);
                    fileName = fileName.replace('\\', '/');
                    try {
                        this.populateMatchingFiles((IContainer)project, files, fileName.split("/"));
                    }
                    catch (CoreException e) {
                        Plugin.log(e);
                    }
                    ++i;
                }
                if (files.size() != 0 && (file = (IFile)files.get(0)) != null && file.exists()) {
                    FileLink link = new FileLink(file, null, -1, -1, lineNumber);
                    this.console.addLink((IHyperlink)link, linkOffset, linkLength);
                }
            }
            catch (BadLocationException e) {
                Plugin.log(e);
            }
        }
    }

    public void populateMatchingFiles(IContainer container, List<IResource> files, String[] fileNameSeq) throws CoreException {
        IResource[] resources = container.members();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource instanceof IContainer) {
                this.populateMatchingFiles((IContainer)resource, files, fileNameSeq);
            } else if (resource instanceof IFile && ConsoleLineTracker.isCorrectFile((IFile)resource, fileNameSeq)) {
                boolean doAdd = true;
                try {
                    IJavaProject javaProject = JavaCore.create((IProject)resource.getProject());
                    if (javaProject.getOutputLocation().isPrefixOf(((IFile)resource).getFullPath())) {
                        doAdd = false;
                    }
                }
                catch (JavaModelException e) {
                    Plugin.log(e);
                }
                if (doAdd) {
                    files.add(resource);
                }
            }
            ++i;
        }
    }

    private static boolean isCorrectFile(IFile file, String[] filenameSeqs) {
        IFile temp = file;
        int i = filenameSeqs.length - 1;
        while (i >= 0) {
            String seq = filenameSeqs[i];
            if (!seq.equals(temp.getName())) {
                return false;
            }
            temp = temp.getParent();
            --i;
        }
        return true;
    }

    public void dispose() {
    }
}

