/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.editor.partitions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.jboss.ide.eclipse.freemarker.editor.ContentScanner;
import org.jboss.ide.eclipse.freemarker.editor.Editor;
import org.jboss.ide.eclipse.freemarker.editor.SingleTokenScanner;
import org.jboss.ide.eclipse.freemarker.editor.partitions.CommentPartitionRule;
import org.jboss.ide.eclipse.freemarker.editor.partitions.DirectiveEndPartitionRule;
import org.jboss.ide.eclipse.freemarker.editor.partitions.DirectiveStartPartitionRule;
import org.jboss.ide.eclipse.freemarker.editor.partitions.InterpolationRule;
import org.jboss.ide.eclipse.freemarker.editor.partitions.MacroInstanceEndPartitionRule;
import org.jboss.ide.eclipse.freemarker.editor.partitions.MacroInstanceStartPartitionRule;
import org.jboss.ide.eclipse.freemarker.editor.rules.DirectiveRule;
import org.jboss.ide.eclipse.freemarker.editor.rules.DirectiveRuleEnd;
import org.jboss.ide.eclipse.freemarker.lang.Directive;
import org.jboss.ide.eclipse.freemarker.preferences.Preferences;
import org.jboss.ide.eclipse.freemarker.target.TargetColoringScanner;

public enum PartitionType {
    COMMENT(Preferences.PreferenceKey.COLOR_COMMENT){

        @Override
        public IPredicateRule createPartitioningRule() {
            return new CommentPartitionRule();
        }
    }
    ,
    DOLLAR_INTERPOLATION(Preferences.PreferenceKey.COLOR_INTERPOLATION){

        @Override
        public IPredicateRule createPartitioningRule() {
            return new InterpolationRule('$', (IToken)new Token((Object)this.name()));
        }
    }
    ,
    HASH_INTERPOLATION(Preferences.PreferenceKey.COLOR_INTERPOLATION){

        @Override
        public IPredicateRule createPartitioningRule() {
            return new InterpolationRule('#', (IToken)new Token((Object)this.name()));
        }
    }
    ,
    DIRECTIVE_START(Preferences.PreferenceKey.COLOR_DIRECTIVE){

        public RuleBasedScanner createItemParser() {
            ArrayList<DirectiveRule> rules = new ArrayList<DirectiveRule>();
            Directive[] directiveArray = Directive.values();
            int n = directiveArray.length;
            int n2 = 0;
            while (n2 < n) {
                Directive directive = directiveArray[n2];
                rules.add(new DirectiveRule(directive));
                ++n2;
            }
            RuleBasedScanner result = new RuleBasedScanner();
            result.setRules(rules.toArray(new IRule[rules.size()]));
            return result;
        }

        @Override
        public IPredicateRule createPartitioningRule() {
            return new DirectiveStartPartitionRule();
        }

        @Override
        public ITokenScanner createColoringTokenizer(Editor editor) {
            return new ContentScanner(4.createColoringToken(this.foregroundPreferenceKey));
        }
    }
    ,
    DIRECTIVE_END(Preferences.PreferenceKey.COLOR_DIRECTIVE){

        public RuleBasedScanner createItemParser() {
            ArrayList<DirectiveRuleEnd> rules = new ArrayList<DirectiveRuleEnd>();
            rules.add(new DirectiveRuleEnd(Directive.IF_END));
            rules.add(new DirectiveRuleEnd(Directive.FUNCTION_END));
            rules.add(new DirectiveRuleEnd(Directive.LIST_END));
            rules.add(new DirectiveRuleEnd(Directive.MACRO_END));
            rules.add(new DirectiveRuleEnd(Directive.SWITCH_END));
            rules.add(new DirectiveRuleEnd(Directive.ASSIGN_END));
            rules.add(new DirectiveRuleEnd(Directive.LOCAL_END));
            rules.add(new DirectiveRuleEnd(Directive.GLOBAL_END));
            RuleBasedScanner result = new RuleBasedScanner();
            result.setRules(rules.toArray(new IRule[rules.size()]));
            return result;
        }

        @Override
        public IPredicateRule createPartitioningRule() {
            return new DirectiveEndPartitionRule();
        }
    }
    ,
    MACRO_INSTANCE_START(Preferences.PreferenceKey.COLOR_DIRECTIVE){

        @Override
        public IPredicateRule createPartitioningRule() {
            return new MacroInstanceStartPartitionRule();
        }

        @Override
        public ITokenScanner createColoringTokenizer(Editor editor) {
            return new ContentScanner(6.createColoringToken(this.foregroundPreferenceKey));
        }
    }
    ,
    MACRO_INSTANCE_END(Preferences.PreferenceKey.COLOR_DIRECTIVE){

        @Override
        public IPredicateRule createPartitioningRule() {
            return new MacroInstanceEndPartitionRule();
        }
    }
    ,
    TEXT(Preferences.PreferenceKey.COLOR_TEXT){

        @Override
        public IPredicateRule createPartitioningRule() {
            return null;
        }

        @Override
        public ITokenScanner createColoringTokenizer(Editor editor) {
            return new TargetColoringScanner(editor);
        }
    };

    public static final String[] PARTITION_TYPES;
    private static final Map<String, PartitionType> FAST_LOOKUP;
    final Preferences.PreferenceKey foregroundPreferenceKey;

    static {
        PartitionType[] partitionTypes = PartitionType.values();
        PARTITION_TYPES = new String[partitionTypes.length];
        HashMap<String, PartitionType> fastLookUp = new HashMap<String, PartitionType>();
        int i = 0;
        while (i < partitionTypes.length) {
            PartitionType partitionType = partitionTypes[i];
            PartitionType.PARTITION_TYPES[i] = partitionType.name();
            fastLookUp.put(partitionType.name(), partitionType);
            ++i;
        }
        FAST_LOOKUP = Collections.unmodifiableMap(fastLookUp);
    }

    public static IToken createColoringToken(Preferences.PreferenceKey foregroundPreferenceKey) {
        return new Token((Object)new TextAttribute(Preferences.getInstance().getColor(foregroundPreferenceKey)));
    }

    public static PartitionType fastValueOf(String name) {
        return FAST_LOOKUP.get(name);
    }

    private PartitionType(Preferences.PreferenceKey foregroundPreferenceKey) {
        this.foregroundPreferenceKey = foregroundPreferenceKey;
    }

    public ITokenScanner createColoringTokenizer(Editor editor) {
        return new SingleTokenScanner(PartitionType.createColoringToken(this.foregroundPreferenceKey));
    }

    public abstract IPredicateRule createPartitioningRule();

    public ITokenScanner createItemParser() {
        return null;
    }

    /* synthetic */ PartitionType(String string, int n, Preferences.PreferenceKey preferenceKey, PartitionType partitionType) {
        this(preferenceKey);
    }
}

