/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.jboss.ide.eclipse.freemarker.editor.Editor;
import org.jboss.ide.eclipse.freemarker.editor.IncludeHyperlink;
import org.jboss.ide.eclipse.freemarker.model.GenericDirective;
import org.jboss.ide.eclipse.freemarker.model.Item;

public class IncludeHyperlinkDetector
implements IHyperlinkDetector {
    private Editor editor;

    public IncludeHyperlinkDetector(ITextViewer textViewer, Editor editor) {
        this.editor = editor;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        String[] splitContents;
        GenericDirective genericDirective;
        Item item = this.editor.getItemSet().getItem(region.getOffset());
        if (item instanceof GenericDirective && "include".equals((genericDirective = (GenericDirective)item).getName()) && (splitContents = genericDirective.splitContents()).length > 1) {
            String text = splitContents[1].replace("\"", "");
            IFile file = genericDirective.getResource().getParent().getFile((IPath)new Path(text));
            if (file.exists()) {
                return new IHyperlink[]{new IncludeHyperlink(item, file)};
            }
        }
        return null;
    }

    public void init(ITextViewer viewer) {
    }
}

